/*
 * Decompiled with CFR 0.152.
 */
package io.github.sakurawald.fuji.module.mixin.core.event;

import com.google.common.collect.EvictingQueue;
import io.github.sakurawald.fuji.core.auxiliary.minecraft.RegistryHelper;
import io.github.sakurawald.fuji.core.event.EventManager;
import io.github.sakurawald.fuji.core.event.annotation.EventProducer;
import io.github.sakurawald.fuji.core.event.message.player.PlayerChatMessageSentEvent;
import java.util.Objects;
import java.util.Queue;
import net.minecraft.class_2556;
import net.minecraft.class_3222;
import net.minecraft.class_3244;
import net.minecraft.class_7471;
import org.jetbrains.annotations.NotNull;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_3244.class}, priority=0)
public abstract class PlayerChatMessageSentEventMixin_LOWEST {
    @Unique
    private static final Queue<Long> DUPLICATED_SENT_TEXT_FILTER = EvictingQueue.create((int)8);

    @Shadow
    public abstract class_3222 method_32311();

    @Unique
    private static long toUniqueKey(@NotNull class_7471 signedMessage, class_2556.class_7602 parameters) {
        String messageTypeString = RegistryHelper.getIdAsString(parameters);
        return Objects.hash(signedMessage.hashCode(), messageTypeString.hashCode());
    }

    @Inject(method={"sendChatMessage"}, at={@At(value="RETURN")})
    @EventProducer(value=PlayerChatMessageSentEvent.class, injectorPriority=0)
    void producePlayerChatMessageSentEvent(class_7471 signedMessage, class_2556.class_7602 parameters, CallbackInfo ci) {
        long uniqueKey = PlayerChatMessageSentEventMixin_LOWEST.toUniqueKey(signedMessage, parameters);
        if (DUPLICATED_SENT_TEXT_FILTER.contains(uniqueKey)) {
            return;
        }
        DUPLICATED_SENT_TEXT_FILTER.add(uniqueKey);
        class_3222 receiverPlayer = this.method_32311();
        PlayerChatMessageSentEvent event = new PlayerChatMessageSentEvent(receiverPlayer, signedMessage, parameters);
        EventManager.dispatchEvent(PlayerChatMessageSentEvent.class, event, 0);
    }
}

