/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.core.auxiliary.minecraft;

import eu.pb4.sgui.api.elements.GuiElementBuilder;
import eu.pb4.sgui.api.elements.GuiElementBuilderInterface;
import eu.pb4.sgui.api.elements.GuiElementInterface;
import eu.pb4.sgui.api.gui.SlotGuiInterface;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import mod.fuji.core.auxiliary.AsyncUtil;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.minecraft.AuthlibHelper;
import mod.fuji.core.auxiliary.minecraft.ItemStackHelper;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.config.mapper.wrapper.GameProfileWrapper;
import mod.fuji.core.service.cache.service.GameProfileCacheService;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1735;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GuiHelper {
    public static GuiElementBuilder hideTooltip(GuiElementBuilder builder) {
        builder.hideFlags();
        return builder;
    }

    public static class Material {
        public static class_1792 fromBooleanValue(boolean value) {
            return value ? class_1802.field_8734 : class_1802.field_8636;
        }
    }

    private static class Texture {
        private static final String REIMU_HAKUREI_TEXTURE = "ewogICJ0aW1lc3RhbXAiIDogMTYyMDIyMDc4MTQyNCwKICAicHJvZmlsZUlkIiA6ICJiYjdjY2E3MTA0MzQ0NDEyOGQzMDg5ZTEzYmRmYWI1OSIsCiAgInByb2ZpbGVOYW1lIiA6ICJsYXVyZW5jaW8zMDMiLAogICJzaWduYXR1cmVSZXF1aXJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZjVmMTcyMGM3ODBhNzk1OGI0MWYxNTNlNTA2OWRiNjg2MWJkMjgxYmU0MzJlN2JjNzk0MTE0YTdmNGVjNTJmZCIsCiAgICAgICJtZXRhZGF0YSIgOiB7CiAgICAgICAgIm1vZGVsIiA6ICJzbGltIgogICAgICB9CiAgICB9CiAgfQp9";
        private static final String LUCKY_BLOCK_TEXTURE = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOWQ5Y2M1OGFkMjVhMWFiMTZkMzZiYjVkNmQ0OTNjOGY1ODk4YzJiZjMwMmI2NGUzMjU5MjFjNDFjMzU4NjcifX19";
        private static final String PREVIOUS_PAGE_TEXTURE = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWYxMzNlOTE5MTlkYjBhY2VmZGMyNzJkNjdmZDg3YjRiZTg4ZGM0NGE5NTg5NTg4MjQ0NzRlMjFlMDZkNTNlNiJ9fX0=";
        private static final String NEXT_PAGE_TEXTURE = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTNmYzUyMjY0ZDhhZDllNjU0ZjQxNWJlZjAxYTIzOTQ3ZWRiY2NjY2Y2NDkzNzMyODliZWE0ZDE0OTU0MWY3MCJ9fX0=";
        private static final String PLUS_TEXTURE = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDdhMGZjNmRjZjczOWMxMWZlY2U0M2NkZDE4NGRlYTc5MWNmNzU3YmY3YmQ5MTUzNmZkYmM5NmZhNDdhY2ZiIn19fQ==";
        private static final String HEART_TEXTURE = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMDlhNTJjYjUwOTkyZDgzYzU1OTlmZDZlNDFhNmNlOTljZjdmMWU2MjAzNjExOTYzZGMyYzJmZGEwYjU1NTgzIn19fQ==";
        private static final String LETTER_A_TEXTURE = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDJjZDVhMWI1Mjg4Y2FhYTIxYTZhY2Q0Yzk4Y2VhZmQ0YzE1ODhjOGIyMDI2Yzg4YjcwZDNjMTU0ZDM5YmFiIn19fQ==";
        private static final String LETTER_I_TEXTURE = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTc2OWUyYzEzNGVlNWZjNmRhZWZlNDEyZTRhZjNkNTdkZjlkYmIzY2FhY2Q4ZTM2ZTU5OTk3OWVjMWFjNCJ9fX0=";
        private static final String QUESTION_MARK_TEXTURE = "eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZmMyNzEwNTI3MTllZjY0MDc5ZWU4YzE0OTg5NTEyMzhhNzRkYWM0YzI3Yjk1NjQwZGI2ZmJkZGMyZDZiNWI2ZSJ9fX0=";

        private Texture() {
        }
    }

    public static class Placer {
        public static void fillEmptySlots(@NotNull SlotGuiInterface gui, @NotNull GuiElementBuilder builder) {
            Placer.fillEmptySlots(gui, (GuiElementInterface)builder.build());
        }

        public static void fillEmptySlots(@NotNull SlotGuiInterface gui, @NotNull GuiElementInterface guiElementInterface) {
            for (int i = 0; i < gui.getSize(); ++i) {
                GuiElementInterface slot = gui.getSlot(i);
                if (!Validator.isBlankSlot(slot)) continue;
                gui.setSlot(i, guiElementInterface);
            }
        }

        public static void setSlotInLastLine(@NotNull SlotGuiInterface gui, int inlineOffset, @NotNull GuiElementBuilder elementBuilder) {
            Placer.setSlotInLastLine(gui, inlineOffset, (GuiElementInterface)elementBuilder.build());
        }

        public static void setSlotInLastLine(@NotNull SlotGuiInterface gui, int inlineOffset, @NotNull GuiElementInterface element) {
            int lastLineIndex = gui.getHeight() - 1;
            Placer.setSlotInSpecifiedLine(gui, lastLineIndex, inlineOffset, element);
        }

        public static void setSlotInSpecifiedLine(@NotNull SlotGuiInterface gui, int lineIndex, int inlineOffset, @NotNull GuiElementInterface element) {
            int baseIndex = lineIndex * gui.getWidth();
            int slotIndex = baseIndex + inlineOffset;
            gui.setSlot(slotIndex, element);
        }

        public static void fillLastLineIfEmpty(@NotNull SlotGuiInterface gui, @NotNull GuiElementInterface element) {
            Placer.fillLastLineIf(gui, element, ($gui, slotIndex) -> Optional.ofNullable($gui.getSlot(slotIndex.intValue())).map(GuiElementInterface::getItemStack).map(class_1799::method_7960).orElse(true));
        }

        public static void fillLastLineIf(@NotNull SlotGuiInterface gui, @NotNull GuiElementInterface element, @NotNull BiPredicate<SlotGuiInterface, Integer> predicate) {
            int lastLineIndex = gui.getHeight() - 1;
            Placer.fillLineIf(gui, lastLineIndex, element, predicate);
        }

        public static void fillLine(@NotNull SlotGuiInterface gui, int lineIndex, @NotNull GuiElementInterface element) {
            Placer.fillLineIf(gui, lineIndex, element, (a, b) -> true);
        }

        public static void fillLineIf(@NotNull SlotGuiInterface gui, int lineIndex, @NotNull GuiElementInterface element, @NotNull BiPredicate<SlotGuiInterface, Integer> predicate) {
            int baseIndex;
            int lineWidth = gui.getWidth();
            for (int i = baseIndex = lineIndex * lineWidth; i < baseIndex + lineWidth; ++i) {
                if (!predicate.test(gui, i)) continue;
                gui.setSlot(i, element);
            }
        }

        public static void fillGui(@NotNull SlotGuiInterface gui, @NotNull class_1799 itemStack) {
            for (int i = 0; i < gui.getSize(); ++i) {
                gui.setSlot(i, itemStack);
            }
        }

        public static List<GuiElementInterface> makeLinePaddingElements(int filledSlotsSize) {
            int LINE_SIZE = 9;
            int remainder = filledSlotsSize % 9;
            if (remainder == 0) {
                return List.of();
            }
            ArrayList<GuiElementInterface> elements = new ArrayList<GuiElementInterface>();
            int unfilledSlotsSize = 9 - remainder;
            for (int i = 0; i < unfilledSlotsSize; ++i) {
                elements.add(Button.makeSlotPlaceholderButton());
            }
            return elements;
        }
    }

    public static class Button {
        public static GuiElementInterface makeSlotPlaceholderButton() {
            return GuiHelper.hideTooltip(new GuiElementBuilder().setItem(class_1802.field_8871)).build();
        }

        public static GuiElementBuilder makePlayerHeadButton(String skullOwner) {
            return new GuiElementBuilder().setItem(class_1802.field_8575).setSkullOwner(skullOwner);
        }

        public static GuiElementBuilder makePreviousPageButton(class_3222 player) {
            return Button.makePlayerHeadButton("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWYxMzNlOTE5MTlkYjBhY2VmZGMyNzJkNjdmZDg3YjRiZTg4ZGM0NGE5NTg5NTg4MjQ0NzRlMjFlMDZkNTNlNiJ9fX0=").setName(TextHelper.getTextByKey(player, "previous_page", new Object[0]));
        }

        public static GuiElementBuilder makeNextPageButton(class_3222 player) {
            return Button.makePlayerHeadButton("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZTNmYzUyMjY0ZDhhZDllNjU0ZjQxNWJlZjAxYTIzOTQ3ZWRiY2NjY2Y2NDkzNzMyODliZWE0ZDE0OTU0MWY3MCJ9fX0=").setName(TextHelper.getTextByKey(player, "next_page", new Object[0]));
        }

        public static GuiElementBuilder makeBackButton(class_3222 player) {
            return Button.makePlayerHeadButton("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNWYxMzNlOTE5MTlkYjBhY2VmZGMyNzJkNjdmZDg3YjRiZTg4ZGM0NGE5NTg5NTg4MjQ0NzRlMjFlMDZkNTNlNiJ9fX0=").setName(TextHelper.getTextByKey(player, "back", new Object[0]));
        }

        public static GuiElementBuilder makeSearchButton(class_3222 player) {
            return new GuiElementBuilder().setItem(class_1802.field_8251).setName(TextHelper.getTextByKey(player, "search", new Object[0])).setLore(TextHelper.getTextListByKey(player, "search.lore")).glow();
        }

        public static GuiElementBuilder makeAddButton(class_3222 player) {
            return Button.makePlayerHeadButton("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDdhMGZjNmRjZjczOWMxMWZlY2U0M2NkZDE4NGRlYTc5MWNmNzU3YmY3YmQ5MTUzNmZkYmM5NmZhNDdhY2ZiIn19fQ==").setName(TextHelper.getTextByKey(player, "add", new Object[0]));
        }

        public static GuiElementBuilder makeHelpButton(class_3222 player) {
            return Button.makeQuestionMarkButton().setName(TextHelper.getTextByKey(player, "help", new Object[0]));
        }

        public static GuiElementBuilder makeInfoButton(class_3222 player) {
            return Button.makeLetterIButton().setName(TextHelper.getTextByKey(player, "info", new Object[0]));
        }

        public static GuiElementBuilder makeLuckyBlockButton() {
            return Button.makePlayerHeadButton("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOWQ5Y2M1OGFkMjVhMWFiMTZkMzZiYjVkNmQ0OTNjOGY1ODk4YzJiZjMwMmI2NGUzMjU5MjFjNDFjMzU4NjcifX19");
        }

        public static GuiElementBuilder makeQuestionMarkButton() {
            return Button.makePlayerHeadButton("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZmMyNzEwNTI3MTllZjY0MDc5ZWU4YzE0OTg5NTEyMzhhNzRkYWM0YzI3Yjk1NjQwZGI2ZmJkZGMyZDZiNWI2ZSJ9fX0=");
        }

        public static GuiElementBuilder makeHeartButton() {
            return Button.makePlayerHeadButton("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvMDlhNTJjYjUwOTkyZDgzYzU1OTlmZDZlNDFhNmNlOTljZjdmMWU2MjAzNjExOTYzZGMyYzJmZGEwYjU1NTgzIn19fQ==");
        }

        public static GuiElementBuilder makeLetterAButton() {
            return Button.makePlayerHeadButton("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvNDJjZDVhMWI1Mjg4Y2FhYTIxYTZhY2Q0Yzk4Y2VhZmQ0YzE1ODhjOGIyMDI2Yzg4YjcwZDNjMTU0ZDM5YmFiIn19fQ==");
        }

        public static GuiElementBuilder makeLetterIButton() {
            return Button.makePlayerHeadButton("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOTc2OWUyYzEzNGVlNWZjNmRhZWZlNDEyZTRhZjNkNTdkZjlkYmIzY2FhY2Q4ZTM2ZTU5OTk3OWVjMWFjNCJ9fX0=");
        }

        public static GuiElementBuilder makeModIconButton() {
            return Button.makePlayerHeadButton("ewogICJ0aW1lc3RhbXAiIDogMTYyMDIyMDc4MTQyNCwKICAicHJvZmlsZUlkIiA6ICJiYjdjY2E3MTA0MzQ0NDEyOGQzMDg5ZTEzYmRmYWI1OSIsCiAgInByb2ZpbGVOYW1lIiA6ICJsYXVyZW5jaW8zMDMiLAogICJzaWduYXR1cmVSZXF1aXJlZCIgOiB0cnVlLAogICJ0ZXh0dXJlcyIgOiB7CiAgICAiU0tJTiIgOiB7CiAgICAgICJ1cmwiIDogImh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvZjVmMTcyMGM3ODBhNzk1OGI0MWYxNTNlNTA2OWRiNjg2MWJkMjgxYmU0MzJlN2JjNzk0MTE0YTdmNGVjNTJmZCIsCiAgICAgICJtZXRhZGF0YSIgOiB7CiAgICAgICAgIm1vZGVsIiA6ICJzbGltIgogICAgICB9CiAgICB9CiAgfQp9");
        }
    }

    public static class Validator {
        private static final class_1792 BANNED_SLOT_PLACEHOLDER_ITEM = class_1802.field_8077;

        public static boolean isBlankSlot(@Nullable GuiElementInterface slot) {
            if (slot == null) {
                return true;
            }
            if (slot.getItemStack() == null) {
                return true;
            }
            return slot.getItemStack().method_7960();
        }

        public static boolean isValidSlotIndex(@NotNull SlotGuiInterface gui, int slotIndex) {
            return slotIndex >= 0 && slotIndex < gui.getSize();
        }

        public static boolean isBannedSlotIndex(@NotNull class_1703 screenHandler, int index) {
            if (index < 0 || index >= screenHandler.field_7761.size()) {
                return false;
            }
            class_1735 slot = screenHandler.method_7611(index);
            class_1799 stack = slot.method_7677();
            return Validator.isBannedSlotPlaceholder(stack);
        }

        public static class_1799 makeBannedSlotPlaceholderItemStack() {
            return Validator.makeBannedSlotPlaceholder().getItemStack();
        }

        public static boolean isBannedSlotPlaceholder(class_1799 stack) {
            return stack.method_7909().equals(BANNED_SLOT_PLACEHOLDER_ITEM);
        }

        public static GuiElementInterface makeBannedSlotPlaceholder() {
            return GuiHelper.hideTooltip(new GuiElementBuilder().setItem(BANNED_SLOT_PLACEHOLDER_ITEM)).build();
        }
    }

    public static class PlayerSkull {
        private static GuiElementBuilder fromSlot(@NotNull GuiElementInterface slot) {
            GuiElementBuilder builder = new GuiElementBuilder();
            class_1799 itemStack = slot.getItemStack();
            builder.setItem(itemStack.method_7909());
            builder.setName(itemStack.method_7964());
            List<class_2561> lore = ItemStackHelper.Lore.getLore(itemStack);
            if (!lore.isEmpty()) {
                builder.setLore(lore);
            }
            builder.setCallback(slot.getGuiCallback());
            return builder;
        }

        public static void fillPlayerHeadTextures(@NotNull SlotGuiInterface gui) {
            PlayerSkull.fillPlayerHeadTextures(gui, () -> {});
        }

        public static void fillPlayerHeadTextures(@NotNull SlotGuiInterface gui, @NotNull Runnable onCompleteCallback) {
            int logicalSize = gui.getWidth() * (gui.getHeight() - 1);
            int i = 0;
            while (i < logicalSize) {
                GuiElementInterface previousSlot = gui.getSlot(i);
                if (previousSlot == null) {
                    return;
                }
                int finalI = i++;
                AsyncUtil.runAsyncAndHandleExceptions(() -> {
                    class_1799 itemStack = previousSlot.getItemStack();
                    if (!itemStack.method_7909().equals(class_1802.field_8575)) {
                        return;
                    }
                    String onlinePlayerName = itemStack.method_7964().getString().trim();
                    @NotNull GameProfileWrapper gameProfileWrapper = GameProfileCacheService.getCachedGameProfile(onlinePlayerName);
                    GuiElementBuilder builder = PlayerSkull.fromSlot(previousSlot);
                    String texturesValue = gameProfileWrapper.getProperties().toVanillaType().get((Object)"textures").stream().findFirst().map(AuthlibHelper::getPropertyValue).orElse("eyJ0ZXh0dXJlcyI6eyJTS0lOIjp7InVybCI6Imh0dHA6Ly90ZXh0dXJlcy5taW5lY3JhZnQubmV0L3RleHR1cmUvOWQ5Y2M1OGFkMjVhMWFiMTZkMzZiYjVkNmQ0OTNjOGY1ODk4YzJiZjMwMmI2NGUzMjU5MjFjNDFjMzU4NjcifX19");
                    builder.setSkullOwner(texturesValue, null, gameProfileWrapper.getId());
                    for (int j = 0; j < logicalSize; ++j) {
                        @Nullable GuiElementInterface currentSlot = gui.getSlot(j);
                        if (currentSlot == null || currentSlot.getItemStack() != previousSlot.getItemStack()) continue;
                        gui.setSlot(finalI, (GuiElementBuilderInterface)builder);
                        break;
                    }
                    onCompleteCallback.run();
                });
            }
        }
    }

    public static class Handler {
        public static class_3917<class_1707> getGenericContainerType(int rows) {
            if (rows == 1) {
                return class_3917.field_18664;
            }
            if (rows == 2) {
                return class_3917.field_18665;
            }
            if (rows == 3) {
                return class_3917.field_17326;
            }
            if (rows == 4) {
                return class_3917.field_18666;
            }
            if (rows == 5) {
                return class_3917.field_18667;
            }
            if (rows == 6) {
                return class_3917.field_17327;
            }
            LogUtil.warn("The rows {} should be in the range [1, 6]. Falling back to GENERIC_9X6.", rows);
            return class_3917.field_17327;
        }

        public static int getGenericContainerRows(class_3917<class_1707> screenHandlerType) {
            if (screenHandlerType == class_3917.field_18664) {
                return 1;
            }
            if (screenHandlerType == class_3917.field_18665) {
                return 2;
            }
            if (screenHandlerType == class_3917.field_17326) {
                return 3;
            }
            if (screenHandlerType == class_3917.field_18666) {
                return 4;
            }
            if (screenHandlerType == class_3917.field_18667) {
                return 5;
            }
            if (screenHandlerType == class_3917.field_17327) {
                return 6;
            }
            throw new IllegalArgumentException("Unknown screen handler type: " + String.valueOf(screenHandlerType));
        }
    }
}

