/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.document.config.adapter;

import com.google.gson.Gson;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mod.fuji.core.document.auxiliary.DocumentUtil;
import mod.fuji.module.initializer.document.config.writter.DocumentJsonWriter;

public class DocumentedTypeAdapterFactory
implements TypeAdapterFactory {
    public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
        final TypeAdapter delegate = gson.getDelegateAdapter((TypeAdapterFactory)this, type);
        final Map<String, String> declaredDocumentStrings = DocumentUtil.getDeclaredDocumentStringMap(new HashMap<String, String>(), type.getRawType());
        return new TypeAdapter<T>(){

            public void write(JsonWriter out, T value) throws IOException {
                if (!(out instanceof DocumentJsonWriter)) {
                    out = new DocumentJsonWriter(out, declaredDocumentStrings);
                }
                delegate.write(out, value);
            }

            public T read(JsonReader in) throws IOException {
                return delegate.read(in);
            }
        };
    }
}

