/*
 * Decompiled with CFR 0.152.
 */
package mod.fuji.module.initializer.command_bundle.structure;

import com.google.errorprone.annotations.Keep;
import com.mojang.brigadier.Command;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.context.ParsedArgument;
import com.mojang.brigadier.context.StringRange;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import mod.fuji.core.auxiliary.CollectionUtil;
import mod.fuji.core.auxiliary.LogUtil;
import mod.fuji.core.auxiliary.minecraft.TextHelper;
import mod.fuji.core.command.argument.adapter.abst.BaseArgumentTypeAdapter;
import mod.fuji.core.command.argument.structure.CommandArgument;
import mod.fuji.core.command.descriptor.CommandDescriptor;
import mod.fuji.core.command.executor.CommandExecutor;
import mod.fuji.core.command.executor.structure.ExtendedCommandSource;
import mod.fuji.core.command.structure.CommandRequirementDescriptor;
import mod.fuji.module.initializer.command_bundle.accessor.CommandContextAccessor;
import mod.fuji.module.initializer.command_bundle.structure.BundleCommandNode;
import net.minecraft.class_2168;
import org.jetbrains.annotations.NotNull;

public class BundleCommandDescriptor
extends CommandDescriptor {
    private static final Pattern BUNDLE_COMMAND_DSL = Pattern.compile("([<](\\S+)\\s+(\\S+)[>])|(\\[(\\S+)\\s+(\\S+)\\s?([\\s\\S]*?)\\])|(\\S+)");
    private static final int LEXEME_GROUP_INDEX = 0;
    private static final int REQUIRED_NON_OPTIONAL_ARGUMENT_TYPE_GROUP_INDEX = 2;
    private static final int REQUIRED_NON_OPTIONAL_ARGUMENT_NAME_GROUP_INDEX = 3;
    private static final int REQUIRED_OPTIONAL_ARGUMENT_TYPE_GROUP_INDEX = 5;
    private static final int REQUIRED_OPTIONAL_ARGUMENT_NAME_GROUP_INDEX = 6;
    private static final int REQUIRED_OPTIONAL_ARGUMENT_DEFAULT_VALUE_GROUP_INDEX = 7;
    private static final int LITERAL_ARGUMENT_NAME_GROUP_INDEX = 8;
    private static final String ARGUMENT_NAME_PLACEHOLDER = "$";
    private final BundleCommandNode entry;
    private final Map<String, String> optionalArgumentName2DefaultValue;

    private BundleCommandDescriptor(@NotNull Method method, @NotNull List<CommandArgument> commandArguments, @NotNull BundleCommandNode entry, @NotNull Map<String, String> optionalArgumentName2DefaultValue) {
        super(method, commandArguments);
        this.entry = entry;
        this.optionalArgumentName2DefaultValue = optionalArgumentName2DefaultValue;
        this.fillDocument(entry.getDocument());
    }

    @Keep
    private static int bundleCommandGenericCommandMethod(@NotNull CommandContext<class_2168> commandContext, @NotNull BundleCommandDescriptor descriptor, @NotNull List<Object> variableValues) {
        LogUtil.debug("Execute bundle-command: definition = {}, variableValues = {}", descriptor.entry, variableValues);
        TreeMap<String, String> variableTable = new TreeMap<String, String>(Comparator.comparing(String::length).reversed().thenComparing(Comparator.naturalOrder()));
        int argumentIndex = 0;
        for (CommandArgument commandArgument : descriptor.commandArguments) {
            if (!commandArgument.isMethodParameterSpecifier()) continue;
            String argumentName = commandArgument.getArgumentName();
            String argumentValue = (String)variableValues.get(argumentIndex);
            variableTable.put(argumentName, argumentValue);
            ++argumentIndex;
        }
        LogUtil.debug("Define the variable table: {}", variableTable);
        List<String> commands = new ArrayList<String>(descriptor.entry.getBundle());
        commands = commands.stream().map(command -> {
            String newCommand = command;
            for (Map.Entry variable : variableTable.entrySet()) {
                String oldStr = ARGUMENT_NAME_PLACEHOLDER + (String)variable.getKey();
                @NotNull String newStr = (String)variable.getValue();
                newCommand = newCommand.replace(oldStr, newStr);
            }
            return newCommand;
        }).toList();
        class_2168 source = (class_2168)commandContext.getSource();
        commands = commands.stream().map(command -> TextHelper.Parsers.parsePlaceholderString(source, command)).toList();
        LogUtil.debug("Execute bundle command: {}", commands);
        List<Integer> commandReturnValues = CommandExecutor.executeBatch(ExtendedCommandSource.asConsole(source), commands);
        return CollectionUtil.lastElement(commandReturnValues).orElse(1);
    }

    @Override
    @NotNull
    protected List<Object> makeMethodParameterValues(@NotNull CommandContext<class_2168> ctx) {
        ArrayList<Object> parameterValues = new ArrayList<Object>();
        CommandContextAccessor ctxAccessor = (CommandContextAccessor)ctx;
        for (CommandArgument commandArgument : this.getMethodParameterSpecifiers()) {
            String lexeme;
            String argumentName = commandArgument.getArgumentName();
            ParsedArgument parsedArgument = ctxAccessor.fuji$getArguments().get(argumentName);
            if (parsedArgument != null) {
                StringRange lexemeRange = parsedArgument.getRange();
                lexeme = ctx.getInput().substring(lexemeRange.getStart(), lexemeRange.getEnd());
            } else {
                lexeme = this.optionalArgumentName2DefaultValue.get(argumentName);
            }
            parameterValues.add(lexeme);
        }
        LogUtil.debug("Make parameterValues for bundle command: {}", parameterValues);
        return parameterValues;
    }

    @Override
    @NotNull
    protected Command<class_2168> makeCommandAction() {
        return this.withBaseCommandAction(commandContext -> {
            int commandReturnValue;
            BundleCommandDescriptor descriptor = this;
            List<Object> parameterValues = this.makeMethodParameterValues((CommandContext<class_2168>)commandContext);
            try {
                commandReturnValue = (Integer)this.method.invoke(null, commandContext, descriptor, parameterValues);
            }
            catch (Exception e) {
                return CommandDescriptor.CommandException.handleCommandExecutionException((CommandContext<class_2168>)commandContext, this.method, e);
            }
            return commandReturnValue;
        });
    }

    @Generated
    public Map<String, String> getOptionalArgumentName2DefaultValue() {
        return this.optionalArgumentName2DefaultValue;
    }

    public static class Maker {
        @NotNull
        public static BundleCommandDescriptor from(@NotNull BundleCommandNode entry) {
            ArrayList<CommandArgument> commandArguments = new ArrayList<CommandArgument>();
            HashMap<String, String> defaultValueForOptionalArguments = new HashMap<String, String>();
            String commandPattern = entry.getPattern();
            CommandRequirementDescriptor commandRequirement = entry.getRequirement();
            Matcher matcher = BUNDLE_COMMAND_DSL.matcher(commandPattern);
            while (matcher.find()) {
                Class<?> argumentTypeClass;
                String argumentName;
                String argumentTypeName;
                if (Maker.matchLiteralArgument(matcher)) {
                    String argumentName2 = matcher.group(8);
                    commandArguments.add(CommandArgument.ofLiteralArgument(argumentName2, commandRequirement));
                    continue;
                }
                boolean isOptional = matcher.group(0).startsWith("[");
                if (isOptional) {
                    argumentTypeName = matcher.group(5);
                    argumentName = matcher.group(6);
                    argumentTypeClass = BaseArgumentTypeAdapter.Registry.toTypeClass(argumentTypeName);
                    commandArguments.add(CommandArgument.ofRequiredArgument(argumentTypeClass, argumentName, true, commandRequirement));
                    String defaultValue = matcher.group(7);
                    if (defaultValue == null) {
                        defaultValue = "";
                    }
                    defaultValueForOptionalArguments.put(argumentName, defaultValue);
                    continue;
                }
                argumentTypeName = matcher.group(2);
                argumentName = matcher.group(3);
                argumentTypeClass = BaseArgumentTypeAdapter.Registry.toTypeClass(argumentTypeName);
                commandArguments.add(CommandArgument.ofRequiredArgument(argumentTypeClass, argumentName, false, commandRequirement));
            }
            return new BundleCommandDescriptor(Maker.getBundleCommandGenericCommandMethod(), commandArguments, entry, defaultValueForOptionalArguments);
        }

        @NotNull
        private static Method getBundleCommandGenericCommandMethod() {
            Method bundleCommandGenericCommandMethod = BundleCommandDescriptor.class.getDeclaredMethod("bundleCommandGenericCommandMethod", CommandContext.class, BundleCommandDescriptor.class, List.class);
            bundleCommandGenericCommandMethod.setAccessible(true);
            return bundleCommandGenericCommandMethod;
        }

        private static boolean matchLiteralArgument(@NotNull Matcher matcher) {
            return matcher.group(8) != null;
        }
    }
}

