/*
 * Decompiled with CFR 0.152.
 */
package com.easyhome.spicymike;

import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class CooldownManager {
    private final Map<UUID, Map<String, Long>> cooldowns = new HashMap<UUID, Map<String, Long>>();

    public void setCooldown(UUID playerId, String type, int seconds) {
        this.cooldowns.putIfAbsent(playerId, new HashMap());
        this.cooldowns.get(playerId).put(type, System.currentTimeMillis() + (long)seconds * 1000L);
    }

    public boolean hasCooldown(UUID playerId, String type) {
        if (!this.cooldowns.containsKey(playerId) || !this.cooldowns.get(playerId).containsKey(type)) {
            return false;
        }
        long cooldownTime = this.cooldowns.get(playerId).get(type);
        return System.currentTimeMillis() < cooldownTime;
    }

    public long getRemainingCooldown(UUID playerId, String type) {
        if (!this.hasCooldown(playerId, type)) {
            return 0L;
        }
        long remaining = this.cooldowns.get(playerId).get(type) - System.currentTimeMillis();
        return remaining / 1000L + 1L;
    }

    public void removeCooldown(UUID playerId, String type) {
        if (this.cooldowns.containsKey(playerId)) {
            this.cooldowns.get(playerId).remove(type);
        }
    }
}

