/*
 * Decompiled with CFR 0.152.
 */
package com.easyhome.spicymike;

import com.easyhome.spicymike.AdminHomeTabCompleter;
import com.easyhome.spicymike.CooldownManager;
import com.easyhome.spicymike.DimensionTabCompleter;
import com.easyhome.spicymike.HomeCommands;
import com.easyhome.spicymike.HomeTabCompleter;
import com.easyhome.spicymike.PlayerTabCompleter;
import com.easyhome.spicymike.TeleportManager;
import java.io.File;
import java.io.IOException;
import java.util.Objects;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class EasyHome
extends JavaPlugin {
    private static EasyHome instance;
    private FileConfiguration homesConfig;
    private File homesFile;
    private FileConfiguration messagesConfig;
    private CooldownManager cooldownManager;
    private TeleportManager teleportManager;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.loadMessagesConfig();
        this.setupHomesConfig();
        this.cooldownManager = new CooldownManager();
        this.teleportManager = new TeleportManager(this);
        this.registerCommands();
        this.getLogger().info("EasyHome has been enabled!");
    }

    public void onDisable() {
        this.saveHomesConfig();
        this.getLogger().info("EasyHome has been disabled!");
    }

    private void registerCommands() {
        Objects.requireNonNull(this.getCommand("sethome")).setExecutor((CommandExecutor)new HomeCommands(this));
        Objects.requireNonNull(this.getCommand("sethome")).setTabCompleter((TabCompleter)new HomeTabCompleter());
        Objects.requireNonNull(this.getCommand("home")).setExecutor((CommandExecutor)new HomeCommands(this));
        Objects.requireNonNull(this.getCommand("home")).setTabCompleter((TabCompleter)new HomeTabCompleter());
        Objects.requireNonNull(this.getCommand("homes")).setExecutor((CommandExecutor)new HomeCommands(this));
        Objects.requireNonNull(this.getCommand("seehomes")).setExecutor((CommandExecutor)new HomeCommands(this));
        Objects.requireNonNull(this.getCommand("seehomes")).setTabCompleter((TabCompleter)new PlayerTabCompleter());
        Objects.requireNonNull(this.getCommand("setmaxhome")).setExecutor((CommandExecutor)new HomeCommands(this));
        Objects.requireNonNull(this.getCommand("toggledimension")).setExecutor((CommandExecutor)new HomeCommands(this));
        Objects.requireNonNull(this.getCommand("toggledimension")).setTabCompleter((TabCompleter)new DimensionTabCompleter());
        Objects.requireNonNull(this.getCommand("delhome")).setExecutor((CommandExecutor)new HomeCommands(this));
        Objects.requireNonNull(this.getCommand("delhome")).setTabCompleter((TabCompleter)new HomeTabCompleter());
        Objects.requireNonNull(this.getCommand("admindelhome")).setExecutor((CommandExecutor)new HomeCommands(this));
        Objects.requireNonNull(this.getCommand("admindelhome")).setTabCompleter((TabCompleter)new AdminHomeTabCompleter());
    }

    private void loadMessagesConfig() {
        File messagesFile = new File(this.getDataFolder(), "messages.yml");
        if (!messagesFile.exists()) {
            this.saveResource("messages.yml", false);
        }
        this.messagesConfig = YamlConfiguration.loadConfiguration((File)messagesFile);
    }

    private void setupHomesConfig() {
        this.homesFile = new File(this.getDataFolder(), "homes.yml");
        if (!this.homesFile.exists()) {
            try {
                this.homesFile.createNewFile();
            }
            catch (IOException e) {
                this.getLogger().severe("Could not create homes.yml!");
            }
        }
        this.homesConfig = YamlConfiguration.loadConfiguration((File)this.homesFile);
    }

    public void saveHomesConfig() {
        try {
            this.homesConfig.save(this.homesFile);
        }
        catch (IOException e) {
            this.getLogger().severe("Could not save homes.yml!");
        }
    }

    public static EasyHome getInstance() {
        return instance;
    }

    public FileConfiguration getHomesConfig() {
        return this.homesConfig;
    }

    public FileConfiguration getMessagesConfig() {
        return this.messagesConfig;
    }

    public CooldownManager getCooldownManager() {
        return this.cooldownManager;
    }

    public TeleportManager getTeleportManager() {
        return this.teleportManager;
    }

    public String getMessage(String path) {
        return this.messagesConfig.getString(path, "Message not found: " + path).replace('&', '\u00a7');
    }

    public int getDefaultMaxHomes() {
        return this.getConfig().getInt("default-max-homes", 3);
    }

    public int getTeleportCooldown() {
        return this.getConfig().getInt("teleport-cooldown", 120);
    }

    public int getHomeModificationCooldown() {
        return this.getConfig().getInt("home-modification-cooldown", 300);
    }

    public int getTeleportDelay() {
        return this.getConfig().getInt("teleport-delay", 5);
    }

    public String getTeleportDisplay() {
        return this.getConfig().getString("teleport-display", "title");
    }

    public boolean isDimensionEnabled(String dimension) {
        return this.getConfig().getBoolean("dimensions." + dimension, true);
    }

    public void setDimensionEnabled(String dimension, boolean enabled) {
        this.getConfig().set("dimensions." + dimension, (Object)enabled);
        this.saveConfig();
    }
}

