/*
 * Decompiled with CFR 0.152.
 */
package com.easyhome.spicymike;

import com.easyhome.spicymike.EasyHome;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;

public class TeleportManager {
    private final EasyHome plugin;
    private final Map<UUID, BukkitRunnable> teleportTasks = new HashMap<UUID, BukkitRunnable>();

    public TeleportManager(EasyHome plugin) {
        this.plugin = plugin;
    }

    public void startTeleport(final Player player, final Location destination, final String homeName) {
        final UUID playerId = player.getUniqueId();
        if (this.teleportTasks.containsKey(playerId)) {
            this.teleportTasks.get(playerId).cancel();
            this.teleportTasks.remove(playerId);
        }
        final int delay = this.plugin.getTeleportDelay();
        final String displayType = this.plugin.getTeleportDisplay();
        player.sendMessage(this.plugin.getMessage("teleport.started").replace("%home%", homeName).replace("%time%", String.valueOf(delay)));
        BukkitRunnable task = new BukkitRunnable(){
            int countdown;
            final Location startLocation;
            {
                this.countdown = delay;
                this.startLocation = player.getLocation();
            }

            public void run() {
                if (!player.isOnline()) {
                    TeleportManager.this.cancelTeleport(playerId);
                    return;
                }
                if (player.getLocation().distanceSquared(this.startLocation) > 0.5) {
                    player.sendMessage(TeleportManager.this.plugin.getMessage("teleport.cancelled-movement"));
                    TeleportManager.this.cancelTeleport(playerId);
                    return;
                }
                if (this.countdown <= 0) {
                    if (player.getWorld() != destination.getWorld()) {
                        player.teleport(destination.getWorld().getSpawnLocation());
                    }
                    player.teleport(destination);
                    player.sendMessage(TeleportManager.this.plugin.getMessage("teleport.completed").replace("%home%", homeName));
                    TeleportManager.this.plugin.getCooldownManager().setCooldown(playerId, "teleport", TeleportManager.this.plugin.getTeleportCooldown());
                    TeleportManager.this.teleportTasks.remove(playerId);
                    this.cancel();
                    return;
                }
                if ("chat".equalsIgnoreCase(displayType)) {
                    if (this.countdown == delay || this.countdown <= 3 || this.countdown % 5 == 0) {
                        String chatMessage = TeleportManager.this.plugin.getMessage("teleport.countdown-chat").replace("%time%", String.valueOf(this.countdown)).replace("%home%", homeName);
                        player.sendMessage(chatMessage);
                    }
                } else {
                    String titleMessage = TeleportManager.this.plugin.getMessage("teleport.countdown-title").replace("%time%", String.valueOf(this.countdown)).replace("%home%", homeName);
                    player.sendTitle(titleMessage, "", 5, 20, 5);
                }
                --this.countdown;
            }
        };
        this.teleportTasks.put(playerId, task);
        task.runTaskTimer((Plugin)this.plugin, 0L, 20L);
    }

    public void cancelTeleport(UUID playerId) {
        if (this.teleportTasks.containsKey(playerId)) {
            this.teleportTasks.get(playerId).cancel();
            this.teleportTasks.remove(playerId);
        }
    }

    public boolean isTeleporting(UUID playerId) {
        return this.teleportTasks.containsKey(playerId);
    }
}

