/*
 * Decompiled with CFR 0.152.
 */
package com.easyhome.spicymike;

import com.easyhome.spicymike.EasyHome;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.ConfigurationSection;
import org.bukkit.entity.Player;

public class HomeCommands
implements CommandExecutor {
    private final EasyHome plugin;

    public HomeCommands(EasyHome plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        switch (command.getName().toLowerCase()) {
            case "sethome": {
                return this.setHome(sender, args);
            }
            case "home": {
                return this.teleportHome(sender, args);
            }
            case "homes": {
                return this.listHomes(sender);
            }
            case "seehomes": {
                return this.seeHomes(sender, args);
            }
            case "setmaxhome": {
                return this.setMaxHome(sender, args);
            }
            case "toggledimension": {
                return this.toggleDimension(sender, args);
            }
            case "delhome": {
                return this.deleteHome(sender, args);
            }
            case "admindelhome": {
                return this.adminDeleteHome(sender, args);
            }
            case "renamehome": {
                return this.renameHome(sender, args);
            }
        }
        return false;
    }

    private boolean renameHome(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getMessage("errors.player-only"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 2) {
            player.sendMessage(this.plugin.getMessage("usage.renamehome"));
            return true;
        }
        String oldName = args[0].toLowerCase();
        String newName = args[1].toLowerCase();
        if (this.plugin.getCooldownManager().hasCooldown(player.getUniqueId(), "modification")) {
            long remaining = this.plugin.getCooldownManager().getRemainingCooldown(player.getUniqueId(), "modification");
            player.sendMessage(this.plugin.getMessage("errors.cooldown-modification").replace("%time%", String.valueOf(remaining)));
            return true;
        }
        Location homeLocation = this.getHome(player, oldName);
        if (homeLocation == null) {
            player.sendMessage(this.plugin.getMessage("errors.home-not-found").replace("%home%", oldName));
            return true;
        }
        if (this.getHome(player, newName) != null) {
            player.sendMessage(this.plugin.getMessage("errors.home-exists").replace("%home%", newName));
            return true;
        }
        this.saveHome(player, newName, homeLocation);
        this.deleteHome(player, oldName);
        player.sendMessage(this.plugin.getMessage("success.home-renamed").replace("%oldName%", oldName).replace("%newName%", newName));
        this.plugin.getCooldownManager().setCooldown(player.getUniqueId(), "modification", this.plugin.getHomeModificationCooldown());
        return true;
    }

    private boolean setHome(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getMessage("errors.player-only"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            player.sendMessage(this.plugin.getMessage("usage.sethome"));
            return true;
        }
        String homeName = args[0].toLowerCase();
        if (this.plugin.getCooldownManager().hasCooldown(player.getUniqueId(), "modification")) {
            long remaining = this.plugin.getCooldownManager().getRemainingCooldown(player.getUniqueId(), "modification");
            player.sendMessage(this.plugin.getMessage("errors.cooldown-modification").replace("%time%", String.valueOf(remaining)));
            return true;
        }
        String dimension = this.getDimension(player.getWorld());
        if (!this.plugin.isDimensionEnabled(dimension)) {
            player.sendMessage(this.plugin.getMessage("errors.dimension-disabled").replace("%dimension%", dimension));
            return true;
        }
        if (this.getHome(player, homeName) != null) {
            player.sendMessage(this.plugin.getMessage("errors.home-exists").replace("%home%", homeName));
            return true;
        }
        int maxHomes = this.getMaxHomes(player);
        int currentHomes = this.getHomes(player).size();
        if (currentHomes >= maxHomes && maxHomes != -1) {
            player.sendMessage(this.plugin.getMessage("errors.max-homes").replace("%max%", String.valueOf(maxHomes)));
            return true;
        }
        this.saveHome(player, homeName, player.getLocation());
        player.sendMessage(this.plugin.getMessage("success.home-set").replace("%home%", homeName));
        this.plugin.getCooldownManager().setCooldown(player.getUniqueId(), "modification", this.plugin.getHomeModificationCooldown());
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean teleportHome(CommandSender sender, String[] args) {
        String homeName;
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getMessage("errors.player-only"));
            return true;
        }
        Player player = (Player)sender;
        Map<String, Location> homes = this.getHomes(player);
        if (homes.isEmpty()) {
            player.sendMessage(this.plugin.getMessage("errors.no-homes"));
            return true;
        }
        if (args.length == 0) {
            if (homes.size() != 1) {
                player.sendMessage(this.plugin.getMessage("usage.home"));
                return true;
            }
            homeName = homes.keySet().iterator().next();
        } else {
            homeName = args[0].toLowerCase();
        }
        if (this.plugin.getCooldownManager().hasCooldown(player.getUniqueId(), "teleport")) {
            long remaining = this.plugin.getCooldownManager().getRemainingCooldown(player.getUniqueId(), "teleport");
            player.sendMessage(this.plugin.getMessage("errors.cooldown-teleport").replace("%time%", String.valueOf(remaining)));
            return true;
        }
        Location homeLocation = homes.get(homeName);
        if (homeLocation == null) {
            player.sendMessage(this.plugin.getMessage("errors.home-not-found").replace("%home%", homeName));
            return true;
        }
        this.plugin.getTeleportManager().startTeleport(player, homeLocation, homeName);
        return true;
    }

    private boolean listHomes(CommandSender sender) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getMessage("errors.player-only"));
            return true;
        }
        Player player = (Player)sender;
        Map<String, Location> homes = this.getHomes(player);
        if (homes.isEmpty()) {
            player.sendMessage(this.plugin.getMessage("errors.no-homes"));
            return true;
        }
        player.sendMessage(this.plugin.getMessage("homes.list-header").replace("%player%", player.getName()));
        for (Map.Entry<String, Location> entry : homes.entrySet()) {
            Location loc = entry.getValue();
            String dimension = this.getDimension(loc.getWorld());
            String message = this.plugin.getMessage("homes.list-format").replace("%home%", entry.getKey()).replace("%x%", String.format("%.1f", loc.getX())).replace("%y%", String.format("%.1f", loc.getY())).replace("%z%", String.format("%.1f", loc.getZ())).replace("%dimension%", dimension);
            player.sendMessage(message);
        }
        return true;
    }

    private boolean seeHomes(CommandSender sender, String[] args) {
        if (!sender.hasPermission("easyhome.seehomes")) {
            sender.sendMessage(this.plugin.getMessage("errors.no-permission"));
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage(this.plugin.getMessage("usage.seehomes"));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            sender.sendMessage(this.plugin.getMessage("errors.player-not-found").replace("%player%", args[0]));
            return true;
        }
        Map<String, Location> homes = this.getHomes(target);
        if (homes.isEmpty()) {
            sender.sendMessage(this.plugin.getMessage("homes.no-homes-other").replace("%player%", target.getName()));
            return true;
        }
        sender.sendMessage(this.plugin.getMessage("homes.list-header").replace("%player%", target.getName()));
        for (Map.Entry<String, Location> entry : homes.entrySet()) {
            Location loc = entry.getValue();
            String dimension = this.getDimension(loc.getWorld());
            String message = this.plugin.getMessage("homes.list-format").replace("%home%", entry.getKey()).replace("%x%", String.format("%.1f", loc.getX())).replace("%y%", String.format("%.1f", loc.getY())).replace("%z%", String.format("%.1f", loc.getZ())).replace("%dimension%", dimension);
            sender.sendMessage(message);
        }
        return true;
    }

    private boolean setMaxHome(CommandSender sender, String[] args) {
        if (!sender.hasPermission("easyhome.maxhome")) {
            sender.sendMessage(this.plugin.getMessage("errors.no-permission"));
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage(this.plugin.getMessage("usage.setmaxhome"));
            return true;
        }
        try {
            int maxHomes = Integer.parseInt(args[0]);
            this.plugin.getConfig().set("default-max-homes", (Object)maxHomes);
            this.plugin.saveConfig();
            sender.sendMessage(this.plugin.getMessage("success.max-homes-set").replace("%max%", String.valueOf(maxHomes)));
        }
        catch (NumberFormatException e) {
            sender.sendMessage(this.plugin.getMessage("errors.invalid-number"));
        }
        return true;
    }

    private boolean toggleDimension(CommandSender sender, String[] args) {
        if (!sender.hasPermission("easyhome.toggledimension")) {
            sender.sendMessage(this.plugin.getMessage("errors.no-permission"));
            return true;
        }
        if (args.length != 1) {
            sender.sendMessage(this.plugin.getMessage("usage.toggledimension"));
            return true;
        }
        String dimension = args[0].toLowerCase();
        if (!(dimension.equals("overworld") || dimension.equals("nether") || dimension.equals("end"))) {
            sender.sendMessage(this.plugin.getMessage("errors.invalid-dimension"));
            return true;
        }
        boolean current = this.plugin.isDimensionEnabled(dimension);
        this.plugin.setDimensionEnabled(dimension, !current);
        String status = !current ? "enabled" : "disabled";
        sender.sendMessage(this.plugin.getMessage("success.dimension-toggled").replace("%dimension%", dimension).replace("%status%", status));
        return true;
    }

    private boolean deleteHome(CommandSender sender, String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.plugin.getMessage("errors.player-only"));
            return true;
        }
        Player player = (Player)sender;
        if (args.length != 1) {
            player.sendMessage(this.plugin.getMessage("usage.delhome"));
            return true;
        }
        if (this.plugin.getCooldownManager().hasCooldown(player.getUniqueId(), "modification")) {
            long remaining = this.plugin.getCooldownManager().getRemainingCooldown(player.getUniqueId(), "modification");
            player.sendMessage(this.plugin.getMessage("errors.cooldown-modification").replace("%time%", String.valueOf(remaining)));
            return true;
        }
        String homeName = args[0].toLowerCase();
        if (this.getHome(player, homeName) == null) {
            player.sendMessage(this.plugin.getMessage("errors.home-not-found").replace("%home%", homeName));
            return true;
        }
        this.deleteHome(player, homeName);
        player.sendMessage(this.plugin.getMessage("success.home-deleted").replace("%home%", homeName));
        this.plugin.getCooldownManager().setCooldown(player.getUniqueId(), "modification", this.plugin.getHomeModificationCooldown());
        return true;
    }

    private boolean adminDeleteHome(CommandSender sender, String[] args) {
        if (!sender.hasPermission("easyhome.admindelhome")) {
            sender.sendMessage(this.plugin.getMessage("errors.no-permission"));
            return true;
        }
        if (args.length != 2) {
            sender.sendMessage(this.plugin.getMessage("usage.admindelhome"));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            sender.sendMessage(this.plugin.getMessage("errors.player-not-found").replace("%player%", args[0]));
            return true;
        }
        String homeName = args[1].toLowerCase();
        if (this.getHome(target, homeName) == null) {
            sender.sendMessage(this.plugin.getMessage("errors.home-not-found-other").replace("%home%", homeName).replace("%player%", target.getName()));
            return true;
        }
        this.deleteHome(target, homeName);
        sender.sendMessage(this.plugin.getMessage("success.home-deleted-other").replace("%home%", homeName).replace("%player%", target.getName()));
        return true;
    }

    private String getDimension(World world) {
        switch (world.getEnvironment()) {
            case NETHER: {
                return "nether";
            }
            case THE_END: {
                return "end";
            }
        }
        return "overworld";
    }

    private int getMaxHomes(Player player) {
        if (player.isOp()) {
            return -1;
        }
        return this.plugin.getDefaultMaxHomes();
    }

    private Location getHome(Player player, String homeName) {
        String path = "homes." + String.valueOf(player.getUniqueId()) + "." + homeName;
        return (Location)this.plugin.getHomesConfig().get(path);
    }

    private Map<String, Location> getHomes(Player player) {
        HashMap<String, Location> homes = new HashMap<String, Location>();
        String path = "homes." + String.valueOf(player.getUniqueId());
        ConfigurationSection section = this.plugin.getHomesConfig().getConfigurationSection(path);
        if (section != null) {
            for (String key : section.getKeys(false)) {
                Location loc = (Location)section.get(key);
                homes.put(key, loc);
            }
        }
        return homes;
    }

    private void saveHome(Player player, String homeName, Location location) {
        String path = "homes." + String.valueOf(player.getUniqueId()) + "." + homeName;
        this.plugin.getHomesConfig().set(path, (Object)location);
        this.plugin.saveHomesConfig();
    }

    private void deleteHome(Player player, String homeName) {
        String path = "homes." + String.valueOf(player.getUniqueId()) + "." + homeName;
        this.plugin.getHomesConfig().set(path, null);
        this.plugin.saveHomesConfig();
    }
}

