/*
 * Decompiled with CFR 0.152.
 */
package com.example.hidenames;

import com.example.hidenames.PlayerListener;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scoreboard.Scoreboard;
import org.bukkit.scoreboard.Team;
import org.jetbrains.annotations.NotNull;

public final class Main
extends JavaPlugin {
    private static Main instance;
    private Team hideNamesTeam;
    private String messageFormat;
    private int durationSeconds;
    private boolean papiEnabled = false;

    public void onEnable() {
        instance = this;
        this.saveDefaultConfig();
        this.loadConfiguration();
        if (Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null) {
            this.papiEnabled = true;
            this.getLogger().info("PlaceholderAPI \u043d\u0430\u0439\u0434\u0435\u043d! \u041f\u043e\u0434\u0434\u0435\u0440\u0436\u043a\u0430 \u043f\u043b\u0435\u0439\u0441\u0445\u043e\u043b\u0434\u0435\u0440\u043e\u0432 \u0432\u043a\u043b\u044e\u0447\u0435\u043d\u0430.");
        } else {
            this.getLogger().info("PlaceholderAPI \u043d\u0435 \u043d\u0430\u0439\u0434\u0435\u043d. \u0411\u0443\u0434\u0443\u0442 \u0440\u0430\u0431\u043e\u0442\u0430\u0442\u044c \u0442\u043e\u043b\u044c\u043a\u043e \u0441\u0442\u0430\u043d\u0434\u0430\u0440\u0442\u043d\u044b\u0435 \u043f\u043b\u0435\u0439\u0441\u0445\u043e\u043b\u0434\u0435\u0440\u044b.");
        }
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerListener(), (Plugin)this);
        this.setupTeam();
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (this.hideNamesTeam.hasEntry(player.getName())) continue;
            this.hideNamesTeam.addEntry(player.getName());
        }
        this.getLogger().info("\u041f\u043b\u0430\u0433\u0438\u043d HideNames \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u0432\u043a\u043b\u044e\u0447\u0435\u043d!");
    }

    public void onDisable() {
        if (this.hideNamesTeam != null) {
            this.hideNamesTeam.unregister();
        }
        this.getLogger().info("\u041f\u043b\u0430\u0433\u0438\u043d HideNames \u0432\u044b\u043a\u043b\u044e\u0447\u0435\u043d.");
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length > 0 && args[0].equalsIgnoreCase("reload")) {
            if (!sender.hasPermission("hidenames.reload")) {
                sender.sendMessage(Main.parseColors("<red>\u0423 \u0432\u0430\u0441 \u043d\u0435\u0442 \u043f\u0440\u0430\u0432 \u0434\u043b\u044f \u0432\u044b\u043f\u043e\u043b\u043d\u0435\u043d\u0438\u044f \u044d\u0442\u043e\u0439 \u043a\u043e\u043c\u0430\u043d\u0434\u044b.</red>"));
                return true;
            }
            this.loadConfiguration();
            sender.sendMessage(Main.parseColors("<green>\u041a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u044f \u043f\u043b\u0430\u0433\u0438\u043d\u0430 HideNames \u0443\u0441\u043f\u0435\u0448\u043d\u043e \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u0430!</green>"));
            return true;
        }
        sender.sendMessage(Main.parseColors("<yellow>\u0418\u0441\u043f\u043e\u043b\u044c\u0437\u0443\u0439\u0442\u0435 /hidenames reload \u0434\u043b\u044f \u043f\u0435\u0440\u0435\u0437\u0430\u0433\u0440\u0443\u0437\u043a\u0438 \u043a\u043e\u043d\u0444\u0438\u0433\u0443\u0440\u0430\u0446\u0438\u0438.</yellow>"));
        return true;
    }

    public void loadConfiguration() {
        this.reloadConfig();
        this.messageFormat = this.getConfig().getString("message", "<gray>\u0412\u044b \u043a\u043b\u0438\u043a\u043d\u0443\u043b\u0438 \u043d\u0430 \u0438\u0433\u0440\u043e\u043a\u0430 %player%</gray>");
        this.durationSeconds = this.getConfig().getInt("duration", 5);
        this.getLogger().info("\u0417\u0430\u0433\u0440\u0443\u0436\u0435\u043d\u043e \u0441\u043e\u043e\u0431\u0449\u0435\u043d\u0438\u0435 \u0438\u0437 \u043a\u043e\u043d\u0444\u0438\u0433\u0430: " + this.messageFormat);
    }

    public String getMessageFormat() {
        return this.messageFormat;
    }

    public int getDurationSeconds() {
        return this.durationSeconds;
    }

    public boolean isPapiEnabled() {
        return this.papiEnabled;
    }

    private void setupTeam() {
        Scoreboard mainScoreboard = Bukkit.getScoreboardManager().getMainScoreboard();
        this.hideNamesTeam = mainScoreboard.getTeam("hidenames");
        if (this.hideNamesTeam == null) {
            this.hideNamesTeam = mainScoreboard.registerNewTeam("hidenames");
        }
        this.hideNamesTeam.setOption(Team.Option.NAME_TAG_VISIBILITY, Team.OptionStatus.NEVER);
    }

    public Team getHideNamesTeam() {
        return this.hideNamesTeam;
    }

    public static Main getInstance() {
        return instance;
    }

    public static Component parseColors(String text) {
        return MiniMessage.miniMessage().deserialize((Object)text);
    }
}

