package net.anawesomguy.musicbox.block;

import com.mojang.serialization.MapCodec;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2415;
import net.minecraft.class_2470;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2758;
import net.minecraft.class_3726;
import net.minecraft.class_3965;
import net.minecraft.class_4538;
import net.minecraft.class_5558;
import net.minecraft.class_7718;
import org.jetbrains.annotations.Nullable;

import static java.util.Objects.requireNonNull;

public class MusicBoxBlock extends class_2248 implements class_2343 {
    public static final MapCodec<MusicBoxBlock> CODEC = method_54094(MusicBoxBlock::new);
    public static final class_2758 ROTATION = class_2741.field_12532;
    public static final int MAX_ROTATIONS = class_7718.method_45478() + 1;
    public static final class_265 SHAPE = method_66404(10, 0, 8);

    public MusicBoxBlock(class_2251 settings) {
        super(settings);
        this.method_9590(this.method_9564().method_11657(ROTATION, 0));
    }

    @Override
    protected MapCodec<? extends class_2248> method_53969() {
        return field_46280;
    }

    @Override
    protected class_265 method_9571(class_2680 state) {
        return class_259.method_1073();
    }

    @Override
    protected class_265 method_9530(class_2680 state, class_1922 world, class_2338 pos, class_3726 context) {
        return SHAPE;
    }

    @Override
    public class_2680 method_9605(class_1750 ctx) {
        return this.method_9564().method_11657(ROTATION, class_7718.method_45479(ctx.method_8044()));
    }

    @Override
    protected class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return state.method_11657(ROTATION, rotation.method_10502(state.method_11654(ROTATION), MAX_ROTATIONS));
    }

    @Override
    protected class_2680 method_9569(class_2680 state, class_2415 mirror) {
        return state.method_11657(ROTATION, mirror.method_10344(state.method_11654(ROTATION), MAX_ROTATIONS));
    }

    @Override
    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        super.method_9515(builder);
        builder.method_11667(ROTATION);
    }

    @Override
    protected class_1799 method_9574(class_4538 world, class_2338 pos, class_2680 state, boolean includeData) {
        class_1799 stack = super.method_9574(world, pos, state, includeData);
        return includeData ?
            ((MusicBoxBlockEntity)requireNonNull(world.method_8321(pos))).getPickStack(stack) :
            stack;
    }

    @Override
    protected class_1269 method_55766(class_2680 state, class_1937 world, class_2338 pos, class_1657 player, class_3965 hit) {
        return world.method_8321(pos) instanceof MusicBoxBlockEntity blockEntity ?
            blockEntity.onUse(world, pos, player) :
            class_1269.field_5811;
    }

    @Override
    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new MusicBoxBlockEntity(pos, state);
    }

    @Override
    public @Nullable <T extends class_2586> class_5558<T> method_31645(class_1937 world, class_2680 state, class_2591<T> type) {
        return validateTicker(type, MusicBoxBlockEntity::tick);
    }

    @SuppressWarnings("unchecked")
    @Nullable // idk why this method is needed, but if i inline it gives an error, so...
    protected static <E extends class_2586, A extends class_2586> class_5558<A> validateTicker(class_2591<A> given, class_5558<? super E> ticker) {
        return MusicBoxBlockEntity.TYPE == given ? (class_5558<A>)ticker : null;
    }
}
