package net.anawesomguy.musicbox.block;

import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.ints.IntList;
import net.anawesomguy.musicbox.WindupMusicBoxMod;
import net.anawesomguy.musicbox.item.MusicBoxDataComponent;
import net.fabricmc.fabric.api.object.builder.v1.block.entity.FabricBlockEntityTypeBuilder;
import net.minecraft.class_11368;
import net.minecraft.class_11372;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2596;
import net.minecraft.class_2602;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_7225;
import net.minecraft.class_9323;
import net.minecraft.class_9473;
import org.jetbrains.annotations.Nullable;

public class MusicBoxBlockEntity extends class_2586 {
    public static final class_2591<MusicBoxBlockEntity> TYPE = FabricBlockEntityTypeBuilder.create(
        MusicBoxBlockEntity::new, WindupMusicBoxMod.MUSIC_BOX).build();
    public static final int
        KEY_ROTATION = 360 / 30, // 12
        MAX_TENSION = 48;

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, MusicBoxBlockEntity entity) {
        if (world.field_9236)
            return;

        int ticks = entity.ticks++;
        if (entity.windCooldown > 0)
            entity.windCooldown--;

        // music playing functions
        int tension = entity.tension;
        if (tension > 0 && entity.windCooldown <= 0) {
            MusicBoxDataComponent data = entity.data;
            if (data != null) {
                int ticksPerNote = data.getTicksPerNote();
                if (tension < 9)
                    ticksPerNote *= 2;
                if (ticks % ticksPerNote == 0) {
                    entity.tension = tension - 1;
                    short[] notes = data.getNotes();
                    int currentNote = entity.currentNote;
                    entity.currentNote = (currentNote + 1) % notes.length;
                    IntList semitones = entity.semitonesCache;
                    data.getSemitones(currentNote, semitones);
                    for (int i = 0, semitonesSize = semitones.size(); i < semitonesSize; i++) {
                        double semitone = semitones.getInt(i);
                        world.method_8396(null, pos, WindupMusicBoxMod.MUSIC_BOX_NOTE, class_3419.field_15245, 1F,
                                        (float)Math.pow(2.0, semitone / 12.0));
                        ((class_3218)world).method_65096(
                            class_2398.field_11224, // 7 indents is crazy lol
                            pos.method_10263() + 0.5, pos.method_10264() + 1, pos.method_10260() + 0.5,
                            0, semitone / 24.0,
                            // for some reason the note particle uses the velocityX to determine its color
                            0.0, 0.0, 1.0
                        );
                    }
                }
            }
        }
    }

    public int ticks;
    private int windCooldown = 0;
    private int keyRotation = 1;
    private int tension = 0;
    private int currentNote = 0;
    private final IntList semitonesCache = new IntArrayList();
    public boolean open = true;
    @Nullable // always null on the client
    public MusicBoxDataComponent data = null;
    public int notesLength;

    public MusicBoxBlockEntity(class_2338 pos, class_2680 state) {
        super(TYPE, pos, state);
    }

    public class_1269 onUse(class_1937 world, class_2338 pos, class_1657 player) {
        if (player.method_5715()) {
            @SuppressWarnings("AssignmentUsedAsCondition")
            class_3414 sound = (open = !open) ? class_3417.field_14932 : class_3417.field_15080;
            world.method_8396(player, pos, sound, class_3419.field_15245, 1F,
                            world.method_8409().method_43057() * 0.1F + 0.9F);
        } else if (!world.field_9236 && windCooldown <= 2 && tension < MAX_TENSION) {
            windCooldown = 7;
            keyRotation = (keyRotation + 1) % KEY_ROTATION;
            tension += 6;
            world.method_8396(null, pos, WindupMusicBoxMod.MUSIC_BOX_WIND_UP, class_3419.field_15245, 1F,
                            world.method_8409().method_43057() * 0.1F + 0.9F);
            ((class_3218)world).method_14178().method_14128(pos);
            if (data == null)
                player.method_7353(class_2561.method_43471("windup_music_box.message.music_box.empty"), true);
            return class_1269.field_52422;
        }
        return class_1269.field_5812;
    }

    public class_1799 getPickStack(class_1799 in) {
        in.method_57379(WindupMusicBoxMod.MUSIC_BOX_DATA, data);
        return in;
    }

    @Override
    public @Nullable class_2596<class_2602> method_38235() {
        return class_2622.method_38585(this);
    }

    @Override
    public class_2487 method_16887(class_7225.class_7874 registries) {
        class_2487 nbt = new class_2487();
        nbt.method_10556("open", open);
        nbt.method_10569("currentNote", 0);
        nbt.method_10569("notesLength", data == null ? 0 : data.getNotes().length);
        nbt.method_10569("keyRotation", keyRotation);
        return nbt;
    }

    @Override
    protected void method_57568(class_9473 components) {
        super.method_57568(components);
        data = components.method_58694(WindupMusicBoxMod.MUSIC_BOX_DATA);
    }

    @Override
    protected void method_57567(class_9323.class_9324 builder) {
        super.method_57567(builder);
        builder.method_57840(WindupMusicBoxMod.MUSIC_BOX_DATA, data);
    }

    @Override
    protected void method_11014(class_11368 view) {
        super.method_11014(view);
        tension = view.method_71424("tension", 0);
        open = view.method_71433("open", true);
        currentNote = view.method_71424("currentNote", 0);
        data = view.method_71426("musicBoxData", MusicBoxDataComponent.CODEC).orElse(null);
        notesLength = view.method_71439("notesLength").orElse(0);
        keyRotation = view.method_71424("keyRotation", 0);
    }

    @Override
    protected void method_11007(class_11372 view) {
        super.method_11007(view);
        view.method_71465("tension", tension);
        view.method_71472("open", open);
        view.method_71465("currentNote", 0);
        view.method_71465("keyRotation", keyRotation);
        if (data != null)
            view.method_71468("musicBoxData", MusicBoxDataComponent.CODEC, data);
    }

    @SuppressWarnings("deprecation")
    @Override
    public void method_57569(class_11372 view) {
        super.method_57569(view);
        view.method_71478("tension");
        view.method_71478("open");
        view.method_71478("currentNote");
        view.method_71478("musicBoxData");
        view.method_71478("notesLength");
    }

    public int getCurrentNote() {
        return currentNote;
    }

    public int getTension() {
        return tension;
    }

    public int getKeyRotation() {
        return keyRotation;
    }
}
