package net.anawesomguy.musicbox.client.block;

import net.anawesomguy.musicbox.block.MusicBoxBlockEntity;
import net.minecraft.class_1921;
import net.minecraft.class_3879;
import net.minecraft.class_5603;
import net.minecraft.class_5605;
import net.minecraft.class_5606;
import net.minecraft.class_5607;
import net.minecraft.class_5609;
import net.minecraft.class_5610;
import net.minecraft.class_630;

import static net.minecraft.class_5606.method_32108;
import static net.minecraft.class_3532.field_29845;
import static net.minecraft.class_3532.field_29844;
import static net.minecraft.class_3532.field_29847;

public class MusicBoxModel extends class_3879 {
    private final class_630 key;
    private final class_630 governer;
    private final class_630 drum;
    private final class_630 lid;

    public MusicBoxModel(class_630 root) {
        super(root, class_1921::method_23572);
        this.key = root.method_32086("key");
        this.governer = root.method_32086("governer");
        this.drum = root.method_32086("drum");
        this.lid = root.method_32086("lid");
    }

    public static class_5607 getTexturedModelData() {
        class_5609 modelData = new class_5609();
        class_5610 modelPartData = modelData.method_32111();

        modelPartData.method_32117("key",
                               method_32108().method_32101(24, 5)
                                       .method_32097(-0.5F, -0.5F, 0F, 1F, 1F, 2F)
                                       .method_32101(24, 0)
                                       .method_32097(-1.5F, -0.5F, 0.001F, 3F, 1F, 0F),
                               class_5603.method_32090(5.5F, 3.5F, 1F));

        class_5610 shell = modelPartData.method_32117("shell", method_32108().method_32101(0, 0).method_32097(4F, 1F, 4F, 8F, 1F, 8F),
                                                     class_5603.field_27701);
        class_5606 side = method_32108().method_32101(22, 9).method_32097(-5F, 0F, 4F, 9F, 7F, 1F);
        shell.method_32117("north", side, class_5603.method_32091(8F, 0F, 8F, 0F, field_29844, 0F));
        shell.method_32117("south", side, class_5603.method_32090(8F, 0F, 8F));
        shell.method_32117("east", side, class_5603.method_32091(8F, 0F, 8F, 0F, -field_29845, 0));
        shell.method_32117("west", side, class_5603.method_32091(8F, 0F, 8F, 0F, field_29845, 0F));

        class_5610 insides = modelPartData.method_32117("insides", method_32108().method_32101(24, 17)
                                                                          .method_32096()
                                                                          .method_32097(4F, 2F, 4F, 3F, 4F, 4F)
                                                                          .method_32101(16, 25)
                                                                          .method_32097(7F, 4F, 8F, 5F, 0F, 4F)
                                                                          .method_32101(0, 20)
                                                                          .method_32097(4F, 1.5F, 8F, 8F, 1F, 4F)
                                                                          .method_32101(35, 21)
                                                                          .method_32097(5F, 6F, 8F, 1F, 0F, 3F)
                                                                          .method_32101(32, 4)
                                                                          .method_32098(5F, 2.249F, 9.5F, 1F, 4F, 1F,
                                                                                  new class_5605(-0.25F)),
                                                       class_5603.field_27701);
        insides.method_32117("gear", method_32108().method_32101(36, 5).method_32097(-0.5F, -1F, -0.5F, 1F, 2F, 2F),
                         class_5603.method_32091(5.5F, 3F, 7.75F, field_29844 / -4F, 0F, 0F));

        modelPartData.method_32117("governer",
                               method_32108().method_32101(30, 27).method_32098(-1.5F, -0.5F, -0.5F, 3F, 1F, 1F, new class_5605(-0.1F)),
                               class_5603.method_32090(5.5F, 5, 10));
        modelPartData.method_32117("drum", method_32108().method_32101(0, 25).method_32097(-2.5F, -1.5F, -1.5F, 5F, 3F, 3F),
                               class_5603.method_32090(9.5F, 4F, 6F));
        modelPartData.method_32117("lid", method_32108().method_32101(0, 9).method_32097(-5F, 0F, 0F, 10F, 10F, 1F),
                               class_5603.method_32090(8F, 7F, 13F));

        return class_5607.method_32110(modelData, 64, 32);
    }

    public void update(MusicBoxBlockEntity entity, float tickProgress) {
        int notesLength = entity.notesLength;
        drum.field_3665 = notesLength > 0;
//        if (notesLength > 0) {
//            drum.pitch = TAU * ((float)entity.getCurrentNote() / notesLength - 1) + (PI / 4F); // 360deg * (value from 0-1)
//            drum.visible = true;
//        } else
//            drum.visible = false;
//        governer.yaw = (drum.pitch * 200) % TAU; // it's fast
        lid.field_3654 = (entity.open ? field_29847 * 30F : -field_29845);
        key.field_3674 = field_29847 * 30F * entity.getKeyRotation();
    }
}