package com.nerjal.max_health_fix.mixin;

import net.minecraft.class_11368;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1937;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(class_1309.class)
public abstract class LivinEntityMixin extends class_1297 {
    public LivinEntityMixin(class_1299<?> type, class_1937 world) {
        super(type, world);
    }

    @Shadow public abstract void setHealth(float health);

    @Unique Float hf_storedHealth = null;

    @Inject(method = "tick", at = @At("TAIL"))
    private void hf_tickInjector(CallbackInfo ci) {
        if (this.hf_storedHealth != null && this.hf_storedHealth > 0) {
            this.setHealth(this.hf_storedHealth);
            this.hf_storedHealth = null;
        }
    }

    @Inject(method = "readCustomData", at = @At("HEAD"))
    private void hf_readDataInjector(class_11368 view, CallbackInfo ci) {
        float health = view.method_71423("Health", Float.MIN_VALUE);
        if (health != Float.MIN_VALUE) this.hf_storedHealth = health;
    }
}
