/*
 * Decompiled with CFR 0.152.
 */
package net.cjsah.mod.extendedoritech.block;

import java.util.List;
import net.cjsah.mod.extendedoritech.block.entity.PluginAddonExtenderBlockEntity;
import net.cjsah.mod.extendedoritech.init.ModBlockEntities;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.block.blocks.addons.MachineAddonBlock;

public class PluginAddonExtenderBlock
extends MachineAddonBlock {
    public PluginAddonExtenderBlock(BlockBehaviour.Properties settings) {
        super(settings, MachineAddonBlock.AddonSettings.getDefaultSettings().withExtender(true).withNeedsSupport(false));
    }

    @NotNull
    public Class<? extends BlockEntity> getBlockEntityType() {
        return PluginAddonExtenderBlockEntity.class;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new PluginAddonExtenderBlockEntity((BlockEntityType<PluginAddonExtenderBlockEntity>)((BlockEntityType)ModBlockEntities.PLUGIN_ADDON_EXTENDER.get()), pos, state);
    }

    @Nullable
    protected MenuProvider getMenuProvider(BlockState state, Level level, BlockPos pos) {
        return super.getMenuProvider(state, level, pos);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (player.isSpectator()) {
            return InteractionResult.PASS;
        }
        if (level.isClientSide) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.getBlockEntity(pos);
        if (blockEntity instanceof PluginAddonExtenderBlockEntity) {
            PluginAddonExtenderBlockEntity blockEntity2 = (PluginAddonExtenderBlockEntity)blockEntity;
            player.openMenu((MenuProvider)blockEntity2, pos);
        }
        return InteractionResult.SUCCESS;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltip, TooltipFlag options) {
        super.appendHoverText(stack, context, tooltip, options);
        if (Screen.hasControlDown()) {
            tooltip.add((Component)Component.translatable((String)"tooltip.extendedoritech.plugin_addon_extender").withStyle(ChatFormatting.GRAY));
        }
    }
}

