/*
 * Decompiled with CFR 0.152.
 */
package net.cjsah.mod.extendedoritech.block.entity;

import java.util.List;
import net.cjsah.mod.extendedoritech.init.ModBlocks;
import net.cjsah.mod.extendedoritech.init.ModMenuTypes;
import net.cjsah.mod.extendedoritech.inventory.PluginAddonExtenderMenu;
import net.cjsah.mod.extendedoritech.inventory.component.StackHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.Container;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.neoforge.items.IItemHandler;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.block.blocks.addons.MachineAddonBlock;
import rearth.oritech.block.entity.addons.AddonBlockEntity;
import rearth.oritech.util.InventoryInputMode;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.ScreenProvider;

public class PluginAddonExtenderBlockEntity
extends AddonBlockEntity
implements MenuProvider,
ScreenProvider {
    private final StackHandler itemStackHandler = new StackHandler(this);
    private MachineAddonBlock.AddonSettings settings = MachineAddonBlock.AddonSettings.getDefaultSettings().withSpeedMultiplier(0.0f).withEfficiencyMultiplier(0.0f);

    public PluginAddonExtenderBlockEntity(BlockEntityType<PluginAddonExtenderBlockEntity> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void setChanged() {
        BlockItem blockItem;
        super.setChanged();
        float speed = 0.0f;
        float efficiency = 0.0f;
        long energyAmount = 0L;
        long energyInsert = 0L;
        int extraChambers = 0;
        int extraBurstTicks = 0;
        ItemStack stack = this.itemStackHandler.getStackInSlot(0);
        Item item = stack.getItem();
        if (item instanceof BlockItem && (item = (blockItem = (BlockItem)item).getBlock()) instanceof MachineAddonBlock) {
            MachineAddonBlock addonBlock = (MachineAddonBlock)item;
            MachineAddonBlock.AddonSettings addonSettings = addonBlock.getAddonSettings();
            int count = Math.min(stack.getCount(), 16);
            if (Oritech.CONFIG.additiveAddons()) {
                speed = (1.0f - addonSettings.speedMultiplier()) * (float)count;
                efficiency = (1.0f - addonSettings.efficiencyMultiplier()) * (float)count;
            } else {
                speed = (float)Math.pow(addonSettings.speedMultiplier(), count);
                efficiency = (float)Math.pow(addonSettings.efficiencyMultiplier(), count);
            }
            energyAmount = addonSettings.addedCapacity() * (long)count;
            energyInsert = addonSettings.addedInsert() * (long)count;
            extraChambers = addonSettings.chamberCount() * count;
            extraBurstTicks = addonSettings.burstTicks() * count;
        }
        this.settings = new MachineAddonBlock.AddonSettings(false, speed, efficiency, energyAmount, energyInsert, false, true, extraChambers, extraBurstTicks, null);
        if (this.level == null || this.level.isClientSide()) {
            return;
        }
        BlockPos pos = this.getControllerPos();
        if (!this.level.isLoaded(pos)) {
            return;
        }
        item = this.level.getBlockEntity(pos);
        if (item instanceof MachineAddonController) {
            MachineAddonController controller = (MachineAddonController)item;
            controller.initAddons();
        }
    }

    public MachineAddonBlock.AddonSettings getSettings() {
        return this.settings;
    }

    public Component getDisplayName() {
        return ((Block)ModBlocks.PLUGIN_ADDON_EXTENDER.get()).getName();
    }

    public IItemHandler getItemHandler() {
        return this.itemStackHandler;
    }

    @Nullable
    public AbstractContainerMenu createMenu(int i, Inventory inventory, Player player) {
        if (player.isSpectator()) {
            return null;
        }
        return new PluginAddonExtenderMenu(i, inventory, this);
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.loadAdditional(tag, provider);
        ItemStack stack = ItemStack.EMPTY;
        if (tag.contains("Item", 10)) {
            stack = ItemStack.parse((HolderLookup.Provider)provider, (Tag)tag.getCompound("Item")).orElse(ItemStack.EMPTY);
        }
        this.itemStackHandler.setStackInSlot(0, stack);
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider provider) {
        super.saveAdditional(tag, provider);
        ItemStack stack = this.itemStackHandler.getStackInSlot(0);
        if (stack.isEmpty()) {
            return;
        }
        tag.put("Item", stack.save(provider, (Tag)new CompoundTag()));
    }

    public MenuType<?> getScreenHandlerType() {
        return (MenuType)ModMenuTypes.PLUGIN_ADDON_EXTENDER.get();
    }

    public Container getDisplayedInventory() {
        return this.itemStackHandler;
    }

    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 80, 35));
    }

    public InventoryInputMode getInventoryInputMode() {
        return InventoryInputMode.FILL_LEFT_TO_RIGHT;
    }

    public boolean showEnergy() {
        return false;
    }

    public boolean showProgress() {
        return false;
    }

    public float getDisplayedEnergyUsage() {
        return 0.0f;
    }

    public float getProgress() {
        return 0.0f;
    }
}

