/*
 * Decompiled with CFR 0.152.
 */
package net.cjsah.mod.extendedoritech.client.screen;

import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import net.cjsah.mod.extendedoritech.block.entity.PluginAddonExtenderBlockEntity;
import net.cjsah.mod.extendedoritech.inventory.PluginAddonExtenderMenu;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.ClickType;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.level.block.entity.BlockEntity;
import rearth.oritech.block.blocks.addons.MachineAddonBlock;
import rearth.oritech.client.ui.BasicMachineScreen;
import rearth.oritech.client.ui.BasicMachineScreenHandler;

public class PluginAddonExtenderScreen
extends BasicMachineScreen<PluginAddonExtenderMenu> {
    private LabelComponent speedLabel;
    private LabelComponent efficiencyLabel;
    private LabelComponent chamberLabel;

    public PluginAddonExtenderScreen(PluginAddonExtenderMenu menu, Inventory playerInventory, Component title) {
        super((BasicMachineScreenHandler)menu, playerInventory, title);
    }

    protected void slotClicked(Slot slot, int slotId, int mouseButton, ClickType type) {
        super.slotClicked(slot, slotId, mouseButton, type);
        this.updateLabels();
    }

    private void updateLabels() {
        if (this.speedLabel == null || this.efficiencyLabel == null || this.chamberLabel == null) {
            return;
        }
        BlockEntity blockEntity = ((PluginAddonExtenderMenu)this.menu).blockEntity;
        if (!(blockEntity instanceof PluginAddonExtenderBlockEntity)) {
            return;
        }
        PluginAddonExtenderBlockEntity blockEntity2 = (PluginAddonExtenderBlockEntity)blockEntity;
        MachineAddonBlock.AddonSettings settings = blockEntity2.getSettings();
        int speed = Math.round(settings.speedMultiplier() * 20.0f) * 5;
        int efficiency = Math.round(settings.efficiencyMultiplier() * 20.0f) * 5;
        int extraChambers = settings.chamberCount();
        String efficiencyText = (efficiency > 0 ? "+" : "") + efficiency;
        this.speedLabel.text((Component)Component.translatable((String)"title.oritech.machine_speed", (Object[])new Object[]{speed}));
        this.efficiencyLabel.text((Component)Component.translatable((String)"title.oritech.machine_efficiency", (Object[])new Object[]{efficiencyText}));
        this.chamberLabel.text((Component)Component.translatable((String)"title.oritech.chambers", (Object[])new Object[]{extraChambers}));
    }

    public void addExtensionComponents(FlowLayout container) {
        super.addExtensionComponents(container);
        this.speedLabel = Components.label((Component)Component.translatable((String)"title.oritech.machine_speed", (Object[])new Object[]{"?"}));
        this.efficiencyLabel = Components.label((Component)Component.translatable((String)"title.oritech.machine_efficiency", (Object[])new Object[]{"?"}));
        this.chamberLabel = Components.label((Component)Component.translatable((String)"title.oritech.chambers", (Object[])new Object[]{"?"}));
        this.updateLabels();
        container.child((io.wispforest.owo.ui.core.Component)Components.box((Sizing)Sizing.fixed((int)73), (Sizing)Sizing.fixed((int)1)).color(new Color(0.8f, 0.8f, 0.8f)));
        container.child(this.speedLabel.tooltip((Component)Component.translatable((String)"tooltip.oritech.machine_speed")).margins(Insets.of((int)3)));
        container.child(this.efficiencyLabel.tooltip((Component)Component.translatable((String)"tooltip.oritech.machine_efficiency")).margins(Insets.of((int)3)));
        container.child(this.chamberLabel.tooltip((Component)Component.translatable((String)"tooltip.oritech.chambers")).margins(Insets.of((int)3)));
    }
}

