/*
 * Decompiled with CFR 0.152.
 */
package net.cjsah.mod.extendedoritech.inventory.component;

import net.cjsah.mod.extendedoritech.block.entity.PluginAddonExtenderBlockEntity;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.neoforge.items.ItemStackHandler;
import rearth.oritech.block.blocks.addons.MachineAddonBlock;

public class StackHandler
extends ItemStackHandler
implements Container {
    private final PluginAddonExtenderBlockEntity blockEntity;

    public StackHandler(PluginAddonExtenderBlockEntity blockEntity) {
        this.blockEntity = blockEntity;
    }

    public boolean isItemValid(int slot, ItemStack stack) {
        BlockItem blockItem;
        Item item = stack.getItem();
        return item instanceof BlockItem && (blockItem = (BlockItem)item).getBlock() instanceof MachineAddonBlock;
    }

    public int getSlotLimit(int slot) {
        return this.getMaxStackSize();
    }

    public int getMaxStackSize() {
        return 16;
    }

    protected void onContentsChanged(int slot) {
        this.setChanged();
    }

    public int getContainerSize() {
        return this.getSlots();
    }

    public boolean isEmpty() {
        return this.getStackInSlot(0).isEmpty();
    }

    public ItemStack getItem(int slot) {
        return this.getStackInSlot(slot);
    }

    public ItemStack removeItem(int slot, int count) {
        return this.extractItem(slot, count, false);
    }

    public ItemStack removeItemNoUpdate(int slot) {
        ItemStack stack = this.getStackInSlot(slot);
        this.setStackInSlot(slot, ItemStack.EMPTY);
        return stack;
    }

    public void setItem(int slot, ItemStack itemStack) {
        this.setStackInSlot(slot, itemStack);
    }

    public void setChanged() {
        this.blockEntity.setChanged();
    }

    public boolean stillValid(Player player) {
        return Container.stillValidBlockEntity((BlockEntity)this.blockEntity, (Player)player);
    }

    public void clearContent() {
        this.stacks.clear();
        this.setChanged();
    }
}

