/*
 * Decompiled with CFR 0.152.
 */
package net.cjsah.mod.extendedoritech.mixin;

import java.util.List;
import net.cjsah.mod.extendedoritech.block.entity.PluginAddonExtenderBlockEntity;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Overwrite;
import org.spongepowered.asm.mixin.Shadow;
import rearth.oritech.Oritech;
import rearth.oritech.block.blocks.addons.MachineAddonBlock;
import rearth.oritech.block.entity.addons.AddonBlockEntity;
import rearth.oritech.block.entity.addons.CombiAddonEntity;
import rearth.oritech.util.MachineAddonController;

@Mixin(value={MachineAddonController.class})
public interface MachineAddonControllerMixin {
    @Shadow
    public void getAdditionalStatFromAddon(MachineAddonController.AddonBlock var1);

    @Shadow
    public void setBaseAddonData(MachineAddonController.BaseAddonData var1);

    @Overwrite
    default public void gatherAddonStats(List<MachineAddonController.AddonBlock> addons) {
        AddonBlockEntity addonBlockEntity;
        if (addons.size() == 1 && (addonBlockEntity = addons.getFirst().addonEntity()) instanceof CombiAddonEntity) {
            CombiAddonEntity combiAddonEntity = (CombiAddonEntity)addonBlockEntity;
            this.getAdditionalStatFromAddon(addons.getFirst());
            this.setBaseAddonData(combiAddonEntity.getBaseData());
            return;
        }
        float speed = 1.0f;
        float efficiency = 1.0f;
        long energyAmount = 0L;
        long energyInsert = 0L;
        int extraChambers = 0;
        int extraBurstTicks = 0;
        for (MachineAddonController.AddonBlock addon : addons) {
            MachineAddonBlock.AddonSettings addonSettings = addon.addonBlock().getAddonSettings();
            if (Oritech.CONFIG.additiveAddons()) {
                speed += 1.0f - addonSettings.speedMultiplier();
                efficiency += 1.0f - addonSettings.efficiencyMultiplier();
            } else {
                speed *= addonSettings.speedMultiplier();
                efficiency *= addonSettings.efficiencyMultiplier();
            }
            energyAmount += addonSettings.addedCapacity();
            energyInsert += addonSettings.addedInsert();
            extraChambers += addonSettings.chamberCount();
            extraBurstTicks += addonSettings.burstTicks();
            AddonBlockEntity addonBlockEntity2 = addon.addonEntity();
            if (addonBlockEntity2 instanceof PluginAddonExtenderBlockEntity) {
                PluginAddonExtenderBlockEntity be = (PluginAddonExtenderBlockEntity)addonBlockEntity2;
                MachineAddonBlock.AddonSettings settings = be.getSettings();
                if (Oritech.CONFIG.additiveAddons()) {
                    speed += settings.speedMultiplier();
                    efficiency += settings.efficiencyMultiplier();
                } else {
                    speed *= settings.speedMultiplier();
                    efficiency *= settings.efficiencyMultiplier();
                }
                energyAmount += settings.addedCapacity();
                energyInsert += settings.addedInsert();
                extraChambers += settings.chamberCount();
                extraBurstTicks += settings.burstTicks();
            }
            this.getAdditionalStatFromAddon(addon);
        }
        if (Oritech.CONFIG.additiveAddons()) {
            speed = 1.0f / speed;
            float efficiencyChange = efficiency - 1.0f;
            efficiency = 1.0f / efficiency;
            if (efficiencyChange < 0.0f) {
                efficiency = 1.0f + Math.abs(efficiencyChange);
            }
        }
        MachineAddonController.BaseAddonData baseData = new MachineAddonController.BaseAddonData(speed, efficiency, energyAmount, energyInsert, extraChambers, extraBurstTicks);
        this.setBaseAddonData(baseData);
    }
}

