/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client;

import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.EasingType;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.astemir.astemirlib.common.math.MathUtils;

public class SmoothValue<T> {
    private InterpolationType interpolationType;
    private EasingType easingType;
    private T value;
    private T valueTo;
    private T valueO;
    private boolean rotation;

    public SmoothValue(InterpolationType interpolationType, EasingType easingType, T value, T valueTo, boolean rotation) {
        this.interpolationType = interpolationType;
        this.easingType = easingType;
        this.value = value;
        this.valueO = value;
        this.valueTo = valueTo;
        this.rotation = rotation;
    }

    public void update(float speed) {
        this.valueO = this.value;
        this.value = InterpolationType.LINEAR.interpolateUniversal(this.value, this.valueTo, this.easingType.ease(speed));
    }

    public SmoothValue setTo(T value) {
        this.valueTo = value;
        return this;
    }

    public void setValue(T value) {
        this.value = value;
        this.valueO = value;
    }

    public T get(float speed) {
        T res = this.rotation ? this.interpolationType.interpolateRotUniversal(this.valueO, this.value, speed) : this.interpolationType.interpolateUniversal(this.valueO, this.value, speed);
        if (MathUtils.equalsApproxUniversal(this.valueO, this.value, 0.1f)) {
            return this.value;
        }
        return res;
    }

    public static <T> SmoothValue<T> create(InterpolationType interpolationType, EasingType easingType, T value, T valueTo, boolean rotation) {
        return new SmoothValue<T>(interpolationType, easingType, value, valueTo, rotation);
    }

    public static SmoothValue<AVector3f> valVec3(InterpolationType interpolationType) {
        return new SmoothValue<AVector3f>(interpolationType, EasingType.NONE, AVector3f.zero(), AVector3f.zero(), false);
    }

    public static SmoothValue<Double> valDouble(InterpolationType interpolationType, double defaultValue) {
        return new SmoothValue<Double>(interpolationType, EasingType.NONE, defaultValue, defaultValue, false);
    }
}

