/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client;

import com.mojang.blaze3d.Blaze3D;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="astemirlib")
public class TimeUtil {
    private static double lastTimeGlfw;
    private static long lastTimeSmooth;
    private static double deltaGlfw;
    private static double smoothedDelta;

    @SubscribeEvent
    public static void onRender(TickEvent.RenderTickEvent e) {
        if (e.phase == TickEvent.Phase.START) {
            TimeUtil.calculateDeltaGLFW();
            TimeUtil.calculateSmoothDelta();
        }
    }

    private static void calculateSmoothDelta() {
        long currentTime = System.nanoTime();
        if (lastTimeSmooth == 0L) {
            lastTimeSmooth = currentTime;
        }
        long elapsedTime = currentTime - lastTimeSmooth;
        lastTimeSmooth = currentTime;
        double deltaTime = (double)elapsedTime / 1.0E9;
        smoothedDelta += (deltaTime - smoothedDelta) * 0.1;
    }

    private static void calculateDeltaGLFW() {
        double currentTimeGlfw = Blaze3D.m_83640_();
        if (lastTimeGlfw == 0.0) {
            lastTimeGlfw = currentTimeGlfw;
        }
        deltaGlfw = currentTimeGlfw - lastTimeGlfw;
        lastTimeGlfw = (float)currentTimeGlfw;
    }

    public static double getSmoothedDelta() {
        return smoothedDelta;
    }

    public static double getDeltaGlfw() {
        return deltaGlfw;
    }
}

