/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client.bedrock.animation;

import java.util.HashMap;
import java.util.Map;
import ru.astemir.astemirlib.client.bedrock.animation.LoopType;
import ru.astemir.astemirlib.client.bedrock.json.AnimationTrack;
import ru.astemir.astemirlib.common.misc.KeyedTimeline;

public class Animation {
    private Map<String, AnimationTrack> tracks;
    private double length;
    private LoopType loop;
    private String name;

    public Animation(Map<String, AnimationTrack> tracks, double length, LoopType loop) {
        this.tracks = tracks;
        this.length = length;
        this.loop = loop;
    }

    public boolean hasTrack(String name) {
        return this.tracks.containsKey(name);
    }

    public AnimationTrack getTrack(String name) {
        return this.tracks.get(name);
    }

    public Map<String, AnimationTrack> getTracks() {
        return this.tracks;
    }

    public double getLength() {
        return this.length;
    }

    public LoopType getLoop() {
        return this.loop;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Animation merge(Animation other) {
        HashMap<String, AnimationTrack> newTracks = new HashMap<String, AnimationTrack>();
        float newLength = (float)(other.getLength() > this.length ? other.getLength() : this.length);
        for (Map.Entry<String, AnimationTrack> entry : this.tracks.entrySet()) {
            AnimationTrack track = entry.getValue();
            KeyedTimeline position = track.getPosition();
            KeyedTimeline rotation = track.getRotation();
            KeyedTimeline scale = track.getScale();
            if (!position.isEmpty() && newLength > position.getLength()) {
                position = position.extended(newLength);
            }
            if (!rotation.isEmpty() && newLength > rotation.getLength()) {
                rotation = rotation.extended(newLength);
            }
            if (!scale.isEmpty() && newLength > scale.getLength()) {
                scale = scale.extended(newLength);
            }
            newTracks.put(entry.getKey(), new AnimationTrack(position, rotation, scale));
        }
        for (Map.Entry<String, AnimationTrack> entry : other.getTracks().entrySet()) {
            newTracks.put(entry.getKey(), entry.getValue());
        }
        Animation animation = new Animation(newTracks, newLength, LoopType.FALSE);
        animation.setName(other.name);
        return animation;
    }
}

