/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client.bedrock.animation.data;

import java.util.concurrent.CopyOnWriteArrayList;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.EasingType;
import ru.astemir.astemirlib.common.math.InterpolationType;

public class AnimationBlending {
    public static final AnimationBlending NO_BLENDING = new AnimationBlending(true);
    private InterpolationType interpolationType;
    private EasingType easingType;
    private double blendTime;
    private double time;
    private boolean ended = false;
    private CopyOnWriteArrayList<BlendValue> blends = new CopyOnWriteArrayList();

    private AnimationBlending(InterpolationType interpolationType, EasingType easingType, double blendTime) {
        this.interpolationType = interpolationType;
        this.easingType = easingType;
        this.blendTime = blendTime;
    }

    public AnimationBlending(boolean ended) {
        this.ended = ended;
    }

    public void update(double delta) {
        if (this.time < this.blendTime) {
            this.time += delta;
            for (BlendValue blend : this.blends) {
                blend.update();
            }
        } else {
            this.ended = true;
            this.blends.clear();
        }
    }

    public void blendVector(AVector3f from, AVector3f to, boolean rot, BlendFunction function) {
        this.blends.add(new BlendValue(from, to, function, rot));
    }

    public AnimationBlending end() {
        this.ended = true;
        return this;
    }

    public boolean isEnded() {
        return this.ended;
    }

    public static AnimationBlending create(InterpolationType interpolationType, EasingType easingType, double blendTime) {
        return new AnimationBlending(interpolationType, easingType, blendTime);
    }

    public boolean restart(boolean force) {
        if (this.ended || force) {
            this.time = 0.0;
            this.ended = false;
            return true;
        }
        return false;
    }

    public InterpolationType getInterpolationType() {
        return this.interpolationType;
    }

    public EasingType getEasingType() {
        return this.easingType;
    }

    public double getBlendTime() {
        return this.blendTime;
    }

    public double getTime() {
        return this.time;
    }

    public class BlendValue {
        private AVector3f from;
        private AVector3f to;
        private BlendFunction function;
        private boolean rot;

        public BlendValue(AVector3f from, AVector3f to, BlendFunction function, boolean rot) {
            this.from = from;
            this.to = to;
            this.function = function;
            this.rot = rot;
        }

        public void update() {
            float t = (float)AnimationBlending.this.easingType.ease(AnimationBlending.this.time / AnimationBlending.this.blendTime);
            if (this.rot) {
                this.function.setValue(AnimationBlending.this.interpolationType.interpolateRot(this.from, this.to, (double)t));
            } else {
                this.function.setValue(AnimationBlending.this.interpolationType.interpolate(this.from, this.to, (double)t));
            }
        }
    }

    public static interface BlendFunction {
        public void setValue(AVector3f var1);
    }
}

