/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client.bedrock.animation.data;

import java.util.Map;
import ru.astemir.astemirlib.client.bedrock.animation.Animation;
import ru.astemir.astemirlib.client.bedrock.animation.LoopType;
import ru.astemir.astemirlib.client.bedrock.animation.data.AnimatableProperty;
import ru.astemir.astemirlib.client.bedrock.animation.data.AnimationBlending;
import ru.astemir.astemirlib.client.bedrock.animation.data.Animator;
import ru.astemir.astemirlib.client.bedrock.animation.data.PartMemoizer;
import ru.astemir.astemirlib.client.bedrock.animation.data.PartTransform;
import ru.astemir.astemirlib.client.bedrock.json.AnimationTrack;
import ru.astemir.astemirlib.client.bedrock.model.render.BedrockModelPart;

public class AnimationData {
    public static final AnimationData EMPTY = new AnimationData(null, AnimationBlending.NO_BLENDING, 1.0, 0);
    private Animation animation;
    private AnimationBlending blending;
    private double time;
    private boolean valid = true;
    private double speed;
    private int priority;
    private boolean stoppedOnLastFrame = false;

    public AnimationData(Animation animation, AnimationBlending blending, double speed, int priority) {
        this.animation = animation;
        this.speed = speed;
        this.blending = blending;
        this.priority = priority;
    }

    public void initializeBlend(Animator animator) {
        for (Map.Entry<String, AnimationTrack> entry : this.animation.getTracks().entrySet()) {
            String name = entry.getKey();
            AnimationTrack track = entry.getValue();
            PartTransform transform = animator.getTransform(name);
            BedrockModelPart part = animator.getModel().getPart(name);
            if (part == null) {
                return;
            }
            if (this.blending == AnimationBlending.NO_BLENDING) continue;
            if (track.hasPosition()) {
                this.blending.blendVector(transform.getPosition(), track.getPosition().getFirstFrame().getValue(), false, transform::setPosition);
            }
            if (track.hasRotation()) {
                this.blending.blendVector(transform.getRotation(), part.defaultRotation.deg().add(track.getRotation().getFirstFrame().getValue().mul(-1.0f, -1.0f, 1.0f)), true, transform::setRotation);
            }
            if (!track.hasScale()) continue;
            this.blending.blendVector(transform.getScale(), track.getScale().getFirstFrame().getValue(), false, transform::setScale);
        }
    }

    public void update(Animator animator, double delta) {
        PartMemoizer keeper = new PartMemoizer();
        if (this.blending.isEnded()) {
            if (!this.stoppedOnLastFrame) {
                if (this.time < this.animation.getLength()) {
                    this.time += delta * this.speed;
                } else if (this.animation.getLoop() == LoopType.HOLD_ON_LAST_FRAME) {
                    this.stoppedOnLastFrame = true;
                } else if (this.animation.getLoop() == LoopType.TRUE) {
                    this.time = 0.0;
                } else {
                    this.valid = false;
                }
            }
        } else {
            this.blending.update(delta);
        }
        for (Map.Entry<String, AnimationTrack> entry : this.animation.getTracks().entrySet()) {
            String name = entry.getKey();
            AnimationTrack track = entry.getValue();
            BedrockModelPart part = animator.getModel().getPart(name);
            if (part == null) continue;
            PartTransform transform = animator.getTransform(name);
            if (this.blending.isEnded()) {
                AnimationTrack.Result result = track.getResult((float)this.time);
                if (result.hasPosition() && !keeper.containsPart(name, AnimatableProperty.POSITION)) {
                    keeper.keep(name, AnimatableProperty.POSITION);
                    transform.setPosition(result.getPosition());
                }
                if (result.hasRotation() && !keeper.containsPart(name, AnimatableProperty.ROTATION)) {
                    keeper.keep(name, AnimatableProperty.ROTATION);
                    transform.setRotation(part.defaultRotation.deg().add(result.getRotation().mul(-1.0f, -1.0f, 1.0f)));
                }
                if (result.hasScale() && !keeper.containsPart(name, AnimatableProperty.SCALE)) {
                    keeper.keep(name, AnimatableProperty.SCALE);
                    transform.setScale(result.getScale());
                }
            }
            animator.setPartTransform(name, transform);
        }
    }

    public void replaceAnimation(Animator animator, Animation animation) {
        this.initializeBlend(animator);
        this.animation = animation;
    }

    public boolean isUsingPosition(String name) {
        if (!this.animation.hasTrack(name)) {
            return false;
        }
        return this.animation.getTrack(name).hasPosition();
    }

    public boolean isUsingRotation(String name) {
        if (!this.animation.hasTrack(name)) {
            return false;
        }
        return this.animation.getTrack(name).hasRotation();
    }

    public boolean isUsingScale(String name) {
        if (!this.animation.hasTrack(name)) {
            return false;
        }
        return this.animation.getTrack(name).hasScale();
    }

    public double getTime() {
        return this.time;
    }

    public boolean isUsingBone(String name) {
        return this.animation.hasTrack(name);
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public int getPriority() {
        return this.priority;
    }

    public boolean isValid() {
        return this.valid;
    }
}

