/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client.bedrock.animation.data;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.Minecraft;
import ru.astemir.astemirlib.client.TimeUtil;
import ru.astemir.astemirlib.client.bedrock.animation.Animation;
import ru.astemir.astemirlib.client.bedrock.animation.data.AnimationBlending;
import ru.astemir.astemirlib.client.bedrock.animation.data.AnimationData;
import ru.astemir.astemirlib.client.bedrock.animation.data.PartTransform;
import ru.astemir.astemirlib.client.bedrock.model.BedrockModel;
import ru.astemir.astemirlib.client.bedrock.model.render.BedrockModelPart;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.InterpolationType;

public class Animator {
    private BedrockModel model;
    private AnimationData animationData = AnimationData.EMPTY;
    private InterpolationType normalizingInterpolation = InterpolationType.CATMULLROM;
    private float normalizationSpeed = 1.0f;
    private Map<String, PartTransform> transformMap = new HashMap<String, PartTransform>();

    public Animator(BedrockModel model) {
        this.model = model;
    }

    public AnimationData setAnimation(String name, AnimationBlending blending, double speed, int priority) {
        Animation animation = this.getAnimation(name);
        if (animation != null) {
            return this.setAnimation(animation, blending, speed, priority);
        }
        return AnimationData.EMPTY;
    }

    public AnimationData setAnimation(Animation animation, AnimationBlending blending, double speed, int priority) {
        if (animation == null) {
            return AnimationData.EMPTY;
        }
        AnimationData data = new AnimationData(animation, blending, speed, priority);
        AnimationData current = this.getPlayingAnimation();
        if (!(current != AnimationData.EMPTY && current.getPriority() > priority || this.isPlayingAnimation(animation))) {
            data.initializeBlend(this);
            this.animationData = data;
        }
        return data;
    }

    public void stopAnimation() {
        this.resetAnimation();
    }

    public void stopAnimation(String name) {
        Animation animation = this.getAnimation(name);
        if (animation != null && this.isPlayingAnimation(animation)) {
            this.resetAnimation();
        }
    }

    public void stopAnimation(Animation animation) {
        if (this.isPlayingAnimation(animation)) {
            this.resetAnimation();
        }
    }

    public <T> void update(T object) {
        double delta = TimeUtil.getDeltaGlfw();
        boolean paused = Minecraft.m_91087_().m_91104_();
        if (!paused) {
            if (this.animationData != AnimationData.EMPTY) {
                if (this.animationData.isValid()) {
                    this.animationData.update(this, delta);
                } else {
                    this.resetAnimation();
                }
            }
            for (Map.Entry<String, PartTransform> entry : this.transformMap.entrySet()) {
                BedrockModelPart part;
                PartTransform transform = entry.getValue();
                if (!this.isUsingPosition(entry.getKey())) {
                    transform.setPosition(this.normalizingInterpolation.interpolate(transform.getPosition(), new AVector3f(0.0f, 0.0f, 0.0f), delta * (double)this.normalizationSpeed));
                }
                if (!this.isUsingRotation(entry.getKey()) && (part = this.model.getPart(entry.getKey())) != null) {
                    transform.setRotation(this.normalizingInterpolation.interpolateRot(transform.getRotation(), part.defaultRotation.deg(), delta * (double)this.normalizationSpeed));
                }
                if (this.isUsingScale(entry.getKey())) continue;
                transform.setScale(this.normalizingInterpolation.interpolate(transform.getScale(), new AVector3f(1.0f, 1.0f, 1.0f), delta * (double)this.normalizationSpeed));
            }
        }
    }

    public <T> void applyTransform(T object) {
        for (Map.Entry<String, PartTransform> entry : this.transformMap.entrySet()) {
            PartTransform transform = entry.getValue();
            BedrockModelPart part = this.model.getPart(entry.getKey());
            if (part == null) continue;
            part.setOffset(transform.getPosition().mul(-1.0f, 1.0f, 1.0f));
            part.setCustomOffset(transform.getCustomPosition());
            part.setRotation(transform.getRotation().rad());
            part.setCustomRotation(transform.getCustomRotation().rad());
            part.setScale(transform.getScale());
            part.setCustomScale(transform.getCustomScale());
        }
    }

    public void resetAnimation() {
        this.animationData = this.model.getDefaultAnimation(this, this.animationData.getAnimation());
    }

    public Animation getAnimation(String name) {
        return this.model.getAnimations().get(name);
    }

    public AnimationData getPlayingAnimation() {
        return this.animationData;
    }

    public boolean isPlayingAnimation(String name) {
        Animation animation = this.getAnimation(name);
        if (animation != null) {
            return this.isPlayingAnimation(animation);
        }
        return false;
    }

    public boolean isPlayingAnimation(Animation animation) {
        if (this.animationData == AnimationData.EMPTY) {
            return false;
        }
        return this.animationData.getAnimation().getName().equals(animation.getName());
    }

    public boolean isUsingPosition(String name) {
        if (this.animationData != AnimationData.EMPTY) {
            return this.animationData.isUsingPosition(name);
        }
        return false;
    }

    public boolean isUsingRotation(String name) {
        if (this.animationData != AnimationData.EMPTY) {
            return this.animationData.isUsingRotation(name);
        }
        return false;
    }

    public boolean isUsingScale(String name) {
        if (this.animationData != AnimationData.EMPTY) {
            return this.animationData.isUsingScale(name);
        }
        return false;
    }

    public boolean isUsingBone(String name) {
        if (this.animationData != AnimationData.EMPTY) {
            return this.animationData.isUsingBone(name);
        }
        return false;
    }

    public void setPartTransform(String name, PartTransform transform) {
        this.transformMap.put(name, transform);
    }

    public boolean hasTransform(String name) {
        return this.transformMap.containsKey(name);
    }

    public PartTransform getTransform(String name) {
        if (this.transformMap.containsKey(name)) {
            return this.transformMap.get(name);
        }
        PartTransform transform = new PartTransform(new AVector3f(0.0f, 0.0f, 0.0f), new AVector3f(0.0f, 0.0f, 0.0f), new AVector3f(1.0f, 1.0f, 1.0f));
        this.setPartTransform(name, transform);
        return transform;
    }

    public PartTransform getTransform(BedrockModel model, String name) {
        if (this.transformMap.containsKey(name)) {
            return this.transformMap.get(name);
        }
        BedrockModelPart part = model.getPart(name);
        if (part != null) {
            PartTransform transform = new PartTransform(part.getOffset().copy(), part.getRotation().copy(), part.getScale().copy());
            this.setPartTransform(name, transform);
        }
        return new PartTransform(new AVector3f(0.0f, 0.0f, 0.0f), new AVector3f(0.0f, 0.0f, 0.0f), new AVector3f(1.0f, 1.0f, 1.0f));
    }

    public Animator normalizingInterpolation(InterpolationType interpolation) {
        this.normalizingInterpolation = interpolation;
        return this;
    }

    public Animator normalizationSpeed(float speed) {
        this.normalizationSpeed = speed;
        return this;
    }

    public void check(BedrockModel model) {
        if (!this.model.equals(model)) {
            this.model = model;
            this.transformMap.clear();
        }
    }

    public BedrockModel getModel() {
        return this.model;
    }
}

