/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client.bedrock.json;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import ru.astemir.astemirlib.client.bedrock.animation.Animation;
import ru.astemir.astemirlib.client.bedrock.animation.LoopType;
import ru.astemir.astemirlib.client.bedrock.json.AnimationTrack;
import ru.astemir.astemirlib.client.bedrock.json.JsonParser;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.EasingType;
import ru.astemir.astemirlib.common.math.InterpolationType;
import ru.astemir.astemirlib.common.misc.KeyFrame;
import ru.astemir.astemirlib.common.misc.KeyedTimeline;

public class AnimationParser
implements JsonParser {
    public static Map<String, Animation> parseAnimations(ResourceLocation location) {
        LinkedHashMap<String, Animation> linkedHashMap;
        InputStreamReader reader = new InputStreamReader(Minecraft.m_91087_().m_91098_().m_215595_(location));
        try {
            JsonObject json = GsonHelper.m_13861_((Reader)reader, (boolean)true);
            JsonObject animationsJson = json.getAsJsonObject("animations");
            LinkedHashMap<String, Animation> animations = new LinkedHashMap<String, Animation>();
            for (String key : animationsJson.keySet()) {
                Animation animation = AnimationParser.parseAnimation(animationsJson.getAsJsonObject(key));
                animation.setName(key);
                animations.put(key, animation);
            }
            linkedHashMap = animations;
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                throw new RuntimeException("Error parsing animation", e);
            }
        }
        reader.close();
        return linkedHashMap;
    }

    private static Animation parseAnimation(JsonObject object) {
        LoopType loop = LoopType.FALSE;
        if (object.has("loop")) {
            loop = LoopType.valueOf(object.get("loop").getAsString().toUpperCase());
        }
        double animationLength = 0.0;
        if (object.has("animation_length")) {
            animationLength = object.get("animation_length").getAsDouble();
        }
        LinkedHashMap<String, AnimationTrack> tracks = new LinkedHashMap<String, AnimationTrack>();
        if (object.has("bones")) {
            JsonObject bonesJson = object.get("bones").getAsJsonObject();
            for (String key : bonesJson.keySet()) {
                tracks.put(key, AnimationParser.parseTrack(bonesJson.getAsJsonObject(key)));
            }
        }
        return new Animation(tracks, animationLength, loop);
    }

    private static AnimationTrack parseTrack(JsonObject object) {
        List<Object> positions = new ArrayList();
        List<Object> rotations = new ArrayList();
        List<Object> scales = new ArrayList();
        if (object.has("position")) {
            positions = AnimationParser.parseKeyFrames("position", object);
        }
        if (object.has("rotation")) {
            rotations = AnimationParser.parseKeyFrames("rotation", object);
        }
        if (object.has("scale")) {
            scales = AnimationParser.parseKeyFrames("scale", object);
        }
        return new AnimationTrack(new KeyedTimeline(positions.toArray(new KeyFrame[positions.size()])), new KeyedTimeline(rotations.toArray(new KeyFrame[rotations.size()])), new KeyedTimeline(scales.toArray(new KeyFrame[scales.size()])));
    }

    private static List<KeyFrame<AVector3f>> parseKeyFrames(String name, JsonObject object) {
        ArrayList<KeyFrame<AVector3f>> result = new ArrayList<KeyFrame<AVector3f>>();
        JsonElement boneJson = object.get(name);
        if (boneJson.isJsonObject()) {
            JsonObject boneJsonObject = boneJson.getAsJsonObject();
            for (String key : boneJsonObject.keySet()) {
                InterpolationType interpolationType;
                AVector3f value;
                float time = Float.parseFloat(key);
                JsonElement trackJson = boneJsonObject.get(key);
                if (trackJson.isJsonArray()) {
                    JsonArray array = trackJson.getAsJsonArray();
                    result.add(new KeyFrame<AVector3f>(time, JsonParser.toVec3((JsonElement)array), InterpolationType.LINEAR, EasingType.NONE));
                    continue;
                }
                if (!trackJson.isJsonObject()) continue;
                JsonObject jsonObject = trackJson.getAsJsonObject();
                JsonElement postJson = jsonObject.get("post");
                if (postJson.isJsonObject()) {
                    value = JsonParser.toVec3((JsonElement)postJson.getAsJsonObject().getAsJsonArray("vector"));
                    EasingType easingType = EasingType.valueOf(postJson.getAsJsonObject().get("easing").getAsString().toUpperCase());
                    interpolationType = InterpolationType.valueOf(jsonObject.get("lerp_mode").getAsString().toUpperCase());
                    result.add(new KeyFrame<AVector3f>(time, value, interpolationType, easingType));
                    continue;
                }
                value = JsonParser.toVec3(postJson);
                AVector3f pre = null;
                if (jsonObject.has("pre")) {
                    pre = JsonParser.toVec3(jsonObject.get("pre"));
                }
                interpolationType = InterpolationType.valueOf(jsonObject.get("lerp_mode").getAsString().toUpperCase());
                result.add(new KeyFrame<AVector3f>(time, value, interpolationType, EasingType.NONE).setPreValue(pre));
            }
        } else if (boneJson.isJsonArray()) {
            result.add(new KeyFrame<AVector3f>(0.0f, JsonParser.toVec3(boneJson), InterpolationType.LINEAR, EasingType.NONE));
        } else if (boneJson.isJsonPrimitive()) {
            if (boneJson.getAsJsonPrimitive().isNumber()) {
                float f = boneJson.getAsFloat();
                result.add(new KeyFrame<AVector3f>(0.0f, new AVector3f(f, f, f), InterpolationType.LINEAR, EasingType.NONE));
            } else {
                result.add(new KeyFrame<AVector3f>(0.0f, new AVector3f(0.0f, 0.0f, 0.0f), InterpolationType.LINEAR, EasingType.NONE));
            }
        }
        return result;
    }
}

