/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client.bedrock.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import net.minecraft.util.GsonHelper;
import ru.astemir.astemirlib.client.bedrock.json.JsonAdapter;
import ru.astemir.astemirlib.client.bedrock.model.render.uv.UVFace;
import ru.astemir.astemirlib.client.bedrock.model.render.uv.UVType;
import ru.astemir.astemirlib.common.math.AVector2f;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.MathUtils;

public interface JsonParser {
    public static final Gson GSON = new GsonBuilder().registerTypeAdapter(AVector2f.class, (Object)new JsonAdapter.Vector2f()).registerTypeAdapter(UVFace.class, (Object)new UVFace.Deserializer()).registerTypeAdapter(UVType.class, (Object)new UVType.Deserializer()).create();

    public static float getOrEvalFloat(JsonPrimitive primitive) {
        if (primitive.isString()) {
            return (float)MathUtils.eval(primitive.getAsString());
        }
        if (primitive.isNumber()) {
            return primitive.getAsFloat();
        }
        return 0.0f;
    }

    public static AVector3f getAsVec3(JsonObject parent, String memberName) {
        return JsonParser.toVec3((JsonElement)GsonHelper.m_13933_((JsonObject)parent, (String)memberName));
    }

    public static AVector3f getAsVec3(JsonObject parent, String memberName, AVector3f defaultVal) {
        if (parent.has(memberName)) {
            return JsonParser.getAsVec3(parent, memberName);
        }
        return defaultVal;
    }

    public static AVector3f toVec3(JsonElement json) {
        if (json.isJsonPrimitive()) {
            float value = json.getAsFloat();
            return new AVector3f(value, value, value);
        }
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            if (array.size() == 0) {
                return new AVector3f(0.0f, 0.0f, 0.0f);
            }
            if (array.size() == 1) {
                float value = JsonParser.getOrEvalFloat(array.get(0).getAsJsonPrimitive());
                return new AVector3f(value, value, value);
            }
            if (array.size() == 2) {
                float x = JsonParser.getOrEvalFloat(array.get(0).getAsJsonPrimitive());
                float y = JsonParser.getOrEvalFloat(array.get(1).getAsJsonPrimitive());
                return new AVector3f(x, y, 0.0f);
            }
            if (array.size() == 3) {
                float x = JsonParser.getOrEvalFloat(array.get(0).getAsJsonPrimitive());
                float y = JsonParser.getOrEvalFloat(array.get(1).getAsJsonPrimitive());
                float z = JsonParser.getOrEvalFloat(array.get(2).getAsJsonPrimitive());
                return new AVector3f(x, y, z);
            }
        }
        throw new RuntimeException("Invalid vector3 " + json);
    }
}

