/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client.bedrock.model;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.Model;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.RenderHandEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import ru.astemir.astemirlib.client.bedrock.animation.Animated;
import ru.astemir.astemirlib.client.bedrock.animation.Animation;
import ru.astemir.astemirlib.client.bedrock.animation.data.Animator;
import ru.astemir.astemirlib.client.bedrock.json.AnimationParser;
import ru.astemir.astemirlib.client.bedrock.json.BedrockModelParser;
import ru.astemir.astemirlib.client.bedrock.model.BedrockModel;
import ru.astemir.astemirlib.client.bedrock.model.BedrockModelLayer;
import ru.astemir.astemirlib.client.bedrock.model.render.BedrockModelPart;
import ru.astemir.astemirlib.common.item.BedrockItem;

public abstract class BedrockItemModel<T extends ItemStack>
extends Model
implements BedrockModel<T> {
    private BedrockModelPart modelRoot;
    private Map<String, Animation> animations;
    private LinkedList<BedrockModelLayer<T>> layers = new LinkedList();
    private double lastTick = 0.0;

    public BedrockItemModel(ResourceLocation model, ResourceLocation animations) {
        super(texture -> RenderType.m_110463_());
        this.modelRoot = BedrockModelParser.parseModel(model).bakeRoot();
        this.animations = animations != null ? AnimationParser.parseAnimations(animations) : new HashMap<String, Animation>();
    }

    public void updateAnimations(T itemStack, LivingEntity entity, ItemDisplayContext transformType, double partialTick, float equipProcess, float swingProcess) {
        double currentTick;
        this.resetAll();
        Animator animator = ((Animated)itemStack).getOrCreateAnimator(this);
        if (entity != null && this.lastTick != (currentTick = (double)entity.f_19797_ + partialTick)) {
            this.lastTick = currentTick;
            animator.check(this);
            animator.update(itemStack);
        }
        animator.applyTransform(itemStack);
        this.animate(animator, itemStack, entity, transformType, partialTick, equipProcess, swingProcess);
    }

    public abstract void animate(Animator var1, T var2, LivingEntity var3, ItemDisplayContext var4, double var5, float var7, float var8);

    public void m_7695_(PoseStack poseStack, VertexConsumer vertexConsumer, int light, int overlay, float red, float green, float blue, float alpha) {
        this.modelRoot.m_104306_(poseStack, vertexConsumer, light, overlay, red, green, blue, alpha);
    }

    @Override
    public LinkedList<BedrockModelLayer<T>> getLayers() {
        return this.layers;
    }

    @Override
    public BedrockModelPart getRoot() {
        return this.modelRoot;
    }

    @Override
    public Map<String, Animation> getAnimations() {
        return this.animations;
    }

    @Mod.EventBusSubscriber(modid="astemirlib", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
    public static class EventHandler {
        @SubscribeEvent
        public static void onRenderHand(RenderHandEvent e) {
            ItemStack itemStack = e.getItemStack();
            Item item = itemStack.m_41720_();
            if (item instanceof BedrockItem) {
                BedrockItem bedrockItem = (BedrockItem)item;
                BedrockItemModel model = bedrockItem.getModel(itemStack);
                LocalPlayer player = Minecraft.m_91087_().f_91074_;
                model.updateAnimations(itemStack, (LivingEntity)player, e.getHand() == InteractionHand.MAIN_HAND ? ItemDisplayContext.FIRST_PERSON_RIGHT_HAND : ItemDisplayContext.FIRST_PERSON_LEFT_HAND, e.getPartialTick(), e.getEquipProgress(), e.getSwingProgress());
            }
        }
    }
}

