/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client.bedrock.model.render;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.ArrayList;
import net.minecraft.core.Direction;
import org.joml.Matrix3f;
import org.joml.Matrix4f;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import org.joml.Vector4f;
import ru.astemir.astemirlib.client.bedrock.model.render.uv.UV;
import ru.astemir.astemirlib.common.math.AVector3f;

public class BedrockCubeRender {
    private final ModelQuad[] quads;
    private AVector3f size;

    private BedrockCubeRender(ModelQuad[] quads, AVector3f size) {
        this.quads = quads;
        this.size = size;
    }

    public static BedrockCubeRender make(AVector3f origin, AVector3f size, UV uvResolver, float inflate, boolean mirror, int textureWidth, int textureHeight) {
        float width = size.x;
        float height = size.y;
        float depth = size.z;
        float x1 = origin.x;
        float y1 = origin.y;
        float z1 = origin.z;
        ArrayList<ModelQuad> quads = new ArrayList<ModelQuad>(6);
        float x2 = x1 + Math.max(width, 0.008f);
        float y2 = y1 + Math.max(height, 0.008f);
        float z2 = z1 + Math.max(depth, 0.008f);
        AVector3f v1 = new AVector3f(x1 -= inflate, y1 -= inflate, z1 -= inflate);
        AVector3f v2 = new AVector3f(x2 += inflate, y1, z1);
        AVector3f v3 = new AVector3f(x2, y2 += inflate, z1);
        AVector3f v4 = new AVector3f(x1, y2, z1);
        AVector3f v5 = new AVector3f(x1, y1, z2 += inflate);
        AVector3f v6 = new AVector3f(x1, y2, z2);
        AVector3f v7 = new AVector3f(x2, y2, z2);
        AVector3f v8 = new AVector3f(x2, y1, z2);
        if (width != 0.0f && height != 0.0f) {
            quads.add(BedrockCubeRender.makeQuad(v3, v2, v1, v4, uvResolver, textureWidth, textureHeight, mirror, Direction.NORTH));
            quads.add(BedrockCubeRender.makeQuad(v6, v5, v8, v7, uvResolver, textureWidth, textureHeight, mirror, Direction.SOUTH));
        }
        if (depth != 0.0f && height != 0.0f) {
            quads.add(BedrockCubeRender.makeQuad(v4, v1, v5, v6, uvResolver, textureWidth, textureHeight, mirror, !mirror ? Direction.WEST : Direction.EAST));
            quads.add(BedrockCubeRender.makeQuad(v7, v8, v2, v3, uvResolver, textureWidth, textureHeight, mirror, !mirror ? Direction.EAST : Direction.WEST));
        }
        if (width != 0.0f && depth != 0.0f) {
            quads.add(BedrockCubeRender.makeQuad(v2, v8, v5, v1, uvResolver, textureWidth, textureHeight, mirror, Direction.DOWN));
            quads.add(BedrockCubeRender.makeQuad(v7, v3, v4, v6, uvResolver, textureWidth, textureHeight, mirror, Direction.UP));
        }
        return new BedrockCubeRender(quads.toArray(new ModelQuad[0]), size);
    }

    private static ModelQuad makeQuad(AVector3f pos1, AVector3f pos2, AVector3f pos3, AVector3f pos4, UV uvResolver, int textureWidth, int textureHeight, boolean mirror, Direction direction) {
        UV.Sized uv = uvResolver.get(direction);
        float u1 = (float)uv.u1() / (float)textureWidth;
        float u2 = (float)uv.u2() / (float)textureWidth;
        float v1 = (float)uv.v1() / (float)textureHeight;
        float v2 = (float)uv.v2() / (float)textureHeight;
        if (mirror) {
            float temp = u1;
            u1 = u2;
            u2 = temp;
        }
        return new ModelQuad(new ModelVertex[]{BedrockCubeRender.makeVertex(pos1, u1, v1), BedrockCubeRender.makeVertex(pos2, u1, v2), BedrockCubeRender.makeVertex(pos3, u2, v2), BedrockCubeRender.makeVertex(pos4, u2, v1)}, mirror, AVector3f.from(direction.m_253071_()));
    }

    private static ModelVertex makeVertex(AVector3f pos, float u, float v) {
        return new ModelVertex(pos, u, v);
    }

    public void compile(PoseStack.Pose pose, VertexConsumer vertexConsumer, int packedLight, int packedOverlay, float red, float green, float blue, float alpha) {
        Matrix4f matrix4f = pose.m_252922_();
        Matrix3f matrix3f = pose.m_252943_();
        for (ModelQuad quad : this.quads) {
            AVector3f normal = AVector3f.from(matrix3f.transform(new Vector3f((Vector3fc)quad.normal.toVector3f())));
            for (ModelVertex vertex : quad.vertices) {
                float x = vertex.pos().x / 16.0f;
                float y = vertex.pos().y / 16.0f;
                float z = vertex.pos().z / 16.0f;
                Vector4f pos = new Vector4f(x, y, z, 1.0f);
                pos = matrix4f.transform(pos);
                vertexConsumer.m_5954_(pos.x(), pos.y(), pos.z(), red, green, blue, alpha, vertex.u(), vertex.v(), packedOverlay, packedLight, normal.x, normal.y, normal.z);
            }
        }
    }

    private static class ModelQuad {
        public final ModelVertex[] vertices;
        public final AVector3f normal;

        public ModelQuad(ModelVertex[] vertices, boolean mirror, AVector3f normal) {
            this.vertices = vertices;
            this.normal = normal;
            if (mirror) {
                this.normal.mul(-1.0f, 1.0f, 1.0f);
            }
        }
    }

    private record ModelVertex(AVector3f pos, float u, float v) {
    }
}

