/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client.bedrock.model.render.uv;

import java.util.Map;
import net.minecraft.core.Direction;
import ru.astemir.astemirlib.client.bedrock.model.render.uv.UVFace;
import ru.astemir.astemirlib.common.math.AVector2f;
import ru.astemir.astemirlib.common.math.AVector3f;

public interface UV {
    public Sized get(Direction var1);

    public record Faced(Map<Direction, UVFace> mappings) implements UV
    {
        @Override
        public Sized get(Direction direction) {
            UVFace uvDefinition = this.mappings.get(direction);
            return new Sized((int)uvDefinition.uv().x, (int)uvDefinition.uv().y, (int)(uvDefinition.uv().x + uvDefinition.size().x), (int)(uvDefinition.uv().y + uvDefinition.size().y));
        }
    }

    public record Box(AVector2f uv, AVector3f size) implements UV
    {
        @Override
        public Sized get(Direction direction) {
            switch (direction) {
                case EAST: {
                    return Sized.create(this.uv.x, this.uv.y + (float)this.depth(), this.uv.x + (float)this.depth(), this.uv.y + (float)this.depth() + (float)this.height());
                }
                case WEST: {
                    return Sized.create(this.uv.x + (float)this.depth() + (float)this.width(), this.uv.y + (float)this.depth(), this.uv.x + (float)this.depth() + (float)this.width() + (float)this.depth(), this.uv.y + (float)this.depth() + (float)this.height());
                }
                case DOWN: {
                    return Sized.create(this.uv.x + (float)this.depth() + (float)this.width(), this.uv.y + (float)this.depth(), this.uv.x + (float)this.depth() + (float)this.width() + (float)this.width(), this.uv.y);
                }
                case UP: {
                    return Sized.create(this.uv.x + (float)this.depth(), this.uv.y, this.uv.x + (float)this.depth() + (float)this.width(), this.uv.y + (float)this.depth());
                }
                case NORTH: {
                    return Sized.create(this.uv.x + (float)this.depth(), this.uv.y + (float)this.depth(), this.uv.x + (float)this.depth() + (float)this.width(), this.uv.y + (float)this.depth() + (float)this.height());
                }
                case SOUTH: {
                    return Sized.create(this.uv.x + (float)this.depth() + (float)this.width() + (float)this.depth(), this.uv.y + (float)this.depth(), this.uv.x + (float)this.depth() + (float)this.width() + (float)this.depth() + (float)this.width(), this.uv.y + (float)this.depth() + (float)this.height());
                }
            }
            throw new IllegalStateException("Wrong direction");
        }

        public int width() {
            return (int)this.size.x;
        }

        public int height() {
            return (int)this.size.y;
        }

        public int depth() {
            return (int)this.size.z;
        }
    }

    public record Sized(int u1, int v1, int u2, int v2) {
        public static Sized create(float u1, float v1, float u2, float v2) {
            return new Sized((int)Math.ceil(u1), (int)Math.ceil(v1), (int)Math.ceil(u2), (int)Math.ceil(v2));
        }
    }
}

