/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.client.event;

import com.mojang.blaze3d.vertex.PoseStack;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.ItemInHandRenderer;
import net.minecraft.client.renderer.ItemModelShaper;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.eventbus.api.Cancelable;
import net.minecraftforge.eventbus.api.Event;

public abstract class ItemRenderEvent
extends Event {

    public static class ModifyItemModel
    extends ItemRenderEvent {
        private ItemStack itemStack;
        private Level level;
        private LivingEntity livingEntity;
        private ItemModelShaper itemModelShaper;
        private int id;
        private BakedModel resultModel;

        public ModifyItemModel(ItemStack itemStack, Level level, LivingEntity livingEntity, ItemModelShaper itemModelShaper, int id) {
            this.itemStack = itemStack;
            this.level = level;
            this.livingEntity = livingEntity;
            this.itemModelShaper = itemModelShaper;
            this.id = id;
        }

        public void setResultModel(BakedModel resultModel) {
            this.resultModel = resultModel;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public Level getLevel() {
            return this.level;
        }

        public LivingEntity getLivingEntity() {
            return this.livingEntity;
        }

        public ItemModelShaper getItemModelShaper() {
            return this.itemModelShaper;
        }

        public int getId() {
            return this.id;
        }

        public BakedModel getResultModel() {
            return this.resultModel;
        }
    }

    public static class ModifyRenderModel
    extends ItemRenderEvent {
        private BakedModel model;
        private ItemStack itemStack;
        private ItemDisplayContext displayContext;
        private boolean inHand;
        private PoseStack poseStack;
        private MultiBufferSource bufferSource;
        private ItemModelShaper itemModelShaper;
        private int packedLight;
        private int packedOverlay;

        public ModifyRenderModel(BakedModel model, ItemStack itemStack, ItemDisplayContext displayContext, boolean inHand, PoseStack poseStack, MultiBufferSource bufferSource, ItemModelShaper itemModelShaper, int packedLight, int packedOverlay) {
            this.model = model;
            this.itemStack = itemStack;
            this.displayContext = displayContext;
            this.inHand = inHand;
            this.poseStack = poseStack;
            this.bufferSource = bufferSource;
            this.itemModelShaper = itemModelShaper;
            this.packedLight = packedLight;
            this.packedOverlay = packedOverlay;
        }

        public void setModel(BakedModel model) {
            this.model = model;
        }

        public BakedModel getModel() {
            return this.model;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public ItemDisplayContext getDisplayContext() {
            return this.displayContext;
        }

        public ItemModelShaper getItemModelShaper() {
            return this.itemModelShaper;
        }

        public boolean isInHand() {
            return this.inHand;
        }

        public PoseStack getPoseStack() {
            return this.poseStack;
        }

        public MultiBufferSource getBufferSource() {
            return this.bufferSource;
        }

        public int getPackedLight() {
            return this.packedLight;
        }

        public int getPackedOverlay() {
            return this.packedOverlay;
        }
    }

    @Cancelable
    public static class InPlayerHandRender
    extends ItemRenderEvent {
        private ItemStack itemStack;
        private EntityModel model;
        private ItemInHandRenderer itemInHandRenderer;
        private LivingEntity livingEntity;
        private ItemDisplayContext displayContext;
        private HumanoidArm arm;
        private PoseStack poseStack;
        private MultiBufferSource bufferSource;
        private int packedLight;

        public InPlayerHandRender(ItemStack itemStack, EntityModel model, ItemInHandRenderer itemInHandRenderer, LivingEntity livingEntity, ItemDisplayContext displayContext, HumanoidArm arm, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
            this.itemStack = itemStack;
            this.model = model;
            this.itemInHandRenderer = itemInHandRenderer;
            this.livingEntity = livingEntity;
            this.displayContext = displayContext;
            this.arm = arm;
            this.poseStack = poseStack;
            this.bufferSource = bufferSource;
            this.packedLight = packedLight;
        }

        public ItemStack getItemStack() {
            return this.itemStack;
        }

        public EntityModel getModel() {
            return this.model;
        }

        public ItemInHandRenderer getItemInHandRenderer() {
            return this.itemInHandRenderer;
        }

        public LivingEntity getLivingEntity() {
            return this.livingEntity;
        }

        public ItemDisplayContext getDisplayContext() {
            return this.displayContext;
        }

        public HumanoidArm getArm() {
            return this.arm;
        }

        public PoseStack getPoseStack() {
            return this.poseStack;
        }

        public MultiBufferSource getBufferSource() {
            return this.bufferSource;
        }

        public int getPackedLight() {
            return this.packedLight;
        }
    }
}

