/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.common.entity;

import java.util.List;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.MobType;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import ru.astemir.astemirlib.common.handler.LevelEvent;
import ru.astemir.astemirlib.common.math.AVector2f;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.MathUtils;
import ru.astemir.astemirlib.common.network.NetworkUtils;
import ru.astemir.astemirlib.common.network.PacketArgument;
import ru.astemir.astemirlib.common.network.messages.ClientMessageEntityEvent;
import ru.astemir.astemirlib.common.network.messages.ServerMessageEntityEvent;

public class EntityUtils {
    public static AVector3f getDirection(Entity entity) {
        float rotationYaw = Mth.m_14179_((float)0.1f, (float)entity.f_19859_, (float)entity.m_146908_());
        float rotationPitch = Mth.m_14179_((float)0.1f, (float)entity.f_19860_, (float)entity.m_146909_());
        float vx = -MathUtils.sin(MathUtils.rad(rotationYaw)) * MathUtils.cos(MathUtils.rad(rotationPitch));
        float vz = MathUtils.cos(MathUtils.rad(rotationYaw)) * MathUtils.cos(MathUtils.rad(rotationPitch));
        float vy = -MathUtils.sin(MathUtils.rad(rotationPitch));
        return new AVector3f(vx, vy, vz);
    }

    public static void damageEntity(LivingEntity damager, Entity target) {
        EntityUtils.damageEntity(damager, target, 1.0f, false);
    }

    public static void damageEntity(LivingEntity damager, Entity target, boolean breakShield) {
        EntityUtils.damageEntity(damager, target, 1.0f, breakShield);
    }

    public static void damageEntity(LivingEntity damager, Entity target, float multiplier) {
        EntityUtils.damageEntity(damager, target, multiplier, false);
    }

    public static void damageEntity(LivingEntity damager, Entity target, float multiplier, boolean breakShield) {
        int i;
        float f = (float)damager.m_21133_(Attributes.f_22281_);
        float f1 = (float)damager.m_21133_(Attributes.f_22282_);
        if (target instanceof LivingEntity) {
            f += EnchantmentHelper.m_44833_((ItemStack)damager.m_21205_(), (MobType)((LivingEntity)target).m_6336_());
            f1 += (float)EnchantmentHelper.m_44894_((LivingEntity)damager);
        }
        if ((i = EnchantmentHelper.m_44914_((LivingEntity)damager)) > 0) {
            target.m_20254_(i * 4);
        }
        boolean flag = target.m_6469_(damager.m_269291_().m_269333_(damager), f * multiplier);
        if (target instanceof Player) {
            ItemStack usingItem;
            Player player = (Player)target;
            ItemStack mainHand = damager.m_21205_();
            ItemStack itemStack = usingItem = player.m_6117_() ? player.m_21211_() : ItemStack.f_41583_;
            if ((!mainHand.m_41619_() && mainHand.m_41720_() instanceof AxeItem || breakShield) && usingItem.m_150930_(Items.f_42740_)) {
                player.m_36335_().m_41524_(Items.f_42740_, 100);
                player.m_5810_();
                damager.m_9236_().m_7605_((Entity)player, (byte)30);
            }
        }
        if (flag) {
            if (f1 > 0.0f && target instanceof LivingEntity) {
                ((LivingEntity)target).m_147240_((double)(f1 * 0.5f), (double)Mth.m_14031_((float)(damager.m_146908_() * ((float)Math.PI / 180))), (double)(-Mth.m_14089_((float)(damager.m_146908_() * ((float)Math.PI / 180)))));
                damager.m_20256_(damager.m_20184_().m_82542_(0.6, 1.0, 0.6));
            }
            damager.m_19970_(damager, target);
            damager.m_21335_(target);
        }
    }

    public static AVector3f directionTo(Entity from, Entity to) {
        return AVector3f.from(from.m_20182_()).direction(AVector3f.from(to.m_20182_()));
    }

    public static Entity rotate(Entity entity, AVector3f direction) {
        AVector2f rot = direction.mul(1.0f, 0.0f, 1.0f).yawPitchDeg();
        entity.m_146922_(-rot.x);
        entity.m_5618_(-rot.x);
        entity.m_146926_(-rot.y);
        entity.f_19859_ = -rot.x;
        entity.f_19860_ = -rot.y;
        if (entity instanceof LivingEntity) {
            LivingEntity livingEntity = (LivingEntity)entity;
            livingEntity.f_20883_ = -rot.x;
            livingEntity.f_20885_ = -rot.x;
        }
        return entity;
    }

    public static Entity setPositionRotation(Entity entity, AVector3f position, float yaw, float pitch) {
        entity.m_7678_((double)position.x, (double)position.y, (double)position.z, yaw, pitch);
        return entity;
    }

    public static boolean canBeTargeted(Player player) {
        return !player.m_7500_() && !player.m_5833_();
    }

    public static boolean hasTarget(Mob mob) {
        return EntityUtils.isEntityExist((Entity)mob.m_5448_());
    }

    public static boolean isEntityExist(Entity entity) {
        if (entity != null) {
            return entity.m_6084_();
        }
        return false;
    }

    public static boolean isMovingByPlayer(Entity entity) {
        boolean isMovingByPlayer = false;
        LivingEntity entity1 = entity.m_6688_();
        if (entity1 instanceof Player && entity1 != null) {
            Player player = (Player)entity1;
            isMovingByPlayer = player.f_20900_ > 0.0f || player.f_20902_ > 0.0f || player.f_20900_ < 0.0f || player.f_20902_ < 0.0f;
        }
        return isMovingByPlayer;
    }

    public static boolean isMoving(LivingEntity entity, float min, float max, float partialTicks) {
        boolean shouldSit;
        float walkingSpeed = 0.0f;
        boolean bl = shouldSit = entity.m_20159_() && entity.m_20202_() != null && entity.m_20202_().shouldRiderSit();
        if (!shouldSit && entity.m_6084_() && (walkingSpeed = entity.f_267362_.m_267711_(partialTicks)) > 1.0f) {
            walkingSpeed = 1.0f;
        }
        return !(walkingSpeed > min) || !(walkingSpeed < max);
    }

    public static boolean isMoving(Entity entity, float min, float max) {
        return !(entity.m_20184_().m_82553_() > (double)min) || !(entity.m_20184_().m_82553_() < (double)max) || EntityUtils.isMovingByPlayer(entity);
    }

    public static float getMotionPotential(Entity entity) {
        float f = Math.min((float)entity.m_20184_().m_82556_() * 100.0f, 1.0f);
        return f;
    }

    public static boolean isEntityLookingAtDegree(Entity entity, LivingEntity looker, double degree) {
        return EntityUtils.isEntityLookingAt(entity, looker, degree *= 1.0 + (double)looker.m_20270_(entity) * 0.1);
    }

    public static boolean isEntityLookingAt(Entity entity, LivingEntity looker) {
        return EntityUtils.isEntityLookingAt(entity, looker, 0.025);
    }

    public static boolean isEntityLookingAt(Entity entity, LivingEntity looker, double d) {
        Vec3 vec3 = looker.m_20252_(1.0f).m_82541_();
        Vec3 vec31 = new Vec3(entity.m_20185_() - looker.m_20185_(), entity.m_20188_() - looker.m_20188_(), entity.m_20189_() - looker.m_20189_());
        double d0 = vec31.m_82553_();
        double d1 = vec3.m_82526_(vec31 = vec31.m_82541_());
        return d1 > 1.0 - d / d0 ? looker.m_142582_(entity) : false;
    }

    public static boolean equalsByUUID(Entity entity, UUID uuid) {
        if (entity != null && uuid != null) {
            return entity.m_20148_().equals(uuid);
        }
        return false;
    }

    public static boolean equalsByUUID(Entity a, Entity b) {
        if (a != null && b != null) {
            return EntityUtils.equalsByUUID(a, b.m_20148_());
        }
        return false;
    }

    public static <T extends Entity> List<T> getEntities(EntityType<T> type, Level level, BlockPos pos, float radius, Predicate<? super T> predicate) {
        return level.m_142425_(type, new AABB(pos).m_82400_((double)radius), predicate);
    }

    public static <T extends Entity> List<T> getEntities(Class<T> entityClass, Level level, BlockPos pos, float radius, Predicate<? super T> predicate) {
        return level.m_6443_(entityClass, new AABB(pos).m_82400_((double)radius), predicate);
    }

    public static <T extends Entity> List<T> getEntities(Class<T> entityClass, Level level, BlockPos pos, float radius) {
        return level.m_45976_(entityClass, new AABB(pos).m_82400_((double)radius));
    }

    public static <T extends Entity> T getEntity(Class<T> entityClass, Level level, BlockPos pos, float radius, Predicate<? super T> predicate) {
        List<T> list = EntityUtils.getEntities(entityClass, level, pos, radius, predicate);
        if (list.size() > 0) {
            return (T)((Entity)list.get(0));
        }
        return null;
    }

    public static <T extends Entity> T getEntity(Class<T> entityClass, Level level, BlockPos pos, float radius) {
        List<T> list = EntityUtils.getEntities(entityClass, level, pos, radius);
        if (list.size() > 0) {
            return (T)((Entity)list.get(0));
        }
        return null;
    }

    public static BlockHitResult getBlockHit(Entity entity, double distance) {
        return EntityUtils.getBlockHit(entity, 0.0f, 0.0f, distance);
    }

    public static BlockHitResult getBlockHit(Entity entity, float xRot, float yRot, double distance) {
        float f = entity.m_146909_() + xRot;
        float f1 = entity.m_146908_() + yRot;
        Vec3 eyePos = entity.m_146892_();
        float f2 = Mth.m_14089_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f3 = Mth.m_14031_((float)(-f1 * ((float)Math.PI / 180) - (float)Math.PI));
        float f4 = -Mth.m_14089_((float)(-f * ((float)Math.PI / 180)));
        float f5 = Mth.m_14031_((float)(-f * ((float)Math.PI / 180)));
        float f6 = f3 * f4;
        float f7 = f2 * f4;
        Vec3 vec31 = eyePos.m_82520_((double)f6 * distance, (double)f5 * distance, (double)f7 * distance);
        return entity.m_9236_().m_45547_(new ClipContext(eyePos, vec31, ClipContext.Block.OUTLINE, ClipContext.Fluid.NONE, entity));
    }

    public static <T extends Entity> void playClientEvent(T entity, LevelEvent event, PacketArgument ... arguments) {
        if (entity.m_9236_().f_46443_) {
            return;
        }
        NetworkUtils.sendToAllPlayers(new ClientMessageEntityEvent(entity.m_19879_(), event.getId(), arguments));
    }

    public static <T extends Entity> void playClientEvent(T entity, ServerPlayer player, LevelEvent event, PacketArgument ... arguments) {
        if (entity.m_9236_().f_46443_) {
            return;
        }
        NetworkUtils.sendToPlayer(player, new ClientMessageEntityEvent(entity.m_19879_(), event.getId(), arguments));
    }

    public static <T extends Entity> void playServerEvent(T entity, LevelEvent event, PacketArgument ... arguments) {
        if (!entity.m_9236_().f_46443_) {
            return;
        }
        NetworkUtils.sendToServer(new ServerMessageEntityEvent(entity.m_19879_(), event.getId(), arguments));
    }

    public static <T extends Entity> void playClientEvent(T entity, int event, PacketArgument ... arguments) {
        if (entity.m_9236_().f_46443_) {
            return;
        }
        NetworkUtils.sendToAllPlayers(new ClientMessageEntityEvent(entity.m_19879_(), event, arguments));
    }

    public static <T extends Entity> void playClientEvent(T entity, ServerPlayer serverPlayer, int event, PacketArgument ... arguments) {
        if (entity.m_9236_().f_46443_) {
            return;
        }
        NetworkUtils.sendToPlayer(serverPlayer, new ClientMessageEntityEvent(entity.m_19879_(), event, arguments));
    }

    public static <T extends Entity> void playServerEvent(T entity, int event, PacketArgument ... arguments) {
        if (!entity.m_9236_().f_46443_) {
            return;
        }
        NetworkUtils.sendToServer(new ServerMessageEntityEvent(entity.m_19879_(), event, arguments));
    }
}

