/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.common.math;

import ru.astemir.astemirlib.common.math.AVector2f;
import ru.astemir.astemirlib.common.math.AVector3f;
import ru.astemir.astemirlib.common.math.Color;

public enum InterpolationType {
    LINEAR((a, b, t) -> (1.0 - t) * a + t * b),
    QUADRATIC((a, b, t) -> a + (b - a) * t * t),
    CUBIC((a, b, t) -> a + (b - a) * t * t * (3.0 - 2.0 * t)),
    CATMULLROM((a, b, t) -> 0.5 * (2.0 * a + (b - a) * t + (2.0 * a - 5.0 * a + 4.0 * b - b) * t * t + (3.0 * a - a - 3.0 * b + b) * t * t * t)),
    STEP((a, b, t) -> a + (b - a) * (t < 0.5 ? 0.0 : 1.0)),
    BEZIER((a, b, t) -> {
        double t2 = t * t;
        double t3 = t2 * t;
        double mt = 1.0 - t;
        double mt2 = mt * mt;
        double mt3 = mt2 * mt;
        return a * mt3 + 3.0 * a * mt2 * t + 3.0 * b * mt * t2 + b * t3;
    });

    private InterpolationFunc function;

    private InterpolationType(InterpolationFunc function) {
        this.function = function;
    }

    public double interpolate(double a, double b, double t) {
        return this.function.interpolate(a, b, t);
    }

    public AVector2f interpolate(AVector2f startVector, AVector2f endVector, double t) {
        float x = (float)this.interpolate(startVector.x, endVector.x, t);
        float y = (float)this.interpolate(startVector.y, endVector.y, t);
        return new AVector2f(x, y);
    }

    public Color interpolate(Color startVector, Color endVector, double t) {
        float r = (float)this.interpolate(startVector.r, endVector.r, t);
        float g = (float)this.interpolate(startVector.g, endVector.g, t);
        float b = (float)this.interpolate(startVector.b, endVector.b, t);
        float a = (float)this.interpolate(startVector.a, endVector.a, t);
        return new Color(r, g, b, a);
    }

    public AVector3f interpolate(AVector3f startVector, AVector3f endVector, double t) {
        float x = (float)this.interpolate(startVector.x, endVector.x, t);
        float y = (float)this.interpolate(startVector.y, endVector.y, t);
        float z = (float)this.interpolate(startVector.z, endVector.z, t);
        return new AVector3f(x, y, z);
    }

    public AVector2f interpolateRot(AVector2f startVector, AVector2f endVector, double t) {
        float x = (float)this.interpolateRot(startVector.x, endVector.x, t);
        float y = (float)this.interpolateRot(startVector.y, endVector.y, t);
        return new AVector2f(x, y);
    }

    public AVector3f interpolateRot(AVector3f startVector, AVector3f endVector, double t) {
        float x = (float)this.interpolateRot(startVector.x, endVector.x, t);
        float y = (float)this.interpolateRot(startVector.y, endVector.y, t);
        float z = (float)this.interpolateRot(startVector.z, endVector.z, t);
        return new AVector3f(x, y, z);
    }

    public double interpolateRot(double a, double b, double t) {
        double f2 = b % 360.0;
        double f1 = a % 360.0;
        if (Math.abs(f2 - f1) > 180.0) {
            if (f2 > f1) {
                f1 += 360.0;
            } else {
                f2 += 360.0;
            }
        }
        return (float)this.function.interpolate(f1, f2, t);
    }

    public <T> T interpolateUniversal(T a, T b, double t) {
        if (a instanceof Number) {
            Number a1 = (Number)a;
            if (b instanceof Number) {
                Number b1 = (Number)b;
                return (T)Double.valueOf(this.interpolate(a1.doubleValue(), b1.doubleValue(), t));
            }
        }
        if (a instanceof AVector2f) {
            AVector2f a1 = (AVector2f)a;
            if (b instanceof AVector2f) {
                AVector2f b1 = (AVector2f)b;
                return (T)this.interpolate(a1, b1, t);
            }
        }
        if (a instanceof AVector3f) {
            AVector3f a1 = (AVector3f)a;
            if (b instanceof AVector3f) {
                AVector3f b1 = (AVector3f)b;
                return (T)this.interpolate(a1, b1, t);
            }
        }
        if (a instanceof Color) {
            Color a1 = (Color)a;
            if (b instanceof Color) {
                Color b1 = (Color)b;
                return (T)this.interpolate(a1, b1, t);
            }
        }
        return a;
    }

    public <T> T interpolateRotUniversal(T a, T b, double t) {
        if (a instanceof Number) {
            Number a1 = (Number)a;
            if (b instanceof Number) {
                Number b1 = (Number)b;
                return (T)Double.valueOf(this.interpolateRot(a1.doubleValue(), b1.doubleValue(), t));
            }
        }
        if (a instanceof AVector2f) {
            AVector2f a1 = (AVector2f)a;
            if (b instanceof AVector2f) {
                AVector2f b1 = (AVector2f)b;
                return (T)this.interpolateRot(a1, b1, t);
            }
        }
        if (a instanceof AVector3f) {
            AVector3f a1 = (AVector3f)a;
            if (b instanceof AVector3f) {
                AVector3f b1 = (AVector3f)b;
                return (T)this.interpolateRot(a1, b1, t);
            }
        }
        return a;
    }

    static interface InterpolationFunc {
        public double interpolate(double var1, double var3, double var5);
    }
}

