/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.common.math;

import ru.astemir.astemirlib.common.math.AVector2f;

public class Rect2f {
    private AVector2f position;
    private AVector2f size;

    public Rect2f(AVector2f position, AVector2f size) {
        this.position = position;
        this.size = size;
    }

    public Rect2f(float x, float y, float width, float height) {
        this(new AVector2f(x, y), new AVector2f(width, height));
    }

    public boolean intersects(Rect2f other) {
        return this.getX() < other.getX() + other.getWidth() && this.getX() + this.getWidth() > other.getX() && this.getY() < other.getY() + other.getHeight() && this.getY() + this.getHeight() > other.getY();
    }

    public Rect2f intersection(Rect2f other) {
        float x = Math.max(this.getX(), other.getX());
        float y = Math.max(this.getY(), other.getY());
        float width = Math.min(this.getX() + this.getWidth(), other.getX() + other.getWidth()) - x;
        float height = Math.min(this.getY() + this.getHeight(), other.getY() + other.getHeight()) - y;
        return new Rect2f(x, y, width, height);
    }

    public boolean contains(Rect2f other) {
        return this.getX() <= other.getX() && this.getY() <= other.getY() && this.getX() + this.getWidth() >= other.getX() + other.getWidth() && this.getY() + this.getHeight() >= other.getY() + other.getHeight();
    }

    public boolean contains(float x, float y, float width, float height) {
        return this.contains(new Rect2f(x, y, width, height));
    }

    public boolean contains(AVector2f point) {
        return point.x >= this.getX() && point.x <= this.getX() + this.getWidth() && point.y >= this.getY() && point.y <= this.getY() + this.getHeight();
    }

    public boolean contains(float x, float y) {
        return this.contains(new AVector2f(x, y));
    }

    public float getX() {
        return this.position.x;
    }

    public float getY() {
        return this.position.y;
    }

    public void setX(float x) {
        this.position.setX(x);
    }

    public void setY(float y) {
        this.position.setY(y);
    }

    public float getWidth() {
        return this.size.x;
    }

    public float getHeight() {
        return this.size.y;
    }

    public void setSize(float width, float height) {
        this.size = new AVector2f(width, height);
    }

    public void setWidth(float width) {
        this.size.setX(width);
    }

    public void setHeight(float height) {
        this.size.setY(height);
    }

    public void setPosition(float x, float y) {
        this.position = new AVector2f(x, y);
    }

    public void setPosition(AVector2f position) {
        this.position = position;
    }

    public void setSize(AVector2f size) {
        this.size = size;
    }

    public AVector2f getPosition() {
        return this.position;
    }

    public AVector2f getSize() {
        return this.size;
    }

    public void move(float dx, float dy) {
        this.setPosition(this.getX() + dx, this.getY() + dy);
    }

    public void scale(float scaleX, float scaleY) {
        this.setSize(this.getWidth() * scaleX, this.getHeight() * scaleY);
    }

    public AVector2f getTopLeft() {
        return this.getPosition();
    }

    public AVector2f getTopRight() {
        return new AVector2f(this.getX() + this.getWidth(), this.getY());
    }

    public AVector2f getBottomLeft() {
        return new AVector2f(this.getX(), this.getY() + this.getHeight());
    }

    public AVector2f getBottomRight() {
        return new AVector2f(this.getX() + this.getWidth(), this.getY() + this.getHeight());
    }

    public static Rect2f sized(AVector2f size) {
        return new Rect2f(new AVector2f(0.0f, 0.0f), size);
    }

    public static Rect2f rect(AVector2f position, AVector2f size) {
        return new Rect2f(position, size);
    }

    public static Rect2f sized(float x, float y) {
        return Rect2f.sized(new AVector2f(x, y));
    }

    public static Rect2f rect(float x, float y, float width, float height) {
        return Rect2f.rect(new AVector2f(x, y), new AVector2f(width, height));
    }
}

