/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.common.misc;

import ru.astemir.astemirlib.common.math.EasingType;
import ru.astemir.astemirlib.common.math.InterpolationType;

public class KeyFrame<T> {
    private T value;
    private T preValue;
    private float time;
    private InterpolationType interpolationType;
    private EasingType easingType;

    public KeyFrame(float time, T value, InterpolationType interpolationType, EasingType easingType) {
        this.time = time;
        this.value = value;
        this.interpolationType = interpolationType;
        this.easingType = easingType;
    }

    public T getValue() {
        return this.value;
    }

    public T getPreValue() {
        return this.preValue;
    }

    public boolean hasPreValue() {
        return this.preValue != null;
    }

    public KeyFrame setPreValue(T preValue) {
        this.preValue = preValue;
        return this;
    }

    public void setTime(float time) {
        this.time = time;
    }

    public float getTime() {
        return this.time;
    }

    public InterpolationType getInterpolationType() {
        return this.interpolationType;
    }

    public EasingType getEasingType() {
        return this.easingType;
    }

    public static <T> KeyFrame<T> of(float time, T value, InterpolationType interpolationType, EasingType easingType) {
        return new KeyFrame<T>(time, value, interpolationType, easingType);
    }

    public static <T> KeyFrame<T> of(float time, T value, InterpolationType interpolationType) {
        return new KeyFrame<T>(time, value, interpolationType, EasingType.NONE);
    }

    public static <T> KeyFrame<T> of(float time, T value) {
        return new KeyFrame<T>(time, value, InterpolationType.CATMULLROM, EasingType.NONE);
    }
}

