/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.common.network.messages;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import ru.astemir.astemirlib.common.handler.LevelEventHandler;
import ru.astemir.astemirlib.common.network.PacketArgument;

public class ClientMessageWorldPosEvent {
    private BlockPos pos;
    private int eventId;
    private PacketArgument[] arguments;

    public ClientMessageWorldPosEvent(BlockPos pos, int eventId, PacketArgument ... arguments) {
        this.pos = pos;
        this.eventId = eventId;
        this.arguments = arguments;
    }

    public static void encode(ClientMessageWorldPosEvent message, FriendlyByteBuf buf) {
        buf.m_130064_(message.pos);
        buf.writeInt(message.eventId);
        buf.writeInt(message.arguments.length);
        for (PacketArgument argument : message.arguments) {
            argument.write(buf);
        }
    }

    public static ClientMessageWorldPosEvent decode(FriendlyByteBuf buf) {
        BlockPos pos = buf.m_130135_();
        int eventId = buf.readInt();
        int length = buf.readInt();
        PacketArgument[] arguments = new PacketArgument[length];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = PacketArgument.read(buf);
        }
        ClientMessageWorldPosEvent message = new ClientMessageWorldPosEvent(pos, eventId, arguments);
        return message;
    }

    public static class Handler
    implements BiConsumer<ClientMessageWorldPosEvent, Supplier<NetworkEvent.Context>> {
        @Override
        @OnlyIn(value=Dist.CLIENT)
        public void accept(ClientMessageWorldPosEvent message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            context.enqueueWork(() -> LevelEventHandler.getInstance().onClientHandleEvent(message.pos, message.eventId, message.arguments));
            context.setPacketHandled(true);
        }
    }
}

