/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.common.network.messages;

import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.network.NetworkEvent;
import ru.astemir.astemirlib.common.handler.EventEntity;
import ru.astemir.astemirlib.common.network.PacketArgument;

public class ServerMessageEntityEvent {
    private int entityId;
    private int eventId;
    private PacketArgument[] arguments;

    public ServerMessageEntityEvent(int entityId, int eventId, PacketArgument ... arguments) {
        this.entityId = entityId;
        this.eventId = eventId;
        this.arguments = arguments;
    }

    public static void encode(ServerMessageEntityEvent message, FriendlyByteBuf buf) {
        buf.writeInt(message.entityId);
        buf.writeInt(message.eventId);
        buf.writeInt(message.arguments.length);
        for (PacketArgument argument : message.arguments) {
            argument.write(buf);
        }
    }

    public static ServerMessageEntityEvent decode(FriendlyByteBuf buf) {
        int entityId = buf.readInt();
        int eventId = buf.readInt();
        int length = buf.readInt();
        PacketArgument[] arguments = new PacketArgument[length];
        for (int i = 0; i < arguments.length; ++i) {
            arguments[i] = PacketArgument.read(buf);
        }
        ServerMessageEntityEvent message = new ServerMessageEntityEvent(entityId, eventId, arguments);
        return message;
    }

    public static class Handler
    implements BiConsumer<ServerMessageEntityEvent, Supplier<NetworkEvent.Context>> {
        @Override
        public void accept(ServerMessageEntityEvent message, Supplier<NetworkEvent.Context> contextSupplier) {
            NetworkEvent.Context context = contextSupplier.get();
            LogicalSide side = context.getDirection().getReceptionSide();
            context.setPacketHandled(true);
            if (!side.isServer()) {
                return;
            }
            ServerPlayer playerEntity = context.getSender();
            if (playerEntity == null) {
                return;
            }
            context.enqueueWork(() -> Handler.processMessage(message, playerEntity));
        }

        private static void processMessage(ServerMessageEntityEvent message, ServerPlayer playerEntity) {
            EventEntity eventEntity;
            ServerLevel serverLevel;
            Entity entity;
            Level level;
            if (playerEntity != null && (level = playerEntity.m_9236_()) instanceof ServerLevel && (entity = (serverLevel = (ServerLevel)level).m_6815_(message.entityId)) != null && entity instanceof EventEntity && (eventEntity = (EventEntity)entity).getServerLevelEventMap() != null) {
                eventEntity.getServerLevelEventMap().handleEvent(entity, message.eventId, (Level)serverLevel, entity.m_20183_(), message.arguments);
            }
        }
    }
}

