/*
 * Decompiled with CFR 0.152.
 */
package ru.astemir.astemirlib.mixin;

import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.MoverType;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.CapabilityProvider;
import net.minecraftforge.eventbus.api.Event;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ru.astemir.astemirlib.common.event.EntityEyeHeightEvent;
import ru.astemir.astemirlib.common.event.EntityMoveEvent;
import ru.astemir.astemirlib.common.event.EntityTagEvent;
import ru.astemir.astemirlib.common.event.EntityTickEvent;

@Mixin(value={Entity.class}, priority=700)
public abstract class MixinEntity
extends CapabilityProvider<Entity> {
    @Shadow
    public abstract void m_146884_(Vec3 var1);

    protected MixinEntity(Class<Entity> baseClass, boolean isLazy) {
        super(baseClass, isLazy);
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void onTick(CallbackInfo ci) {
        Entity entity = (Entity)this;
        EntityTickEvent event = new EntityTickEvent(entity, entity.f_19797_);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    @Inject(method={"load"}, at={@At(value="TAIL")})
    public void onLoadData(CompoundTag tag, CallbackInfo ci) {
        Entity entity = (Entity)this;
        EntityTagEvent.Load event = new EntityTagEvent.Load(entity, tag);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    @Inject(method={"save"}, at={@At(value="TAIL")})
    public void onSaveData(CompoundTag tag, CallbackInfoReturnable<Boolean> cir) {
        Entity entity = (Entity)this;
        EntityTagEvent.Save event = new EntityTagEvent.Save(entity, tag);
        MinecraftForge.EVENT_BUS.post((Event)event);
    }

    @Inject(method={"move"}, at={@At(value="HEAD")})
    public void onMove(MoverType moverType, Vec3 vec3, CallbackInfo ci) {
        Entity entity = (Entity)this;
        EntityMoveEvent entityMoveEvent = new EntityMoveEvent(entity, vec3);
        if (MinecraftForge.EVENT_BUS.post((Event)entityMoveEvent)) {
            ci.cancel();
        }
    }

    @Inject(method={"getEyeHeight()F"}, at={@At(value="RETURN")}, cancellable=true)
    public void onGetEyeHeight(CallbackInfoReturnable<Float> cir) {
        float eyeHeight = ((Float)cir.getReturnValue()).floatValue();
        EntityEyeHeightEvent event = new EntityEyeHeightEvent((Entity)this, eyeHeight);
        if (MinecraftForge.EVENT_BUS.post((Event)event)) {
            cir.setReturnValue((Object)Float.valueOf(event.getEyeHeight()));
        } else {
            cir.setReturnValue((Object)Float.valueOf(eyeHeight));
        }
    }
}

