/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.gui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.conczin.mca.Config;
import net.conczin.mca.MCA;
import net.conczin.mca.MCAClient;
import net.conczin.mca.client.gui.VillagerEditorScreen;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.c2s.DestinyMessage;
import net.conczin.mca.util.compat.ButtonWidget;
import net.conczin.mca.util.localization.FlowingText;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_364;
import net.minecraft.class_4587;
import net.minecraft.class_5250;

public class DestinyScreen
extends VillagerEditorScreen {
    private static final class_2960 LOGO_TEXTURE = MCA.locate("textures/banner.png");
    private final LinkedList<class_2561> story = new LinkedList();
    private final boolean allowTeleportation;
    private String location;
    private boolean teleported = false;
    private ButtonWidget acceptWidget;

    public DestinyScreen(UUID playerUUID, boolean allowTeleportation) {
        super(playerUUID, playerUUID);
        this.allowTeleportation = allowTeleportation;
    }

    @Override
    public boolean method_25421() {
        return true;
    }

    public void method_25419() {
        if (!this.page.equals("general") && !this.page.equals("story")) {
            this.setPage("destiny");
        }
    }

    @Override
    protected String[] getPages() {
        LinkedList<String> pages = new LinkedList<String>();
        pages.add("general");
        if (Config.getInstance().allowBodyCustomizationInDestiny) {
            pages.add("body");
            pages.add("head");
        }
        if (Config.getInstance().allowTraitCustomizationInDestiny) {
            pages.add("traits");
        }
        return pages.toArray(new String[0]);
    }

    private void drawScaledText(class_332 context, class_2561 text, int x, int y, float scale) {
        class_4587 matrices = context.method_51448();
        matrices.method_22903();
        matrices.method_22905(scale, scale, scale);
        context.method_27534(this.field_22793, text, (int)((float)x / scale), (int)((float)y / scale), -1);
        matrices.method_22909();
    }

    public void method_25420(class_332 context, int mouseX, int mouseY, float partialTick) {
        this.method_57728(context, partialTick);
        this.method_57734(partialTick);
        this.method_57735(context);
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float delta) {
        super.method_25394(context, mouseX, mouseY, delta);
        class_4587 matrices = context.method_51448();
        switch (this.page) {
            case "general": {
                this.drawScaledText(context, (class_2561)class_2561.method_43471((String)"gui.destiny.whoareyou"), this.field_22789 / 2, this.field_22790 / 2 - 24, 1.5f);
                matrices.method_22903();
                matrices.method_22905(0.25f, 0.25f, 0.25f);
                RenderSystem.enableBlend();
                RenderSystem.defaultBlendFunc();
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                context.method_25290(LOGO_TEXTURE, this.field_22789 * 2 - 512, -40, 0.0f, 0.0f, 1024, 512, 1024, 512);
                matrices.method_22909();
                break;
            }
            case "destiny": {
                this.drawScaledText(context, (class_2561)class_2561.method_43471((String)"gui.destiny.journey"), this.field_22789 / 2, this.field_22790 / 2 - 48, 1.5f);
                break;
            }
            case "story": {
                List<class_2561> text = FlowingText.wrap(this.story.getFirst(), 256);
                int y = (int)((double)this.field_22790 / 2.0 - 20.0 - (double)(7.5f * (float)text.size()));
                for (class_2561 t : text) {
                    this.drawScaledText(context, t, this.field_22789 / 2, y, 1.25f);
                    y += 15;
                }
                break;
            }
        }
    }

    @Override
    protected boolean shouldDrawEntity() {
        return !this.page.equals("general") && !this.page.equals("destiny") && !this.page.equals("story") && super.shouldDrawEntity();
    }

    protected String getPath(String location) {
        String[] split = location.split(":");
        return split[split.length - 1];
    }

    @Override
    protected void setPage(String page) {
        if (page.equals("destiny") && !this.allowTeleportation) {
            Network.sendToServer(new DestinyMessage("", true));
            MCAClient.getDestinyManager().allowClosing();
            super.method_25419();
            return;
        }
        if (page.equals("destiny") && Config.getServerConfig().destinySpawnLocations.size() == 1) {
            this.selectStory(Config.getServerConfig().destinySpawnLocations.getFirst());
            return;
        }
        this.page = page;
        this.method_37067();
        switch (page) {
            case "general": {
                this.drawName(this.field_22789 / 2 - 87, this.field_22790 / 2, name -> {
                    this.updateName((String)name);
                    if (this.acceptWidget != null) {
                        this.acceptWidget.field_22763 = !MCA.isBlankString(name);
                    }
                });
                this.drawGender(this.field_22789 / 2 - 87, this.field_22790 / 2 + 24);
                this.addModelSelectionWidgets(this.field_22789 / 2 - 87, this.field_22790 / 2 + 24 + 22);
                this.acceptWidget = (ButtonWidget)this.method_37063((class_364)new ButtonWidget(this.field_22789 / 2 - 32, this.field_22790 / 2 + 60 + 22, 64, 20, (class_2561)class_2561.method_43471((String)"gui.button.accept"), sender -> {
                    if (Config.getInstance().allowBodyCustomizationInDestiny) {
                        this.setPage("body");
                    } else if (Config.getInstance().allowTraitCustomizationInDestiny) {
                        this.setPage("traits");
                    } else {
                        this.setPage("destiny");
                    }
                }));
                break;
            }
            case "destiny": {
                int x = 0;
                int y = 0;
                for (String location : Config.getServerConfig().destinySpawnLocations) {
                    int rows = (int)Math.ceil((float)Config.getServerConfig().destinySpawnLocations.size() / 3.0f);
                    float offsetX = y + 1 == rows ? (float)(2 - (Config.getServerConfig().destinySpawnLocations.size() - 1) % 3) / 2.0f : 0.0f;
                    float offsetY = (float)Math.max(0, 3 - rows) / 2.0f;
                    class_5250 name2 = class_2561.method_43471((String)("gui.destiny." + this.getPath(location)));
                    this.method_37063((class_364)new ButtonWidget((int)((float)this.field_22789 / 2.0f - 144.0f + ((float)x + offsetX) * 96.0f), (int)((float)this.field_22790 / 2.0f + ((float)y + offsetY) * 20.0f - 16.0f), 96, 20, (class_2561)name2, sender -> this.selectStory(location)));
                    if (++x < 3) continue;
                    x = 0;
                    ++y;
                }
                break;
            }
            case "story": {
                this.method_37063((class_364)new ButtonWidget(this.field_22789 / 2 - 48, this.field_22790 / 2 + 32, 96, 20, (class_2561)class_2561.method_43471((String)"gui.destiny.next"), sender -> {
                    if (!this.teleported) {
                        Network.sendToServer(new DestinyMessage(this.location, false));
                        MCAClient.getDestinyManager().allowClosing();
                        this.teleported = true;
                    }
                    if (this.story.size() > 1) {
                        this.story.removeFirst();
                    } else {
                        Network.sendToServer(new DestinyMessage("", true));
                        super.method_25419();
                    }
                }));
                break;
            }
            default: {
                super.setPage(page);
            }
        }
    }

    private void selectStory(String location) {
        this.story.clear();
        this.story.add((class_2561)class_2561.method_43471((String)"destiny.story.reason"));
        Map<String, String> map = Config.getInstance().destinyLocationsToTranslationMap;
        this.story.add((class_2561)class_2561.method_43471((String)map.getOrDefault(location, map.getOrDefault("default", "missing_default"))));
        this.story.add((class_2561)class_2561.method_43471((String)("destiny.story." + this.getPath(location))));
        this.location = location;
        this.setPage("story");
    }
}

