/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.client.render.layer;

import net.conczin.mca.client.gui.immersive_library.SkinCache;
import net.conczin.mca.client.model.CommonVillagerModel;
import net.conczin.mca.client.render.layer.VillagerLayer;
import net.conczin.mca.client.resources.ColorPalette;
import net.conczin.mca.entity.ai.Genetics;
import net.conczin.mca.entity.ai.Traits;
import net.minecraft.class_1309;
import net.minecraft.class_1472;
import net.minecraft.class_1767;
import net.minecraft.class_2960;
import net.minecraft.class_3883;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5253;
import net.minecraft.class_572;

public class HairLayer<T extends class_1309, M extends class_572<T>>
extends VillagerLayer<T, M> {
    public HairLayer(class_3883<T, M> renderer, M model) {
        super(renderer, model);
    }

    @Override
    public void render(class_4587 transform, class_4597 provider, int light, T villager, float limbAngle, float limbDistance, float tickDelta, float animationProgress, float headYaw, float headPitch) {
        this.model.method_2805(true);
        this.model.field_3397.field_3665 = false;
        this.model.field_3392.field_3665 = false;
        super.render(transform, provider, light, villager, limbAngle, limbDistance, tickDelta, animationProgress, headYaw, headPitch);
    }

    @Override
    public class_2960 getSkin(T villager) {
        String identifier = CommonVillagerModel.getVillager(villager).getHair();
        if (identifier.startsWith("immersive_library:")) {
            return SkinCache.getTextureIdentifier(Integer.parseInt(identifier.substring(18)));
        }
        return this.cached(identifier, class_2960::method_60654);
    }

    @Override
    protected class_2960 getOverlay(T villager) {
        return this.cached(CommonVillagerModel.getVillager(villager).getHair().replace(".png", "_overlay.png"), class_2960::method_60654);
    }

    private int getRainbow(class_1309 entity, float tickDelta) {
        int n = Math.abs(entity.field_6012) / 25 + entity.method_5628();
        int o = class_1767.values().length;
        int p = n % o;
        int q = (n + 1) % o;
        float r = ((float)(Math.abs(entity.field_6012) % 25) + tickDelta) / 25.0f;
        return class_5253.class_5254.method_48780((float)r, (int)class_1472.method_6634((class_1767)class_1767.method_7791((int)p)), (int)class_1472.method_6634((class_1767)class_1767.method_7791((int)q)));
    }

    @Override
    public int getColor(T villager, float tickDelta) {
        if (CommonVillagerModel.getVillager(villager).getTraits().hasTrait(Traits.RAINBOW)) {
            return this.getRainbow((class_1309)villager, tickDelta);
        }
        int hairDye = CommonVillagerModel.getVillager(villager).getHairDye();
        if (hairDye != -16777216) {
            return hairDye;
        }
        float albinism = CommonVillagerModel.getVillager(villager).getTraits().hasTrait(Traits.ALBINISM) ? 0.1f : 1.0f;
        return ColorPalette.HAIR.getColor(CommonVillagerModel.getVillager(villager).getGenetics().getGene(Genetics.EUMELANIN) * albinism, CommonVillagerModel.getVillager(villager).getGenetics().getGene(Genetics.PHEOMELANIN) * albinism, 0.0f);
    }
}

