/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity;

import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.conczin.mca.Config;
import net.conczin.mca.MCA;
import net.conczin.mca.MCAClient;
import net.conczin.mca.client.model.CommonVillagerModel;
import net.conczin.mca.entity.UpdatableInventory;
import net.conczin.mca.entity.VillagerLike;
import net.conczin.mca.entity.ZombieVillagerEntityMCA;
import net.conczin.mca.entity.ai.BreedableRelationship;
import net.conczin.mca.entity.ai.Chore;
import net.conczin.mca.entity.ai.ConversationManager;
import net.conczin.mca.entity.ai.Genetics;
import net.conczin.mca.entity.ai.LongTermMemory;
import net.conczin.mca.entity.ai.MemoryModuleTypeMCA;
import net.conczin.mca.entity.ai.Mood;
import net.conczin.mca.entity.ai.MoveState;
import net.conczin.mca.entity.ai.Residency;
import net.conczin.mca.entity.ai.StatusEffectDangerSet;
import net.conczin.mca.entity.ai.Traits;
import net.conczin.mca.entity.ai.brain.VillagerBrain;
import net.conczin.mca.entity.ai.brain.VillagerTasksMCA;
import net.conczin.mca.entity.ai.relationship.AgeState;
import net.conczin.mca.entity.ai.relationship.CompassionateEntity;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.conczin.mca.entity.ai.relationship.Personality;
import net.conczin.mca.entity.ai.relationship.VillagerDimensions;
import net.conczin.mca.entity.interaction.VillagerCommandHandler;
import net.conczin.mca.mixin.MixinVillagerInvoker;
import net.conczin.mca.registry.CriterionMCA;
import net.conczin.mca.registry.EntitiesMCA;
import net.conczin.mca.registry.ItemsMCA;
import net.conczin.mca.registry.ParticleTypesMCA;
import net.conczin.mca.registry.ProfessionsMCA;
import net.conczin.mca.registry.SoundsMCA;
import net.conczin.mca.registry.TagsMCA;
import net.conczin.mca.resources.Names;
import net.conczin.mca.resources.Rank;
import net.conczin.mca.resources.Tasks;
import net.conczin.mca.server.world.data.FamilyTree;
import net.conczin.mca.server.world.data.FamilyTreeNode;
import net.conczin.mca.server.world.data.Village;
import net.conczin.mca.server.world.data.VillagerTrackerManager;
import net.conczin.mca.util.InventoryUtils;
import net.conczin.mca.util.network.datasync.CDataManager;
import net.conczin.mca.util.network.datasync.CDataParameter;
import net.conczin.mca.util.network.datasync.CParameter;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1277;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1335;
import net.minecraft.class_1408;
import net.minecraft.class_1439;
import net.minecraft.class_1496;
import net.minecraft.class_1538;
import net.minecraft.class_1641;
import net.minecraft.class_1642;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1703;
import net.minecraft.class_1707;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1914;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2940;
import net.minecraft.class_2945;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_3745;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_3908;
import net.minecraft.class_4048;
import net.minecraft.class_4050;
import net.minecraft.class_4095;
import net.minecraft.class_4099;
import net.minecraft.class_4140;
import net.minecraft.class_4142;
import net.minecraft.class_4174;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_8103;
import net.minecraft.class_9334;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class VillagerEntityMCA
extends class_1646
implements VillagerLike<VillagerEntityMCA>,
class_3908,
CompassionateEntity<BreedableRelationship>,
class_3745 {
    private static final CDataParameter<Float> INFECTION_PROGRESS = CParameter.create("InfectionProgress", 0.0f);
    private static final CDataParameter<Integer> GROWTH_AMOUNT = CParameter.create("GrowthAmount", -AgeState.getMaxAge());
    private static final CDataManager<VillagerEntityMCA> DATA = VillagerEntityMCA.createTrackedData(VillagerEntityMCA.class).build();
    private static final int RECALCULATE_DIMENSIONS_EVERY_N_TICKS = 100;
    public final ConversationManager conversationManager = new ConversationManager(this);
    final class_2960 EXTRA_HEALTH_EFFECT_ID = MCA.locate("trait_health");
    private final VillagerBrain<VillagerEntityMCA> mcaBrain = new VillagerBrain<VillagerEntityMCA>(this);
    private final LongTermMemory longTermMemory = new LongTermMemory(this);
    private final Genetics genetics = new Genetics(this);
    private final Traits traits = new Traits(this);
    private final Residency residency = new Residency(this);
    private final BreedableRelationship relations = new BreedableRelationship(this);
    private final VillagerCommandHandler interactions = new VillagerCommandHandler(this);
    private final UpdatableInventory inventory = new UpdatableInventory(27);
    private final VillagerDimensions.Mutable dimensions = new VillagerDimensions.Mutable(AgeState.UNASSIGNED);
    long lastCooldown = 0L;
    private VillagerLike.PlayerModel playerModel;
    private int despawnDelay;
    private int burned;
    private long lastHit = 0L;
    private int prevGrowthAmount;
    private boolean interactedWith;

    public VillagerEntityMCA(class_1299<VillagerEntityMCA> type, class_1937 w, Gender gender) {
        super(type, w);
        this.inventory.method_5489(this::onInvChange);
        this.genetics.setGender(gender);
    }

    public static <E extends class_1297> CDataManager.Builder<E> createTrackedData(Class<E> type) {
        return VillagerLike.createTrackedData(type).addAll(INFECTION_PROGRESS, GROWTH_AMOUNT).add(Residency::createTrackedData).add(BreedableRelationship::createTrackedData);
    }

    private static boolean canEat(class_1799 i) {
        class_4174 foodProperties = (class_4174)i.method_57824(class_9334.field_50075);
        return foodProperties != null && foodProperties.comp_2491() > 0 && foodProperties.comp_2495().stream().noneMatch(e -> StatusEffectDangerSet.IS_DANGER.contains(e.comp_2496().method_5579()));
    }

    public static class_5132.class_5133 createAttributes() {
        return class_1646.method_26955().method_26868(class_5134.field_23721, 3.0).method_26868(class_5134.field_23722, 1.0).method_26868(class_5134.field_23716, (double)Config.getInstance().villagerMaxHealth);
    }

    @Override
    public CDataManager<VillagerEntityMCA> getTypeDataManager() {
        return DATA;
    }

    @Override
    public VillagerLike.PlayerModel getPlayerModel() {
        return this.playerModel;
    }

    @Override
    public boolean isBurned() {
        return this.burned > 0;
    }

    public void method_19182() {
        Optional<Village> village;
        super.method_19182();
        if (!this.method_37908().field_9236 && (village = this.residency.getHomeVillage()).isPresent() && Config.getInstance().villagerRestockNotification) {
            village.get().broadCastMessage((class_3218)this.method_37908(), "events.restock", this.method_5477().getString());
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        this.getTypeDataManager().register(builder);
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return VillagerTasksMCA.initializeTasks(this, (class_4095<VillagerEntityMCA>)VillagerTasksMCA.createProfile().method_28335(dynamic));
    }

    public void method_19179(class_3218 world) {
        class_4095<VillagerEntityMCA> brain = this.getMCABrain();
        brain.method_18900(world, (class_1309)this);
        this.field_18321 = brain.method_18911();
        VillagerTasksMCA.initializeTasks(this, this.getMCABrain());
    }

    public class_4095<VillagerEntityMCA> getMCABrain() {
        return this.field_18321;
    }

    @Override
    public Genetics getGenetics() {
        return this.genetics;
    }

    @Override
    public Traits getTraits() {
        return this.traits;
    }

    @Override
    public BreedableRelationship getRelationships() {
        return this.relations;
    }

    @Override
    public VillagerBrain<?> getVillagerBrain() {
        return this.mcaBrain;
    }

    public LongTermMemory getLongTermMemory() {
        return this.longTermMemory;
    }

    public Residency getResidency() {
        return this.residency;
    }

    public VillagerCommandHandler getInteractions() {
        return this.interactions;
    }

    protected class_2561 method_23315() {
        return this.getProfessionText();
    }

    @Nullable
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 spawnType, class_1315 groupData) {
        class_1315 data = super.method_5943(level, difficulty, spawnType, groupData);
        this.initialize(spawnType);
        this.setAgeState(AgeState.byCurrentAge(this.method_5618()));
        FamilyTreeNode entry = this.getRelationships().getFamilyEntry();
        if (!FamilyTreeNode.isValid(entry.father()) && !FamilyTreeNode.isValid(entry.mother())) {
            FamilyTree tree = FamilyTree.get(level.method_8410());
            FamilyTreeNode father = tree.getOrCreate(UUID.randomUUID(), Names.pickCitizenName(Gender.MALE), Gender.MALE);
            FamilyTreeNode mother = tree.getOrCreate(UUID.randomUUID(), Names.pickCitizenName(Gender.FEMALE), Gender.FEMALE);
            father.setDeceased(true);
            mother.setDeceased(true);
            entry.setFather(father);
            entry.setMother(mother);
        }
        return data;
    }

    public final class_3852 getProfession() {
        return this.method_7231().method_16924();
    }

    public final void setProfession(class_3852 profession) {
        this.method_7195(this.method_7231().method_16921(profession));
        this.method_19179((class_3218)this.method_37908());
    }

    @Override
    public class_2960 getProfessionId() {
        return class_7923.field_41195.method_10221((Object)this.getProfession());
    }

    @Override
    public boolean isProfessionImportant() {
        return ProfessionsMCA.IS_IMPORTANT.contains(this.getProfession());
    }

    @Override
    public boolean requiresHome() {
        return !ProfessionsMCA.NEEDS_NO_HOME.contains(this.getProfession()) && this.getDespawnDelay() <= 0;
    }

    @Override
    public boolean canTradeWithProfession() {
        return !ProfessionsMCA.CAN_NOT_TRADE.contains(this.getProfession()) || this.field_17721 != null && !this.field_17721.isEmpty();
    }

    public void method_7195(class_3850 data) {
        boolean hasChanged = !this.method_37908().field_9236 && this.getProfession() != data.method_16924() && data.method_16924() != ProfessionsMCA.OUTLAW;
        super.method_7195(data);
        if (hasChanged) {
            this.randomizeClothes();
            this.getRelationships().getFamilyEntry().setProfession(data.method_16924());
        }
    }

    public void method_7217(boolean isBaby) {
        this.method_5614(isBaby ? -AgeState.getMaxAge() : 0);
    }

    public void method_5614(int age) {
        super.method_5614(age);
        if (age != -2) {
            this.setTrackedValue(GROWTH_AMOUNT, age);
            this.setAgeState(AgeState.byCurrentAge(age));
            AgeState current = this.getAgeState();
            AgeState next = current.getNext();
            if (current != next) {
                this.dimensions.interpolate(current, next, AgeState.getDelta(age));
            } else {
                this.dimensions.set(current);
            }
        }
    }

    public boolean method_6121(class_1297 target) {
        this.attackedEntity(target);
        return super.method_6121(target);
    }

    private void attackedEntity(class_1297 target) {
        if (target instanceof class_1657) {
            class_1657 player = (class_1657)target;
            this.pardonPlayers(player);
        }
    }

    private void pardonPlayers() {
        this.pardonPlayers(1);
    }

    public void pardonPlayers(int amount) {
        int bounty = this.getSmallBounty();
        if (bounty <= amount) {
            this.method_18868().method_18875(MemoryModuleTypeMCA.SMALL_BOUNTY);
            this.method_18868().method_18875(class_4140.field_22355);
            this.method_18868().method_18875(MemoryModuleTypeMCA.HIT_BY_PLAYER);
        } else {
            this.method_18868().method_18878(MemoryModuleTypeMCA.SMALL_BOUNTY, (Object)(bounty - amount));
        }
    }

    private void pardonPlayers(class_1657 attacker) {
        this.pardonPlayers();
        int bounty = this.getSmallBounty();
        if (bounty <= this.getMaxWarnings(attacker)) {
            this.method_18868().method_18875(class_4140.field_22355);
        }
    }

    public boolean canInteractWithItemStackInHand(class_1799 stack) {
        return stack.method_7909() != ItemsMCA.VILLAGER_EDITOR && stack.method_7909() != ItemsMCA.NEEDLE_AND_THREAD && stack.method_7909() != ItemsMCA.COMB && stack.method_7909() != ItemsMCA.POTION_OF_FEMININITY && stack.method_7909() != ItemsMCA.POTION_OF_MASCULINITY;
    }

    public final class_1269 method_5664(class_1657 player, class_243 pos, @NotNull class_1268 hand) {
        if (this.method_5854() != null && this.method_5854().equals((Object)player)) {
            return class_1269.field_5811;
        }
        class_1799 stack = player.method_5998(hand);
        boolean isOnBlacklist = Config.getInstance().villagerInteractionItemBlacklist.contains(class_7923.field_41178.method_10221((Object)stack.method_7909()).toString());
        if (hand.equals((Object)class_1268.field_5808) && !isOnBlacklist && !stack.method_31573(TagsMCA.Items.VILLAGER_EGGS) && this.canInteractWithItemStackInHand(stack) && !this.getVillagerBrain().isPanicking()) {
            this.getDialogueType(player);
            if (player.method_5715()) {
                if (!this.method_37908().field_9236 && this.canTradeWithProfession()) {
                    this.getInteractions().stopInteracting();
                    MixinVillagerInvoker invoker = (MixinVillagerInvoker)((Object)this);
                    invoker.invokeStartTrading(player);
                }
            } else {
                this.playWelcomeSound();
                this.interactedWith = true;
                return this.interactions.interactAt(player, pos, hand);
            }
        }
        return super.method_5664(player, pos, hand);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (this.method_5854() != null && this.method_5854().equals((Object)player)) {
            return class_1269.field_5811;
        }
        class_1799 stack = player.method_5998(hand);
        if (!stack.method_31573(TagsMCA.Items.VILLAGER_EGGS) && this.method_5805() && !this.method_18009() && !this.method_6113() && this.canInteractWithItemStackInHand(stack) && !this.getVillagerBrain().isPanicking()) {
            if (this.method_6109()) {
                this.copiedSayNo();
            } else if (!this.method_37908().field_9236) {
                boolean hasOffers = this.hasTradeOffers();
                if (hand == class_1268.field_5808) {
                    if (!hasOffers && !this.method_37908().field_9236) {
                        this.copiedSayNo();
                    }
                    player.method_7281(class_3468.field_15384);
                }
                if (hasOffers && !this.method_37908().field_9236) {
                    this.copiedBeginTradeWith(player);
                }
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return class_1269.field_5811;
    }

    private void copiedSayNo() {
        this.method_20507(40);
        if (!this.method_37908().method_8608()) {
            this.method_5783(this.getNoSound(), this.method_6107(), this.method_6017());
        }
    }

    public boolean hasTradeOffers() {
        return !this.method_8264().isEmpty();
    }

    public void startTrading(class_1657 customer) {
        this.copiedBeginTradeWith(customer);
    }

    private void copiedBeginTradeWith(class_1657 customer) {
        this.copiedPrepareOffersFor(customer);
        this.method_8259(customer);
        this.method_17449(customer, this.method_5476(), this.method_7231().method_16925());
    }

    private void copiedPrepareOffersFor(class_1657 player) {
        int reputation = this.method_20594(player);
        if (reputation != 0) {
            for (class_1914 tradeOffer : this.method_8264()) {
                tradeOffer.method_8245(-class_3532.method_15375((float)((float)reputation * tradeOffer.method_19278())));
            }
        }
        if (player.method_6059(class_1294.field_18980)) {
            class_1293 statusEffect = player.method_6112(class_1294.field_18980);
            int amplifier = statusEffect.method_5578();
            for (class_1914 tradeOffer2 : this.method_8264()) {
                double d = 0.3 + 0.0625 * (double)amplifier;
                int k = (int)Math.floor(d * (double)tradeOffer2.method_8246().method_7947());
                tradeOffer2.method_8245(-Math.max(k, 1));
            }
        }
    }

    public VillagerEntityMCA getBreedOffspring(class_3218 level, class_1296 partner) {
        VillagerEntityMCA villagerEntityMCA;
        if (partner instanceof VillagerEntityMCA) {
            VillagerEntityMCA partnerVillager = (VillagerEntityMCA)partner;
            villagerEntityMCA = this.relations.getPregnancy().createChild(Gender.getRandom(), partnerVillager);
        } else {
            villagerEntityMCA = this.relations.getPregnancy().createChild(Gender.getRandom());
        }
        VillagerEntityMCA child = villagerEntityMCA;
        child.method_7195(child.method_7231().method_16922(this.getRandomType(partner)));
        child.method_5943((class_5425)level, level.method_8404(child.method_24515()), class_3730.field_16466, null);
        return child;
    }

    private class_3854 getRandomType(class_1296 partner) {
        double d = this.field_5974.method_43058();
        if (d < 0.5) {
            return class_3854.method_16930((class_6880)this.method_37908().method_23753(this.method_24515()));
        }
        if (d < 0.75) {
            return this.method_7231().method_16919();
        }
        return ((class_1646)partner).method_7231().method_16919();
    }

    public final boolean method_5643(class_1282 source, float damageAmount) {
        class_1297 attacker;
        if (this.method_5854() instanceof class_1657) {
            return super.method_5643(source, 0.0f);
        }
        if (!Config.getInstance().canHurtBabies && !source.method_48789(class_8103.field_43116) && this.getAgeState() == AgeState.BABY) {
            if (source.method_5529() instanceof class_1657 && this.requestCooldown()) {
                this.sendEventMessage((class_2561)class_2561.method_43471((String)"villager.baby_hit"));
            }
            return super.method_5643(source, 0.0f);
        }
        if (this.getProfession() == ProfessionsMCA.GUARD) {
            damageAmount *= 0.5f;
        }
        if (this.getTraits().hasTrait(Traits.TOUGH)) {
            damageAmount *= 0.75f;
        }
        if (!this.method_37908().field_9236) {
            class_1297 class_12972 = source.method_5529();
            if (class_12972 instanceof class_1657) {
                class_1657 player = (class_1657)class_12972;
                if (this.method_37908().method_8510() - this.lastHit > 40L) {
                    this.lastHit = this.method_37908().method_8510();
                    if ((!this.isGuard() || this.getSmallBounty() == 0) && this.requestCooldown()) {
                        if (this.method_6032() < this.method_6063() / 2.0f) {
                            this.sendChatMessage(player, "villager.badly_hurt", new Object[0]);
                        } else {
                            this.sendChatMessage(player, "villager.hurt", new Object[0]);
                        }
                    }
                }
                int trustIssues = (int)((1.0 - (double)(this.method_6032() / this.method_6063()) * 0.75) * (3.0 + 2.0 * (double)damageAmount));
                this.getVillagerBrain().getMemoriesForPlayer(player).modHearts(-trustIssues);
            }
            if (source.method_5526() instanceof class_1642 && this.getProfession() != ProfessionsMCA.GUARD && Config.getInstance().enableInfection && this.field_5974.method_43057() < Config.getInstance().zombieBiteInfectionChance && this.field_5974.method_43057() > (float)(this.method_7231().method_16925() - 1) * Config.getInstance().infectionChanceDecreasePerLevel && (this.getResidency().getHomeVillage().filter(v -> v.hasBuilding("infirmary")).isEmpty() || this.field_5974.method_43056())) {
                this.setInfected(true);
                this.sendChatToAllAround("villager.bitten", new Object[0]);
                MCA.LOGGER.info("{} has been infected", (Object)this.method_5477());
            }
        }
        if ((attacker = source.method_5529()) instanceof class_1309) {
            class_1309 livingEntity = (class_1309)attacker;
            if (!this.isHostile() && !this.isFriend(attacker.method_5864())) {
                this.method_18868().method_18879(MemoryModuleTypeMCA.HIT_BY_PLAYER, Optional.of(livingEntity));
                this.method_18868().method_18878(MemoryModuleTypeMCA.SMALL_BOUNTY, (Object)(this.getSmallBounty() + 1));
                class_243 pos = this.method_19538();
                this.method_37908().method_18467(VillagerEntityMCA.class, new class_238(pos, pos).method_1014(32.0)).forEach(v -> {
                    double d = this.method_5858((class_1297)v);
                    int n = v.method_5968() == null ? 1024 : 64;
                    if (d <= (double)n) {
                        if (attacker instanceof class_1657) {
                            class_1657 player = (class_1657)attacker;
                            int bounty = v.getSmallBounty();
                            if (v.isGuard()) {
                                int maxWarning = v.getMaxWarnings(player);
                                if (bounty > maxWarning) {
                                    v.method_18868().method_18878(class_4140.field_22355, (Object)livingEntity);
                                } else if (bounty == 0 || bounty == maxWarning) {
                                    v.sendChatMessage(player, "villager.warning", new Object[0]);
                                }
                                v.method_18868().method_18878(MemoryModuleTypeMCA.SMALL_BOUNTY, (Object)(bounty + 1));
                            }
                        } else if (v.isGuard()) {
                            v.method_18868().method_18878(class_4140.field_22355, (Object)livingEntity);
                        }
                    }
                });
            }
        }
        if (attacker instanceof class_1439) {
            class_1439 golem = (class_1439)attacker;
            golem.method_29922();
            damageAmount *= 0.0f;
        }
        return super.method_5643(source, damageAmount);
    }

    private boolean requestCooldown() {
        if (this.method_37908().method_8510() - this.lastCooldown > 100L) {
            this.lastCooldown = this.method_37908().method_8510();
            return true;
        }
        return false;
    }

    public boolean isGuard() {
        return this.getProfession() == ProfessionsMCA.GUARD || this.getProfession() == ProfessionsMCA.ARCHER;
    }

    public int getSmallBounty() {
        return Objects.requireNonNull(this.method_18868().method_46873(MemoryModuleTypeMCA.SMALL_BOUNTY)).orElse(0);
    }

    public boolean isHitBy(class_3222 player) {
        return Objects.requireNonNull(this.method_18868().method_46873(MemoryModuleTypeMCA.HIT_BY_PLAYER)).filter(v -> v == player).isPresent();
    }

    private int getMaxWarnings(class_1657 attacker) {
        return this.getVillagerBrain().getMemoriesForPlayer(attacker).getHearts() / Math.max(1, Config.getInstance().heartsForPardonHit);
    }

    public void method_6007() {
        this.method_6119();
        super.method_6007();
        --this.burned;
        if (this.method_5809()) {
            this.burned = Config.getInstance().burnedClothingTickLength;
        }
        if (this.burned > 0) {
            this.spawnBurntParticles();
        }
        if (!this.method_37908().field_9236) {
            if (this.field_6012 % 200 == 0 && this.method_6032() < this.method_6063()) {
                class_1799 food = this.method_6047();
                class_4174 foodProperties = (class_4174)food.method_57824(class_9334.field_50075);
                if (foodProperties != null) {
                    this.method_60492(this.method_37908(), food);
                } else if (!this.findAndEquipToMain(VillagerEntityMCA::canEat)) {
                    this.method_6025(1.0f);
                }
            }
            this.tickDespawnDelay();
            this.residency.tick();
            this.relations.tick(this.field_6012);
            this.inventory.update((class_1297)this);
            if (this.field_6012 % Config.getInstance().pardonPlayerTicks == 0) {
                this.pardonPlayers();
            }
            this.mcaBrain.think();
            if (this.field_6012 % Config.getInstance().giftDesaturationReset == 0) {
                this.getRelationships().getGiftSaturation().pop();
            }
            if (this.interactedWith && this.field_6012 % Config.getInstance().trackVillagerPositionEveryNTicks == 0) {
                VillagerTrackerManager.update((class_1297)this);
            }
        }
    }

    protected boolean findAndEquipToMain(Predicate<class_1799> predicate) {
        class_1799 replacement;
        int slot = InventoryUtils.getFirstSlotContainingItem((class_1263)this.method_35199(), predicate);
        if (slot > -1 && !(replacement = this.method_35199().method_5438(slot).method_7971(1)).method_7960()) {
            this.method_6122(this.getDominantHand(), replacement);
            return true;
        }
        return false;
    }

    public void method_5773() {
        super.method_5773();
        int age = (Integer)this.getTrackedValue(GROWTH_AMOUNT);
        if (age / 100 != this.prevGrowthAmount / 100) {
            this.prevGrowthAmount = age;
            this.method_18382();
        }
        if (this.method_37908().field_9236) {
            Mood mood;
            if (this.relations.isProcreating()) {
                this.field_6241 += 50.0f;
            }
            if ((mood = this.mcaBrain.getMood()).getParticle() != null && this.field_6012 % mood.getParticleInterval() == 0 && this.method_37908().field_9229.method_43056()) {
                this.method_18007((class_2394)mood.getParticle());
            }
        } else {
            class_1324 instance;
            float infection = this.getInfectionProgress();
            if (infection > 0.0f && this.field_6012 % 20 == 0) {
                if (infection > 0.2f && this.method_37908().field_9229.method_43048(25) == 0) {
                    this.sendChatToAllAround("villager.sickness", new Object[0]);
                }
                this.setInfectionProgress(infection += 1.0f / (float)Config.getInstance().infectionTime);
                if (infection > 1.0f) {
                    this.method_29243(class_1299.field_6054, false);
                    this.method_31472();
                }
            }
            if (this.field_6012 % 90 == 0 && this.mcaBrain.isPanicking()) {
                this.sendChatToAllAround("villager.scream", new Object[0]);
            }
            if (this.field_6012 % 60 == 0 && this.field_5974.method_43048(50) == 0 && this.traits.hasTrait(Traits.SIRBEN)) {
                this.sendChatToAllAround("sirben", new Object[0]);
            }
            if ((instance = this.method_6127().method_45329(class_5134.field_23716)) != null) {
                int level = this.method_7231().method_16925() - 1;
                instance.method_6200(this.EXTRA_HEALTH_EFFECT_ID);
                instance.method_26835(new class_1322(this.EXTRA_HEALTH_EFFECT_ID, (double)(Config.getInstance().villagerHealthBonusPerLevel * level), class_1322.class_1323.field_6328));
            }
            if (this.field_6012 % 12000 == 0) {
                int base = Math.round((float)this.mcaBrain.getMoodValue() / 12.0f);
                int value = this.field_5974.method_43048(7) - 3;
                this.mcaBrain.modifyMoodValue(value - base);
            }
        }
    }

    public void method_18382() {
        AgeState current = this.getAgeState();
        AgeState next = current.getNext();
        if (next != current) {
            this.dimensions.interpolate(current, next, AgeState.getDelta(((Integer)this.getTrackedValue(GROWTH_AMOUNT)).intValue()));
        } else {
            this.dimensions.set(current);
        }
        boolean oldOnGround = this.method_24828();
        super.method_18382();
        this.method_24830(oldOnGround);
    }

    public class_1799 method_18866(class_1937 level, class_1799 stack, class_4174 foodProperties) {
        this.method_6025(foodProperties.comp_2491());
        return super.method_18866(level, stack, foodProperties);
    }

    public void method_5842() {
        super.method_5842();
        class_1297 vehicle = this.method_5854();
        if (vehicle instanceof class_1314) {
            class_1314 pathAwareEntity = (class_1314)vehicle;
            this.field_6283 = pathAwareEntity.field_6283;
        }
        if (vehicle instanceof class_1657) {
            class_243 offset;
            boolean head;
            class_1657 player = (class_1657)vehicle;
            List passengers = vehicle.method_5685();
            float yaw = -player.field_6283 * ((float)Math.PI / 180);
            boolean left = passengers.get(0) == this;
            boolean bl = head = passengers.size() > 2 && passengers.get(2) == this;
            class_243 class_2432 = head ? new class_243(0.0, (double)0.55f, 0.0) : (offset = new class_243(left ? (double)0.4f : (double)-0.4f, (double)0.05f, 0.0).method_1024(yaw));
            if (this.method_38069() && MCAClient.useGeneticsRenderer(vehicle.method_5667())) {
                float height = CommonVillagerModel.getVillager(vehicle).getRawVerticalScaleFactor();
                offset = offset.method_18805(1.0, (double)height, 1.0);
                offset = offset.method_1031(0.0, (double)(height - 1.0f) * 1.5 - 0.7, 0.0);
            }
            class_243 pos = this.method_19538();
            this.method_23327(pos.method_10216() + offset.method_10216(), pos.method_10214() + offset.method_10214(), pos.method_10215() + offset.method_10215());
            if (vehicle.method_5715()) {
                this.method_5848();
            }
        }
    }

    public class_4048 method_55694(class_4050 pose) {
        class_1297 vehicle = this.method_5854();
        if (vehicle instanceof class_1657) {
            return field_18072;
        }
        if (pose == class_4050.field_18078) {
            return field_18072;
        }
        float height = this.getVerticalScaleFactor() * 2.0f;
        float width = this.getHorizontalScaleFactor() * 0.6f;
        return class_4048.method_18384((float)width, (float)height);
    }

    public void method_6078(class_1282 cause) {
        class_1937 class_19372;
        for (class_1304 slot : class_1304.values()) {
            this.method_5673(slot, class_1799.field_8037);
        }
        if (!this.method_37908().field_9236) {
            this.getResidency().getHomeVillage().flatMap(Village::getCivilRegistry).ifPresent(r -> r.addText(this.method_6066().method_5548()));
        }
        super.method_6078(cause);
        if (this.method_37908().field_9236) {
            return;
        }
        InventoryUtils.dropAllItems((class_1297)this, (class_1263)this.inventory);
        this.relations.onDeath(cause);
        Optional<Village> village = this.residency.getHomeVillage();
        if (village.isPresent() && cause.method_5529() != null && (class_19372 = this.method_37908()) instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            serverLevel.method_18456().forEach(player -> {
                Rank relationToVillage = Tasks.getRank((Village)village.get(), player);
                class_2960 causeId = class_1299.method_5890((class_1299)cause.method_5529().method_5864());
                CriterionMCA.FATE.trigger((class_3222)player, causeId, relationToVillage);
            });
        }
        this.residency.leaveHome();
        if (this.interactedWith) {
            VillagerTrackerManager.update((class_1297)this);
        }
    }

    public class_1335 method_5962() {
        return this.isRidingHorse() ? this.field_6207 : super.method_5962();
    }

    public class_1408 method_5942() {
        return this.isRidingHorse() ? this.field_6189 : super.method_5942();
    }

    protected boolean isRidingHorse() {
        return this.method_5765() && this.method_5854() instanceof class_1496;
    }

    public void method_5859(double destX, double destY, double destZ) {
        class_1297 rootVehicle;
        if (this.method_5765() && (rootVehicle = this.method_5668()) instanceof class_1308) {
            rootVehicle.method_5859(destX, destY, destZ);
            return;
        }
        super.method_5859(destX, destY, destZ);
    }

    public class_3414 method_6002() {
        if (Config.getInstance().useMCAVoices) {
            return this.getGenetics().getGender() == Gender.MALE ? SoundsMCA.VILLAGER_MALE_SCREAM : SoundsMCA.VILLAGER_FEMALE_SCREAM;
        }
        if (Config.getInstance().useVanillaVoices) {
            return super.method_6002();
        }
        return SoundsMCA.SILENT;
    }

    public class_3414 getSurprisedSound() {
        if (Config.getInstance().useMCAVoices) {
            return this.getGenetics().getGender() == Gender.MALE ? SoundsMCA.VILLAGER_MALE_SURPRISE : SoundsMCA.VILLAGER_FEMALE_SURPRISE;
        }
        return SoundsMCA.SILENT;
    }

    @Nullable
    protected final class_3414 method_5994() {
        if (Config.getInstance().useMCAVoices) {
            if (this.getAgeState() == AgeState.BABY) {
                return SoundsMCA.VILLAGER_BABY_LAUGH;
            }
            if (this.method_6113()) {
                return this.getGenetics().getGender() == Gender.MALE ? SoundsMCA.VILLAGER_MALE_SNORE : SoundsMCA.VILLAGER_FEMALE_SNORE;
            }
            if (this.getVillagerBrain().isPanicking()) {
                return this.method_6002();
            }
            if (this.isInfected() && this.field_5974.method_43056()) {
                return this.getGenetics().getGender() == Gender.MALE ? SoundsMCA.VILLAGER_MALE_COUGH : SoundsMCA.VILLAGER_FEMALE_COUGH;
            }
            if (this.field_5974.method_43056() && this.getTraits().hasTrait(Traits.SIRBEN)) {
                return SoundsMCA.SIRBEN;
            }
            Mood mood = this.getVillagerBrain().getMood();
            if (mood.getSoundInterval() > 0 && this.field_6012 % mood.getSoundInterval() == 0) {
                return this.getGenetics().getGender() == Gender.MALE ? mood.getSoundMale() : mood.getSoundFemale();
            }
            return SoundsMCA.SILENT;
        }
        if (Config.getInstance().useVanillaVoices) {
            return super.method_5994();
        }
        return SoundsMCA.SILENT;
    }

    protected final class_3414 method_6011(class_1282 cause) {
        if (Config.getInstance().useMCAVoices) {
            return this.getGenetics().getGender() == Gender.MALE ? SoundsMCA.VILLAGER_MALE_HURT : SoundsMCA.VILLAGER_FEMALE_HURT;
        }
        if (Config.getInstance().useVanillaVoices) {
            return super.method_6011(cause);
        }
        return SoundsMCA.SILENT;
    }

    public final void playWelcomeSound() {
        if (Config.getInstance().useMCAVoices && !this.getVillagerBrain().isPanicking() && this.getAgeState() != AgeState.BABY) {
            this.method_5783(this.getGenetics().getGender() == Gender.MALE ? SoundsMCA.VILLAGER_MALE_GREET : SoundsMCA.VILLAGER_FEMALE_GREET, this.method_6107(), this.method_6017());
        }
    }

    public final void playSurprisedSound() {
        if (Config.getInstance().useMCAVoices) {
            this.method_5783(this.getSurprisedSound(), this.method_6107(), this.method_6017());
        }
    }

    public class_3414 method_18010() {
        if (Config.getInstance().useMCAVoices) {
            return this.getGenetics().getGender() == Gender.MALE ? SoundsMCA.VILLAGER_MALE_YES : SoundsMCA.VILLAGER_FEMALE_YES;
        }
        if (Config.getInstance().useVanillaVoices) {
            return super.method_18010();
        }
        return SoundsMCA.SILENT;
    }

    public class_3414 getNoSound() {
        if (Config.getInstance().useMCAVoices) {
            return this.getGenetics().getGender() == Gender.MALE ? SoundsMCA.VILLAGER_MALE_NO : SoundsMCA.VILLAGER_FEMALE_NO;
        }
        if (Config.getInstance().useVanillaVoices) {
            return class_3417.field_15008;
        }
        return SoundsMCA.SILENT;
    }

    protected class_3414 method_18012(boolean sold) {
        if (Config.getInstance().useMCAVoices) {
            return sold ? this.method_18010() : this.getNoSound();
        }
        if (Config.getInstance().useVanillaVoices) {
            return super.method_18012(sold);
        }
        return SoundsMCA.SILENT;
    }

    public void method_20010() {
        if (Config.getInstance().useMCAVoices) {
            this.method_5783(this.getGenetics().getGender() == Gender.MALE ? SoundsMCA.VILLAGER_MALE_CELEBRATE : SoundsMCA.VILLAGER_FEMALE_CELEBRATE, this.method_6107(), this.method_6017());
        } else if (Config.getInstance().useVanillaVoices) {
            super.method_20010();
        } else {
            this.method_5783(SoundsMCA.SILENT, this.method_6107(), this.method_6017());
        }
    }

    public float method_6017() {
        float r = (this.field_5974.method_43057() - 0.5f) * 0.05f;
        float g = (this.genetics.getGene(Genetics.VOICE) - 0.5f) * 0.3f;
        float a = class_3532.method_16439((float)AgeState.getDelta(this.field_6012), (float)this.getAgeState().getPitch(), (float)this.getAgeState().getNext().getPitch());
        return a + r + g;
    }

    public final class_2561 method_5476() {
        class_2561 name = super.method_5476();
        if (this.getVillagerBrain() != null) {
            Chore chore;
            MoveState state = this.getVillagerBrain().getMoveState();
            if (state != MoveState.MOVE) {
                name = name.method_27662().method_27693(" (").method_10852(state.getName()).method_27693(")");
            }
            if ((chore = this.getVillagerBrain().getCurrentJob()) != Chore.NONE) {
                name = name.method_27662().method_27693(" (").method_10852(chore.getName()).method_27693(")");
            }
        }
        if (this.isInfected()) {
            return name.method_27662().method_27692(class_124.field_1060);
        }
        if (this.getProfession() == ProfessionsMCA.OUTLAW) {
            return name.method_27662().method_27692(class_124.field_1061);
        }
        return name;
    }

    public void method_5665(@Nullable class_2561 name) {
        super.method_5665(name);
        if (name != null) {
            this.setName(name.getString());
        }
    }

    @Override
    public float getInfectionProgress() {
        return ((Float)this.getTrackedValue(INFECTION_PROGRESS)).floatValue();
    }

    @Override
    public void setInfectionProgress(float progress) {
        this.setTrackedValue(INFECTION_PROGRESS, Float.valueOf(progress));
    }

    @Override
    public void playSpeechEffect() {
        if (this.isSpeechImpaired()) {
            this.method_5783(class_3417.field_15174, this.method_6107(), this.method_6017());
        }
    }

    public void method_18007(class_2394 parameters) {
        super.method_18007(parameters);
    }

    @Nullable
    public class_1703 createMenu(int i, class_1661 playerInventory, class_1657 playerEntity) {
        return class_1707.method_19245((int)i, (class_1661)playerInventory, (class_1263)this.inventory);
    }

    @Override
    public VillagerDimensions getVillagerDimensions() {
        return this.dimensions;
    }

    @Override
    public boolean setAgeState(AgeState state) {
        if (VillagerLike.super.setAgeState(state)) {
            if (!this.method_37908().field_9236) {
                this.relations.getParents().filter(class_3222.class::isInstance).map(class_3222.class::cast).forEach(e -> CriterionMCA.CHILD_AGE_STATE_CHANGE.trigger((class_3222)e, state.name()));
                if (state == AgeState.ADULT) {
                    this.relations.getParents().filter(class_1657.class::isInstance).map(class_1657.class::cast).forEach(p -> this.sendEventMessage((class_2561)class_2561.method_43469((String)"notify.child.grownup", (Object[])new Object[]{this.method_5477()}), (class_1657)p));
                }
                this.method_19179((class_3218)this.method_37908());
                this.randomizeClothes();
            }
            return true;
        }
        return false;
    }

    public void method_5674(class_2940<?> par) {
        if (this.getTypeDataManager().isParam(AGE_STATE, par) || this.getTypeDataManager().isParam(Genetics.SIZE.getParam(), par) || this.getTypeDataManager().isParam(Genetics.WIDTH.getParam(), par)) {
            this.method_18382();
        }
        super.method_5674(par);
    }

    public class_1277 method_35199() {
        return this.inventory;
    }

    public void setInventory(UpdatableInventory inventory) {
        class_2487 nbt = new class_2487();
        InventoryUtils.saveToNBT(this.method_56673(), inventory, nbt);
        InventoryUtils.readFromNBT(this.method_56673(), this.inventory, nbt);
    }

    public void moveTowards(class_2338 pos, float speed, int closeEnoughDist) {
        this.field_18321.method_18878(class_4140.field_18445, (Object)new class_4142(pos, speed, closeEnoughDist));
        this.lookAt(pos);
    }

    public void moveTowards(class_2338 pos, float speed) {
        this.moveTowards(pos, speed, 1);
    }

    public void moveTowards(class_2338 pos) {
        this.moveTowards(pos, 0.5f);
    }

    public void lookAt(class_2338 pos) {
        this.field_18321.method_18878(class_4140.field_18446, (Object)new class_4099(pos));
    }

    public void method_5711(byte id) {
        switch (id) {
            case 15: {
                this.method_37908().method_17452((class_2394)ParticleTypesMCA.NEG_INTERACTION, true, this.method_23317(), this.method_23320() + 0.5, this.method_23321(), 0.0, 0.0, 0.0);
                break;
            }
            case 16: {
                this.method_37908().method_17452((class_2394)ParticleTypesMCA.POS_INTERACTION, true, this.method_23317(), this.method_23320() + 0.5, this.method_23321(), 0.0, 0.0, 0.0);
                break;
            }
            case 17: {
                this.method_18007((class_2394)class_2398.field_11209);
                break;
            }
            default: {
                super.method_5711(id);
            }
        }
    }

    public void onInvChange(class_1263 inventoryFromListener) {
    }

    @Nullable
    public <T extends class_1308> T method_29243(class_1299<T> type, boolean keepInventory) {
        VillagerLike zombie;
        this.residency.leaveHome();
        class_1308 mob = !this.method_31481() && type == class_1299.field_6054 ? super.method_29243(this.getGenetics().getGender().getZombieType(), keepInventory) : super.method_29243(type, keepInventory);
        if (mob instanceof VillagerLike) {
            zombie = (VillagerLike)mob;
            zombie.copyVillagerAttributesFrom(this);
        }
        if (mob instanceof class_1641) {
            zombie = (class_1641)mob;
            zombie.method_5943((class_5425)((class_3218)this.method_37908()), this.method_37908().method_8404(zombie.method_24515()), class_3730.field_16468, (class_1315)new class_1642.class_1644(false, true));
            zombie.method_7195(this.method_7231());
            zombie.method_21649((class_2520)this.method_21651().method_19067((DynamicOps)class_2509.field_11560));
            zombie.method_16916(this.method_8264().method_53882());
            zombie.method_19622(this.method_19269());
            zombie.method_5826(this.method_5667());
            zombie.method_5971();
            this.method_37908().method_8444(null, 1026, this.method_24515(), 0);
        }
        if (mob instanceof ZombieVillagerEntityMCA) {
            zombie = (ZombieVillagerEntityMCA)mob;
            ((ZombieVillagerEntityMCA)zombie).setInventory(this.inventory);
        }
        return (T)mob;
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.getTypeDataManager().load(this, nbt);
        this.relations.readFromNbt(nbt);
        this.longTermMemory.readFromNbt(nbt);
        this.playerModel = VillagerLike.PlayerModel.VALUES[nbt.method_10550("PlayerModel")];
        this.updateAttributes();
        this.inventory.method_5448();
        InventoryUtils.readFromNBT(this.method_56673(), this.inventory, nbt);
        if (nbt.method_10545("DespawnDelay")) {
            this.despawnDelay = nbt.method_10550("DespawnDelay");
        }
        if (nbt.method_10545("InteractedWith")) {
            this.interactedWith = nbt.method_10577("InteractedWith");
        }
        if (nbt.method_10545("Clothes")) {
            this.validateClothes();
        }
        if (this.getVillagerBrain().getPersonality() == Personality.UNASSIGNED) {
            this.getVillagerBrain().randomize();
        }
    }

    public final void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        this.relations.writeToNbt(nbt);
        this.longTermMemory.writeToNbt(nbt);
        this.getTypeDataManager().save(this, nbt);
        InventoryUtils.saveToNBT(this.method_56673(), this.inventory, nbt);
        nbt.method_10569("DespawnDelay", this.despawnDelay);
        nbt.method_10556("InteractedWith", this.interactedWith);
        if (this.interactedWith) {
            VillagerTrackerManager.update((class_1297)this);
        }
    }

    @Override
    public boolean isHostile() {
        return this.getProfession() == ProfessionsMCA.OUTLAW;
    }

    public boolean isFriend(class_1299<?> type) {
        return type == class_1299.field_6147 || type == EntitiesMCA.FEMALE_VILLAGER || type == EntitiesMCA.MALE_VILLAGER;
    }

    public boolean method_25938(class_1811 weapon) {
        return true;
    }

    public void method_7110(boolean charging) {
    }

    public void method_24651() {
    }

    public void method_5800(class_3218 world, class_1538 lightning) {
        this.getTraits().addTrait(Traits.ELECTRIFIED);
    }

    public void method_7105(class_1309 target, float pullProgress) {
        this.method_5980(target);
        this.attackedEntity((class_1297)target);
        if (this.method_24518(class_1802.field_8399)) {
            this.method_24654((class_1309)this, 1.75f);
        } else if (this.method_24518(class_1802.field_8102)) {
            class_1799 bow = this.method_5998(class_1675.method_18812((class_1309)this, (class_1792)class_1802.field_8102));
            class_1799 arrow = this.method_18808(bow);
            class_1665 persistentProjectileEntity = class_1675.method_18813((class_1309)this, (class_1799)arrow, (float)pullProgress, (class_1799)bow);
            double x = target.method_23317() - this.method_23317();
            double y = target.method_23323(0.3333333333333333) - persistentProjectileEntity.method_23318();
            double z = target.method_23321() - this.method_23321();
            double vel = Math.sqrt(x * x + z * z);
            persistentProjectileEntity.method_7485(x, y + vel * (double)0.2f, z, 1.6f, 3.0f);
            this.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.method_59922().method_43057() * 0.4f + 0.8f));
            this.method_37908().method_8649((class_1297)persistentProjectileEntity);
        }
    }

    public class_1799 method_18808(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1811) {
            class_1811 weapon = (class_1811)class_17922;
            Predicate predicate = weapon.method_20310();
            class_1799 itemStack = class_1811.method_18815((class_1309)this, (Predicate)predicate);
            return itemStack.method_7960() ? new class_1799((class_1935)class_1802.field_8107) : itemStack;
        }
        return class_1799.field_8037;
    }

    private void tickDespawnDelay() {
        if (this.despawnDelay > 0 && !this.method_18009() && --this.despawnDelay == 0) {
            if (this.getRelationships().getPartner().isPresent() || this.getVillagerBrain().getMemories().values().stream().anyMatch(m -> this.field_5974.method_43048(Config.getInstance().marriageHeartsRequirement) < m.getHearts())) {
                this.setProfession(class_3852.field_17051);
                this.setDespawnDelay(0);
            } else {
                this.method_31472();
            }
        }
    }

    public int getDespawnDelay() {
        return this.despawnDelay;
    }

    public void setDespawnDelay(int despawnDelay) {
        this.despawnDelay = despawnDelay;
    }

    public void makeMercenary() {
        this.setProfession(ProfessionsMCA.MERCENARY);
        this.inventory.method_5491(new class_1799((class_1935)class_1802.field_8371));
        this.inventory.method_5491(new class_1799((class_1935)class_1802.field_8475));
        this.inventory.method_5491(new class_1799((class_1935)class_1802.field_8403));
        this.inventory.method_5491(new class_1799((class_1935)class_1802.field_8609));
        this.inventory.method_5491(new class_1799((class_1935)class_1802.field_8378));
        this.inventory.method_5491(new class_1799((class_1935)class_1802.field_8229, 16));
    }

    public void customLevelUp() {
        this.method_7195(this.method_7231().method_16920(this.method_7231().method_16925() + 1));
        this.method_7237();
    }
}

