/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity;

import java.util.Optional;
import java.util.Set;
import net.conczin.mca.Config;
import net.conczin.mca.MCA;
import net.conczin.mca.entity.Infectable;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.DialogueType;
import net.conczin.mca.entity.ai.Genetics;
import net.conczin.mca.entity.ai.Messenger;
import net.conczin.mca.entity.ai.Traits;
import net.conczin.mca.entity.ai.brain.VillagerBrain;
import net.conczin.mca.entity.ai.relationship.AgeState;
import net.conczin.mca.entity.ai.relationship.EntityRelationship;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.conczin.mca.entity.ai.relationship.VillagerDimensions;
import net.conczin.mca.entity.interaction.EntityCommandHandler;
import net.conczin.mca.registry.EntitiesMCA;
import net.conczin.mca.resources.ClothingList;
import net.conczin.mca.resources.HairList;
import net.conczin.mca.resources.Names;
import net.conczin.mca.server.world.data.FamilyTreeNode;
import net.conczin.mca.server.world.data.PlayerSaveData;
import net.conczin.mca.util.network.datasync.CDataManager;
import net.conczin.mca.util.network.datasync.CDataParameter;
import net.conczin.mca.util.network.datasync.CEnumParameter;
import net.conczin.mca.util.network.datasync.CParameter;
import net.conczin.mca.util.network.datasync.CTrackedEntity;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1472;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_3851;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5253;
import net.minecraft.class_5819;
import net.minecraft.class_7225;

public interface VillagerLike<E extends class_1297>
extends CTrackedEntity<E>,
class_3851,
Infectable,
Messenger {
    public static final CDataParameter<String> CLOTHES;
    public static final CDataParameter<String> HAIR;
    public static final CDataParameter<Float> HAIR_COLOR_RED;
    public static final CDataParameter<Float> HAIR_COLOR_GREEN;
    public static final CDataParameter<Float> HAIR_COLOR_BLUE;
    public static final CEnumParameter<AgeState> AGE_STATE;
    public static final class_2960 SPEED_ID;
    public static final class_2960 DAMAGE_ID;

    public static <E extends class_1297> CDataManager.Builder<E> createTrackedData(Class<E> type) {
        return new CDataManager.Builder<E>(type).addAll(CLOTHES, HAIR, HAIR_COLOR_RED, HAIR_COLOR_GREEN, HAIR_COLOR_BLUE, AGE_STATE).add(Genetics::createTrackedData).add(Traits::createTrackedData).add(VillagerBrain::createTrackedData);
    }

    public static VillagerLike<?> toVillager(PlayerSaveData player) {
        class_2487 villagerData = player.getEntityData();
        VillagerEntityMCA villager = (VillagerEntityMCA)EntitiesMCA.MALE_VILLAGER.method_5883((class_1937)player.getWorld());
        if (!1.$assertionsDisabled && villager == null) {
            throw new AssertionError();
        }
        villager.method_5749(villagerData);
        return villager;
    }

    public static VillagerLike<?> toVillager(class_1297 entity) {
        if (entity instanceof VillagerLike) {
            return (VillagerLike)entity;
        }
        if (entity instanceof class_3222) {
            class_3222 playerEntity = (class_3222)entity;
            return VillagerLike.toVillager(PlayerSaveData.get(playerEntity));
        }
        return null;
    }

    public Genetics getGenetics();

    public Traits getTraits();

    public VillagerBrain<?> getVillagerBrain();

    public EntityCommandHandler<?> getInteractions();

    default public void initialize(class_3730 spawnReason) {
        if (spawnReason != class_3730.field_16468) {
            if (spawnReason != class_3730.field_16466) {
                this.getGenetics().randomize();
                this.getTraits().randomize();
            }
            this.initializeSkin(false);
            this.getVillagerBrain().randomize();
        }
        if (this.getGenetics().getGender() == Gender.UNASSIGNED) {
            this.getGenetics().setGender(Gender.getRandom());
        }
        if (this.asEntity().method_5797() == null) {
            this.asEntity().method_5665((class_2561)class_2561.method_43470((String)Names.pickCitizenName(this.getGenetics().getGender(), (class_1297)this.asEntity())));
        }
        this.validateClothes();
        this.asEntity().method_18382();
    }

    @Override
    default public boolean isSpeechImpaired() {
        return this.getInfectionProgress() > 0.6f;
    }

    @Override
    default public boolean isToYoungToSpeak() {
        return this.getAgeState() == AgeState.BABY;
    }

    default public void setName(String name) {
        if (!this.asEntity().method_37908().field_9236) {
            EntityRelationship.of((class_1297)this.asEntity()).ifPresent(relationship -> relationship.getFamilyEntry().setName(name));
        }
    }

    default public Set<Gender> getAttractedGenderSet(VillagerLike<?> villager) {
        if (villager.getTraits().hasTrait(Traits.BISEXUAL)) {
            return Set.of(Gender.MALE, Gender.FEMALE, Gender.NEUTRAL);
        }
        if (villager.getTraits().hasTrait(Traits.HOMOSEXUAL)) {
            return Set.of(villager.getGenetics().getGender(), Gender.NEUTRAL);
        }
        if (villager.getTraits().hasTrait(Traits.ASEXUAL)) {
            return Set.of(Gender.NEUTRAL);
        }
        return Set.of(villager.getGenetics().getGender().opposite(), Gender.NEUTRAL);
    }

    default public boolean canBeAttractedTo(VillagerLike<?> other) {
        return this.getAttractedGenderSet(this).contains((Object)other.getGenetics().getGender()) && this.getAttractedGenderSet(other).contains((Object)this.getGenetics().getGender());
    }

    default public boolean canBeAttractedTo(PlayerSaveData other) {
        return !Config.getInstance().enableGenderCheckForPlayers || this.canBeAttractedTo(VillagerLike.toVillager(other));
    }

    default public class_1268 getDominantHand() {
        return this.getTraits().hasTrait(Traits.LEFT_HANDED) ? class_1268.field_5810 : class_1268.field_5808;
    }

    default public class_1268 getOpposingHand() {
        return this.getDominantHand() == class_1268.field_5810 ? class_1268.field_5808 : class_1268.field_5810;
    }

    default public class_1304 getDominantSlot() {
        return class_1309.method_56079((class_1268)this.getDominantHand());
    }

    default public class_1304 getOpposingSlot() {
        return class_1309.method_56079((class_1268)this.getOpposingHand());
    }

    default public class_2960 getProfessionId() {
        return MCA.locate("none");
    }

    default public String getProfessionName() {
        String professionName = (this.getProfessionId().method_12836().equalsIgnoreCase("minecraft") ? (this.getProfessionId().method_12832().equals("none") ? "mca.none" : this.getProfessionId().method_12832()) : this.getProfessionId().toString()).replace(":", ".");
        return MCA.isBlankString(professionName) ? "mca.none" : professionName;
    }

    default public class_5250 getProfessionText() {
        return class_2561.method_43471((String)("entity.minecraft.villager." + this.getProfessionName()));
    }

    default public boolean isProfessionImportant() {
        return false;
    }

    default public boolean requiresHome() {
        return false;
    }

    default public boolean canTradeWithProfession() {
        return false;
    }

    default public String getClothes() {
        return (String)this.getTrackedValue(CLOTHES);
    }

    default public void setClothes(class_2960 clothes) {
        this.setClothes(clothes.toString());
    }

    default public void setClothes(String clothes) {
        this.setTrackedValue(CLOTHES, clothes);
    }

    default public String getHair() {
        return (String)this.getTrackedValue(HAIR);
    }

    default public void setHair(class_2960 hair) {
        this.setHair(hair.toString());
    }

    default public void setHair(String hair) {
        this.setTrackedValue(HAIR, hair);
    }

    default public void setHairDye(float r, float g, float b) {
        this.setTrackedValue(HAIR_COLOR_RED, Float.valueOf(r));
        this.setTrackedValue(HAIR_COLOR_GREEN, Float.valueOf(g));
        this.setTrackedValue(HAIR_COLOR_BLUE, Float.valueOf(b));
    }

    default public void clearHairDye() {
        this.setHairDye(0.0f, 0.0f, 0.0f);
    }

    default public int getHairDye() {
        return class_5253.class_5254.method_59554((float)1.0f, (float)((Float)this.getTrackedValue(HAIR_COLOR_RED)).floatValue(), (float)((Float)this.getTrackedValue(HAIR_COLOR_GREEN)).floatValue(), (float)((Float)this.getTrackedValue(HAIR_COLOR_BLUE)).floatValue());
    }

    default public void setHairDye(class_1767 color) {
        int components = color.method_7787();
        int dye = this.getHairDye();
        if (dye > 0) {
            components = class_5253.class_5254.method_48780((float)0.5f, (int)components, (int)dye);
        }
        this.setTrackedValue(HAIR_COLOR_RED, Float.valueOf((float)class_5253.class_5254.method_27765((int)components) / 255.0f));
        this.setTrackedValue(HAIR_COLOR_GREEN, Float.valueOf((float)class_5253.class_5254.method_27766((int)components) / 255.0f));
        this.setTrackedValue(HAIR_COLOR_BLUE, Float.valueOf((float)class_5253.class_5254.method_27767((int)components) / 255.0f));
    }

    default public AgeState getAgeState() {
        return (AgeState)this.getTrackedValue(AGE_STATE);
    }

    default public VillagerDimensions getVillagerDimensions() {
        return this.getAgeState();
    }

    default public void updateAttributes() {
        class_1324 attackAttributeInstance;
        float speed = 1.0f;
        if (this.getTraits().hasTrait(Traits.ATHLETIC)) {
            speed *= 1.1f;
        }
        speed /= 0.9f + this.getGenetics().getGene(Genetics.WIDTH) * 0.2f;
        speed *= 0.9f + this.getGenetics().getGene(Genetics.SIZE) * 0.2f;
        speed *= this.getAgeState().getSpeed();
        class_1324 entityAttributeInstance = this.asEntity().method_5996(class_5134.field_23719);
        if (entityAttributeInstance != null) {
            entityAttributeInstance.method_6200(SPEED_ID);
            class_1322 speedModifier = new class_1322(SPEED_ID, (double)(speed - 1.0f), class_1322.class_1323.field_6330);
            entityAttributeInstance.method_26835(speedModifier);
        }
        float damageMultiplier = 1.0f;
        if (this.getTraits().hasTrait(Traits.WEAK)) {
            damageMultiplier *= 0.75f;
        }
        if (this.getTraits().hasTrait(Traits.TOUGH)) {
            damageMultiplier *= 1.5f;
        }
        if ((attackAttributeInstance = this.asEntity().method_5996(class_5134.field_23721)) != null) {
            attackAttributeInstance.method_6200(DAMAGE_ID);
            class_1322 damageModifier = new class_1322(DAMAGE_ID, (double)(damageMultiplier - 1.0f), class_1322.class_1323.field_6330);
            attackAttributeInstance.method_26835(damageModifier);
        }
    }

    default public boolean setAgeState(AgeState state) {
        AgeState old = this.getAgeState();
        if (state == old) {
            return false;
        }
        this.setTrackedValue(AGE_STATE, state);
        this.asEntity().method_18382();
        this.updateAttributes();
        return old != AgeState.UNASSIGNED;
    }

    default public float getHorizontalScaleFactor() {
        if (this.getGenetics() == null || Config.getInstance().useSquidwardModels) {
            return this.asEntity().method_6109() ? 0.5f : 1.0f;
        }
        return Math.min(0.999f, this.getRawHorizontalScaleFactor());
    }

    default public float getRawHorizontalScaleFactor() {
        return this.getGenetics().getHorizontalScaleFactor() * this.getTraits().getHorizontalScaleFactor() * this.getVillagerDimensions().getWidth() * this.getGenetics().getGender().getHorizontalScaleFactor();
    }

    default public float getVerticalScaleFactor() {
        return Math.min(0.999f, this.getRawVerticalScaleFactor());
    }

    default public float getRawVerticalScaleFactor() {
        if (this.getGenetics() == null || Config.getInstance().useSquidwardModels) {
            return this.asEntity().method_6109() ? 0.5f : 1.0f;
        }
        return this.getGenetics().getVerticalScaleFactor() * this.getTraits().getVerticalScaleFactor() * this.getVillagerDimensions().getHeight() * this.getGenetics().getGender().getScaleFactor();
    }

    @Override
    default public DialogueType getDialogueType(class_1657 receiver) {
        if (!receiver.method_37908().field_9236) {
            Optional<EntityRelationship> r;
            DialogueType type = DialogueType.fromAge(this.getAgeState());
            if (!receiver.method_37908().field_9236 && (r = EntityRelationship.of((class_1297)this.asEntity())).isPresent()) {
                FamilyTreeNode relationship = r.get().getFamilyEntry();
                if (r.get().isMarriedTo(receiver.method_5667())) {
                    return DialogueType.SPOUSE;
                }
                if (r.get().isEngagedWith(receiver.method_5667())) {
                    return DialogueType.ENGAGED;
                }
                if (relationship.isParent(receiver.method_5667())) {
                    return type.toChild();
                }
            }
            this.getVillagerBrain().getMemoriesForPlayer(receiver).setDialogueType(type);
        }
        return this.getVillagerBrain().getMemoriesForPlayer(receiver).getDialogueType();
    }

    default public void initializeSkin(boolean isPlayer) {
        class_1308 entity;
        this.randomizeClothes();
        this.randomizeHair();
        if (!isPlayer && (entity = this.asEntity()).method_59922().method_43057() < Config.getInstance().coloredHairChance) {
            int n = entity.method_59922().method_43048(25);
            int o = class_1767.values().length;
            int p = n % o;
            int q = (n + 1) % o;
            float r = entity.method_59922().method_43057();
            int fs = class_1472.method_6634((class_1767)class_1767.method_7791((int)p));
            int gs = class_1472.method_6634((class_1767)class_1767.method_7791((int)q));
            int color = class_5253.class_5254.method_48780((float)r, (int)fs, (int)gs);
            this.setTrackedValue(HAIR_COLOR_RED, Float.valueOf((float)class_5253.class_5254.method_27765((int)color) / 255.0f));
            this.setTrackedValue(HAIR_COLOR_GREEN, Float.valueOf((float)class_5253.class_5254.method_27766((int)color) / 255.0f));
            this.setTrackedValue(HAIR_COLOR_BLUE, Float.valueOf((float)class_5253.class_5254.method_27767((int)color) / 255.0f));
        }
    }

    default public void randomizeClothes() {
        this.setClothes(ClothingList.getInstance().getPool(this).pickOne());
    }

    default public void randomizeHair() {
        this.setHair(HairList.getInstance().getPool(this.getGenetics().getGender()).pickOne());
    }

    default public void validateClothes() {
        if (!this.asEntity().method_37908().method_8608()) {
            if (!this.getClothes().startsWith("immersive_library") && !ClothingList.getInstance().clothing.containsKey(this.getClothes())) {
                MCA.LOGGER.info("Villagers clothing {} does not exist!", (Object)this.getClothes());
                this.randomizeClothes();
            }
            if (!this.getHair().startsWith("immersive_library") && !HairList.getInstance().hair.containsKey(this.getHair())) {
                MCA.LOGGER.info("Villagers hair {} does not exist!", (Object)this.getHair());
                this.randomizeHair();
            }
        }
    }

    default public class_2487 toNbtForConversion() {
        class_2487 output = new class_2487();
        this.getTypeDataManager().save(this.asEntity(), output);
        return output;
    }

    default public void readNbtForConversion(class_2487 input) {
        this.getTypeDataManager().load(this.asEntity(), input);
    }

    default public void syncFromEditor(class_2487 nbt) {
        class_1308 entity = this.asEntity();
        entity.method_5749(nbt);
        if (nbt.method_10573("CustomName", 8)) {
            String s = nbt.method_10558("CustomName");
            try {
                entity.method_5665((class_2561)class_2561.class_2562.method_10877((String)s, (class_7225.class_7874)entity.method_56673()));
            }
            catch (Exception exception) {
                MCA.LOGGER.warn("Failed to parse entity custom name {}", (Object)s, (Object)exception);
            }
        }
    }

    default public void copyVillagerAttributesFrom(VillagerLike<?> other) {
        this.readNbtForConversion(other.toNbtForConversion());
    }

    default public boolean isHostile() {
        return false;
    }

    default public PlayerModel getPlayerModel() {
        return PlayerModel.VILLAGER;
    }

    public boolean isBurned();

    default public void spawnBurntParticles() {
        class_5819 random = this.asEntity().method_59922();
        if (random.method_43048(4) == 0) {
            double d = random.method_43059() * 0.02;
            double e = random.method_43059() * 0.02;
            double f = random.method_43059() * 0.02;
            this.asEntity().method_37908().method_8406((class_2394)class_2398.field_11251, this.asEntity().method_23322(1.0), this.asEntity().method_23319() + 1.0, this.asEntity().method_23325(1.0), d, e, f);
        }
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        CLOTHES = CParameter.create("Clothes", "");
        HAIR = CParameter.create("Hair", "");
        HAIR_COLOR_RED = CParameter.create("HairColorRed", 0.0f);
        HAIR_COLOR_GREEN = CParameter.create("HairColorGreen", 0.0f);
        HAIR_COLOR_BLUE = CParameter.create("HairColorBlue", 0.0f);
        AGE_STATE = CParameter.create("AgeState", AgeState.UNASSIGNED);
        SPEED_ID = MCA.locate("trait_speed");
        DAMAGE_ID = MCA.locate("trait_damage");
    }

    public static enum PlayerModel {
        VILLAGER,
        PLAYER,
        VANILLA;

        static final PlayerModel[] VALUES;

        static {
            VALUES = PlayerModel.values();
        }
    }
}

