/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import net.conczin.mca.Config;
import net.conczin.mca.entity.VillagerLike;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.conczin.mca.util.network.datasync.CDataManager;
import net.conczin.mca.util.network.datasync.CDataParameter;
import net.conczin.mca.util.network.datasync.CEnumParameter;
import net.conczin.mca.util.network.datasync.CParameter;
import net.minecraft.class_1297;
import net.minecraft.class_1959;
import net.minecraft.class_3532;
import net.minecraft.class_5819;

public class Genetics
implements Iterable<Gene> {
    private static final Set<GeneType> GENOMES = new HashSet<GeneType>();
    public static final GeneType SIZE = new GeneType("Size");
    public static final GeneType WIDTH = new GeneType("Width");
    public static final GeneType BREAST = new GeneType("Breast");
    public static final GeneType MELANIN = new GeneType("Melanin");
    public static final GeneType HEMOGLOBIN = new GeneType("Hemoglobin");
    public static final GeneType EUMELANIN = new GeneType("Eumelanin");
    public static final GeneType PHEOMELANIN = new GeneType("Pheomelanin");
    public static final GeneType SKIN = new GeneType("Skin");
    public static final GeneType FACE = new GeneType("Face");
    public static final GeneType VOICE = new GeneType("Voice");
    public static final GeneType VOICE_TONE = new GeneType("VoiceTone");
    private static final CEnumParameter<Gender> GENDER = CParameter.create("Gender", Gender.UNASSIGNED);
    private final Map<GeneType, Gene> genes = new HashMap<GeneType, Gene>();
    private final VillagerLike<?> entity;
    private class_5819 random = class_5819.method_43047();

    public Genetics(VillagerLike<?> entity) {
        this.entity = entity;
    }

    public static <E extends class_1297> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        GENOMES.forEach(g -> builder.addAll(g.getParam()));
        return builder.addAll(GENDER);
    }

    public float getVerticalScaleFactor() {
        return 0.75f + this.getGene(SIZE) / 2.0f;
    }

    public float getHorizontalScaleFactor() {
        return 0.75f + this.getGene(WIDTH) / 2.0f;
    }

    public Gender getGender() {
        return (Gender)((Object)this.entity.getTrackedValue(GENDER));
    }

    public void setGender(Gender gender) {
        this.entity.setTrackedValue(GENDER, gender);
    }

    public float getBreastSize() {
        return this.getGender() == Gender.FEMALE ? this.getGene(BREAST) : 0.0f;
    }

    @Override
    public Iterator<Gene> iterator() {
        return this.genes.values().iterator();
    }

    public void setGene(GeneType type, float value) {
        this.getGenome(type).set(value);
    }

    public float getGene(GeneType type) {
        return this.getGenome(type).get();
    }

    public Gene getGenome(GeneType type) {
        return this.genes.computeIfAbsent(type, x$0 -> new Gene((GeneType)x$0));
    }

    public void randomize() {
        for (GeneType type : GENOMES) {
            this.getGenome(type).randomize();
        }
        this.setGene(SIZE, this.centeredRandom());
        this.setGene(WIDTH, this.centeredRandom());
        float temp = ((class_1959)this.entity.asEntity().method_37908().method_23753(this.entity.asEntity().method_24515()).comp_349()).method_8712();
        if (this.random.method_43057() < Config.getInstance().geneticImmigrantChance) {
            temp = this.random.method_43057() * 2.0f - 0.5f;
        }
        float height = this.entity.asEntity().method_24515().method_10264();
        height -= (float)this.entity.asEntity().method_37908().method_8615();
        this.setGene(MELANIN, class_3532.method_15363((float)(this.temperatureBaseRandom(temp) - (height /= 128.0f) * 0.2f), (float)0.0f, (float)1.0f));
        this.setGene(HEMOGLOBIN, class_3532.method_15363((float)(this.temperatureBaseRandom(temp) * 0.5f + height * 0.5f), (float)0.0f, (float)1.0f));
        this.setGene(EUMELANIN, this.random.method_43057());
        this.setGene(PHEOMELANIN, this.random.method_43057());
    }

    private float centeredRandom() {
        return Math.min(1.0f, Math.max(0.0f, (this.random.method_43057() - 0.5f) * (this.random.method_43057() - 0.5f) + 0.5f));
    }

    private float temperatureBaseRandom(float temp) {
        return (this.random.method_43057() - 0.5f) * 0.35f + temp * 0.4f + 0.1f;
    }

    public void combine(Genetics mother, Genetics father) {
        for (GeneType type : GENOMES) {
            this.getGenome(type).mutate(mother, father);
        }
    }

    public void combine(Genetics mother, Genetics father, long seed) {
        class_5819 old = this.random;
        this.random = class_5819.method_43049((long)seed);
        this.combine(mother, father);
        this.random = old;
    }

    public static class GeneType
    implements Comparable<GeneType> {
        private final String key;
        private final CDataParameter<Float> parameter;

        public GeneType(String key) {
            this.key = key;
            this.parameter = CParameter.create("Gene" + key, 0.5f);
            GENOMES.add(this);
        }

        public String key() {
            return this.key;
        }

        public String getTranslationKey() {
            return "gene." + this.key().toLowerCase(Locale.ROOT);
        }

        public CDataParameter<Float> getParam() {
            return this.parameter;
        }

        @Override
        public int compareTo(GeneType o) {
            return this.key().compareTo(o.key());
        }

        public int hashCode() {
            return this.key.hashCode();
        }

        public boolean equals(Object o) {
            GeneType geneType;
            return o instanceof GeneType && (geneType = (GeneType)o).key().equals(this.key());
        }
    }

    public class Gene {
        private final GeneType type;

        public Gene(GeneType type) {
            this.type = type;
        }

        public GeneType getType() {
            return this.type;
        }

        public float get() {
            return ((Float)Genetics.this.entity.getTrackedValue(this.type.parameter)).floatValue();
        }

        public void set(float value) {
            Genetics.this.entity.setTrackedValue(this.type.parameter, Float.valueOf(value));
        }

        public void randomize() {
            this.set(Genetics.this.random.method_43057());
        }

        public void mutate(Genetics mother, Genetics father) {
            float m = mother.getGene(this.type);
            float f = father.getGene(this.type);
            float interpolation = Genetics.this.random.method_43057();
            float mutation = (Genetics.this.random.method_43057() - 0.5f) * 0.2f;
            float g = m * interpolation + f * (1.0f - interpolation) + mutation;
            this.set((float)Math.min(1.0, Math.max(0.0, (double)g)));
        }
    }
}

