/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.brain.tasks.chore;

import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonSyntaxException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.conczin.mca.Config;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.Chore;
import net.conczin.mca.entity.ai.TaskUtils;
import net.conczin.mca.entity.ai.brain.tasks.chore.AbstractChoreTask;
import net.conczin.mca.util.InventoryUtils;
import net.conczin.mca.util.RegistryHelper;
import net.minecraft.class_1263;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1743;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public class ChoppingTask
extends AbstractChoreTask {
    private int chopTicks;
    private int targetTreeTicks;
    private class_2338 targetTree;

    public ChoppingTask() {
        super((Map<class_4140<?>, class_4141>)ImmutableMap.of((Object)class_4140.field_18446, (Object)class_4141.field_18457, (Object)class_4140.field_18445, (Object)class_4141.field_18457));
    }

    @Override
    protected boolean checkExtraStartConditions(class_3218 world, VillagerEntityMCA villager) {
        return villager.getVillagerBrain().getCurrentJob() == Chore.CHOP && super.checkExtraStartConditions(world, villager);
    }

    protected boolean canStillUse(class_3218 world, VillagerEntityMCA villager, long time) {
        return this.checkExtraStartConditions(world, villager);
    }

    protected void stop(class_3218 world, VillagerEntityMCA villager, long time) {
        class_1799 stack = villager.method_5998(villager.getDominantHand());
        if (!stack.method_7960()) {
            villager.method_6122(villager.getDominantHand(), class_1799.field_8037);
        }
    }

    @Override
    protected void start(class_3218 world, VillagerEntityMCA villager, long time) {
        super.start(world, villager, time);
        if (!villager.method_6084(villager.getDominantSlot())) {
            int i = InventoryUtils.getFirstSlotContainingItem((class_1263)villager.method_35199(), stack -> stack.method_7909() instanceof class_1743);
            if (i == -1) {
                this.abandonJobWithMessage("chore.chopping.noaxe");
            } else {
                villager.method_6122(villager.getDominantHand(), villager.method_35199().method_5438(i));
            }
        }
    }

    @Override
    protected void tick(class_3218 world, VillagerEntityMCA villager, long time) {
        if (this.villager == null) {
            this.villager = villager;
        }
        if (!InventoryUtils.contains((class_1263)villager.method_35199(), class_1743.class) && !villager.method_6084(villager.getDominantSlot())) {
            this.abandonJobWithMessage("chore.chopping.noaxe");
        } else if (!villager.method_6084(villager.getDominantSlot())) {
            int i = InventoryUtils.getFirstSlotContainingItem((class_1263)villager.method_35199(), stack -> stack.method_7909() instanceof class_1743);
            class_1799 stack2 = villager.method_35199().method_5438(i);
            villager.method_6122(villager.getDominantHand(), stack2);
        }
        if (this.targetTree == null) {
            List<class_2338> nearbyLogs = TaskUtils.getNearbyBlocks(villager.method_24515(), (class_1937)world, blockState -> blockState.method_26164(class_3481.field_15475), 15, 5);
            ArrayList<class_2338> nearbyTrees = new ArrayList<class_2338>();
            nearbyLogs.stream().filter(log -> this.isTreeStartLog(world, (class_2338)log)).forEach(nearbyTrees::add);
            this.targetTree = TaskUtils.getNearestPoint(villager.method_24515(), nearbyTrees);
            if (this.targetTree != null) {
                class_2680 state;
                class_1799 stack3 = villager.method_5998(villager.getDominantHand());
                class_2338 pos = this.targetTree;
                while ((state = world.method_8320(pos)).method_26164(class_3481.field_15475)) {
                    this.targetTreeTicks += (int)((float)this.getTicksFor(state, 60) / stack3.method_7924(state));
                    pos = pos.method_10069(0, 1, 0);
                }
            }
            this.failedTicks = 100;
            return;
        }
        villager.moveTowards(this.targetTree);
        class_2680 state = world.method_8320(this.targetTree);
        if (state.method_26164(class_3481.field_15475)) {
            villager.method_6104(villager.getDominantHand());
            ++this.chopTicks;
            if (this.chopTicks >= this.targetTreeTicks) {
                this.chopTicks = 0;
                this.destroyTree(world, this.targetTree);
            }
        } else {
            this.targetTree = null;
            this.targetTreeTicks = 0;
        }
        super.tick(world, villager, time);
    }

    private boolean isTreeStartLog(class_3218 world, class_2338 origin) {
        if (!world.method_8320(origin).method_26164(class_3481.field_15475)) {
            return false;
        }
        if (!this.isValidTree(world, origin.method_10074())) {
            return false;
        }
        class_2338.class_2339 posUp = origin.method_25503();
        for (int y = 0; y < Config.getInstance().maxTreeHeight; ++y) {
            class_2680 up = world.method_8320((class_2338)posUp.method_33098(posUp.method_10264() + 1));
            if (up.method_26164(class_3481.field_15475)) continue;
            return up.method_26164(class_3481.field_15503);
        }
        return false;
    }

    private void destroyTree(class_3218 world, class_2338 origin) {
        class_2680 state;
        class_1799 stack = this.villager.method_5998(this.villager.getDominantHand());
        class_2338 pos = origin;
        while ((state = world.method_8320(pos)).method_26164(class_3481.field_15475) && world.method_8651(pos, false, (class_1297)this.villager)) {
            pos = pos.method_10069(0, 1, 0);
            this.villager.method_35199().method_5491(new class_1799((class_1935)state.method_26204(), 1));
            stack.method_7970(1, (class_1309)this.villager, class_1304.field_6173);
        }
    }

    private boolean isValidTree(class_3218 world, class_2338 pos) {
        class_2680 state = world.method_8320(pos);
        class_2960 stateId = class_7923.field_41175.method_10221((Object)state.method_26204());
        for (String blockId : Config.getInstance().validTreeSources) {
            if (blockId.equals(stateId.toString())) {
                return true;
            }
            if (blockId.charAt(0) != '#') continue;
            class_2960 identifier = class_2960.method_60654((String)blockId.substring(1));
            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)identifier);
            if (!RegistryHelper.isTagEmpty(tag)) {
                if (!state.method_26164(tag)) continue;
                return true;
            }
            throw new JsonSyntaxException("Unknown block tag in validTreeSources '" + String.valueOf(identifier) + "'");
        }
        return false;
    }

    private int getTicksFor(class_2680 state, int fallback) {
        Map<String, Integer> sources = Config.getInstance().maxTreeTicks;
        class_2960 stateId = class_7923.field_41175.method_10221((Object)state.method_26204());
        for (String blockId : sources.keySet()) {
            if (blockId.equals(stateId.toString())) {
                return sources.get(blockId);
            }
            if (blockId.charAt(0) != '#') continue;
            class_2960 identifier = class_2960.method_60654((String)blockId.substring(1));
            class_6862 tag = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)identifier);
            if (!RegistryHelper.isTagEmpty(tag)) {
                if (!state.method_26164(tag)) continue;
                return sources.get(blockId);
            }
            throw new JsonSyntaxException("Unknown block tag in maxTreeTicks '" + String.valueOf(identifier) + "'");
        }
        return fallback;
    }
}

