/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai.relationship;

import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.conczin.mca.entity.ai.relationship.CompassionateEntity;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.conczin.mca.entity.ai.relationship.RelationshipState;
import net.conczin.mca.entity.ai.relationship.RelationshipType;
import net.conczin.mca.registry.CriterionMCA;
import net.conczin.mca.server.world.data.FamilyTree;
import net.conczin.mca.server.world.data.FamilyTreeNode;
import net.conczin.mca.server.world.data.PlayerSaveData;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface EntityRelationship {
    public static Optional<EntityRelationship> of(class_1297 entity) {
        if (entity instanceof class_3222) {
            class_3222 player = (class_3222)entity;
            return Optional.ofNullable(PlayerSaveData.get(player));
        }
        if (entity instanceof CompassionateEntity) {
            CompassionateEntity compassionateEntity = (CompassionateEntity)entity;
            return Optional.ofNullable(compassionateEntity.getRelationships());
        }
        return Optional.empty();
    }

    default public Gender getGender() {
        return Gender.MALE;
    }

    default public FamilyTree getFamilyTree() {
        return FamilyTree.get(this.getWorld());
    }

    public class_3218 getWorld();

    public UUID getUUID();

    @NotNull
    public FamilyTreeNode getFamilyEntry();

    default public Stream<class_1297> getFamily(int parents, int children) {
        return this.getFamilyEntry().getRelatives(parents, children).map(arg_0 -> ((class_3218)this.getWorld()).method_14190(arg_0)).filter(Objects::nonNull).filter(e -> !e.method_5667().equals(this.getUUID()));
    }

    default public Stream<class_1297> getParents() {
        return this.getFamilyEntry().streamParents().map(arg_0 -> ((class_3218)this.getWorld()).method_14190(arg_0)).filter(Objects::nonNull);
    }

    default public Optional<class_1297> getPartner() {
        return Optional.ofNullable(this.getWorld().method_14190(this.getFamilyEntry().partner()));
    }

    default public Stream<EntityRelationship> getRelationshipStream(Stream<UUID> uuids) {
        return uuids.map(uuid -> PlayerSaveData.getIfPresent(this.getWorld(), uuid).map(p -> p).or(() -> EntityRelationship.of(this.getWorld().method_14190(uuid)))).filter(Optional::isPresent).map(Optional::get);
    }

    default public void onTragedy(class_1282 cause, @Nullable class_2338 burialSite, RelationshipType type, class_1297 victim) {
        if (type == RelationshipType.STRANGER) {
            return;
        }
        if (type == RelationshipType.SELF) {
            this.getRelationshipStream(this.getFamilyEntry().streamParents()).forEach(r -> r.onTragedy(cause, burialSite, RelationshipType.CHILD, victim));
            this.getRelationshipStream(this.getFamilyEntry().siblings().stream()).forEach(r -> r.onTragedy(cause, burialSite, RelationshipType.SIBLING, victim));
            this.getRelationshipStream(Stream.of(this.getFamilyEntry().partner())).forEach(r -> r.onTragedy(cause, burialSite, RelationshipType.SPOUSE, victim));
        }
        if (type == RelationshipType.SPOUSE || type == RelationshipType.SELF) {
            if (this.getRelationshipState().isMarried()) {
                this.endRelationShip(RelationshipState.WIDOW);
            } else {
                this.endRelationShip(RelationshipState.SINGLE);
            }
        }
    }

    default public void marry(class_1297 spouse) {
        RelationshipState state;
        RelationshipState relationshipState = state = spouse instanceof class_1657 ? RelationshipState.MARRIED_TO_PLAYER : RelationshipState.MARRIED_TO_VILLAGER;
        if (spouse instanceof class_3222) {
            class_3222 spouseEntity = (class_3222)spouse;
            CriterionMCA.GENERIC_EVENT.trigger(spouseEntity, "marriage");
        }
        this.getFamilyEntry().updatePartner(spouse, state);
    }

    default public void engage(class_1297 spouse) {
        if (spouse instanceof class_3222) {
            class_3222 spouseEntity = (class_3222)spouse;
            CriterionMCA.GENERIC_EVENT.trigger(spouseEntity, "engage");
        }
        this.getFamilyEntry().updatePartner(spouse, RelationshipState.ENGAGED);
    }

    default public void promise(class_1297 spouse) {
        if (spouse instanceof class_3222) {
            class_3222 spouseEntity = (class_3222)spouse;
            CriterionMCA.GENERIC_EVENT.trigger(spouseEntity, "promise");
        }
        this.getFamilyEntry().updatePartner(spouse, RelationshipState.PROMISED);
    }

    default public void endRelationShip(RelationshipState newState) {
        this.getFamilyEntry().updatePartner(null, newState);
    }

    default public RelationshipState getRelationshipState() {
        return this.getFamilyEntry().getRelationshipState();
    }

    default public Optional<UUID> getPartnerUUID() {
        UUID spouse = this.getFamilyEntry().partner();
        if (spouse.equals(class_156.field_25140)) {
            return Optional.empty();
        }
        return Optional.of(spouse);
    }

    default public Optional<class_2561> getPartnerName() {
        return this.getFamilyTree().getOrEmpty(this.getFamilyEntry().partner()).map(FamilyTreeNode::getName).map(class_2561::method_43470);
    }

    default public boolean isMarried() {
        return this.getRelationshipState() == RelationshipState.MARRIED_TO_PLAYER || this.getRelationshipState() == RelationshipState.MARRIED_TO_VILLAGER;
    }

    default public boolean isEngaged() {
        return this.getRelationshipState() == RelationshipState.ENGAGED;
    }

    default public boolean isPromised() {
        return this.getRelationshipState() == RelationshipState.PROMISED;
    }

    default public boolean isPromisedTo(UUID uuid) {
        return this.getPartnerUUID().orElse(class_156.field_25140).equals(uuid) && this.isPromised();
    }

    default public boolean isMarriedTo(UUID uuid) {
        return this.getPartnerUUID().orElse(class_156.field_25140).equals(uuid) && this.isMarried();
    }

    default public boolean isEngagedWith(UUID uuid) {
        return this.getPartnerUUID().orElse(class_156.field_25140).equals(uuid) && this.isEngaged();
    }
}

