/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.item;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import net.conczin.mca.ClientProxy;
import net.conczin.mca.Config;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.VillagerFactory;
import net.conczin.mca.entity.VillagerLike;
import net.conczin.mca.entity.ai.Memories;
import net.conczin.mca.entity.ai.relationship.AgeState;
import net.conczin.mca.entity.ai.relationship.Gender;
import net.conczin.mca.item.components.BabyParentsComponent;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.s2c.OpenGuiRequest;
import net.conczin.mca.registry.CriterionMCA;
import net.conczin.mca.registry.DataComponentsMCA;
import net.conczin.mca.registry.ItemsMCA;
import net.conczin.mca.server.world.data.FamilyTree;
import net.conczin.mca.server.world.data.FamilyTreeNode;
import net.conczin.mca.util.WorldUtils;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3544;
import net.minecraft.class_3730;
import net.minecraft.class_9279;
import net.minecraft.class_9334;

public class BabyItem
extends class_1792 {
    private final Gender gender;

    public BabyItem(Gender gender, class_1792.class_1793 properties) {
        super(properties);
        this.gender = gender;
    }

    public static class_1799 createItem(class_1297 mother, class_1297 father, long seed) {
        Gender gender = Gender.getRandom();
        class_1799 stack = (gender.binary() == Gender.MALE ? ItemsMCA.BABY_BOY : ItemsMCA.BABY_GIRL).method_7854();
        VillagerLike<?> motherVillager = VillagerLike.toVillager(mother);
        VillagerLike<?> fatherVillager = VillagerLike.toVillager(father);
        VillagerEntityMCA child = VillagerFactory.newVillager(mother.method_37908()).withPosition(mother.method_19538()).withGender(gender).withAge(-AgeState.getMaxAge()).build();
        child.getGenetics().combine(motherVillager.getGenetics(), fatherVillager.getGenetics(), seed);
        child.getTraits().inherit(motherVillager.getTraits(), seed);
        child.getTraits().inherit(fatherVillager.getTraits(), seed);
        class_2487 compound = new class_2487();
        child.method_5662(compound);
        stack.method_57379(DataComponentsMCA.BABY_NBT, (Object)class_9279.method_57456((class_2487)compound));
        stack.method_57379(DataComponentsMCA.BABY_AGE, (Object)0);
        stack.method_57379(DataComponentsMCA.BABY_PARENTS, (Object)new BabyParentsComponent(mother.method_5667(), father.method_5667(), mother.method_5477().getString(), father.method_5477().getString()));
        FamilyTree tree = FamilyTree.get((class_3218)mother.method_37908());
        tree.getOrCreate(mother);
        tree.getOrCreate(father);
        return stack;
    }

    public static boolean hasBeenInvalidated(class_1799 stack) {
        return (Boolean)stack.method_57825(DataComponentsMCA.BABY_INVALIDATED, (Object)false);
    }

    private static boolean canGrow(int age) {
        return age >= Config.getServerConfig().babyItemGrowUpTime;
    }

    private static boolean isReadyToGrowUp(class_1799 stack) {
        return BabyItem.canGrow((Integer)stack.method_57825(DataComponentsMCA.BABY_AGE, (Object)0));
    }

    public Gender getGender() {
        return this.gender;
    }

    public class_1269 method_7884(class_1838 context) {
        return class_1269.field_5811;
    }

    public boolean onDropped(class_1799 stack, class_1657 player) {
        if (!BabyItem.hasBeenInvalidated(stack)) {
            if (!player.method_37908().field_9236) {
                int count = (Integer)stack.method_57825(DataComponentsMCA.BABY_DROP_ATTEMPTS, (Object)0) + 1;
                stack.method_57379(DataComponentsMCA.BABY_DROP_ATTEMPTS, (Object)count);
                CriterionMCA.BABY_DROPPED.trigger((class_3222)player, count);
                player.method_7353((class_2561)class_2561.method_43471((String)"item.mca.baby.no_drop"), true);
            }
            return false;
        }
        return true;
    }

    public void method_7888(class_1799 stack, class_1937 world, class_1297 entity, int slot, boolean selected) {
        if (world.field_9236) {
            return;
        }
        if (world.method_8510() % 100L == 0L) {
            stack.method_57379(DataComponentsMCA.BABY_AGE, (Object)((Integer)stack.method_57825(DataComponentsMCA.BABY_AGE, (Object)0) + 100));
        }
    }

    public class_2561 method_7864(class_1799 stack) {
        if (stack.method_57826(class_9334.field_49631)) {
            return class_2561.method_43469((String)(this.method_7866(stack) + ".named"), (Object[])new Object[]{stack.method_57824(class_9334.field_49631)});
        }
        return super.method_7864(stack);
    }

    public String method_7866(class_1799 stack) {
        if (BabyItem.hasBeenInvalidated(stack)) {
            return super.method_7866(stack) + ".blanket";
        }
        return super.method_7866(stack);
    }

    public final class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_1799 stack = player.method_5998(hand);
        if (world.field_9236) {
            return class_1271.method_22430((Object)stack);
        }
        if (!stack.method_57826(class_9334.field_49631)) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                Network.sendToPlayer(new OpenGuiRequest(OpenGuiRequest.Type.BABY_NAME), serverPlayer);
            }
            return class_1271.method_22430((Object)stack);
        }
        if (!BabyItem.isReadyToGrowUp(stack)) {
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.method_7353((class_2561)class_2561.method_43471((String)"item.mca.baby.not_ready"), true);
            }
            return class_1271.method_22430((Object)stack);
        }
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            this.birthChild(stack, (class_3218)world, serverPlayer);
        }
        stack.method_7934(1);
        return class_1271.method_22427((Object)stack);
    }

    protected VillagerEntityMCA birthChild(class_1799 stack, class_3218 world, class_3222 player) {
        VillagerEntityMCA child = VillagerFactory.newVillager((class_1937)world).withPosition(player.method_19538()).withGender(this.gender).withAge(-AgeState.getMaxAge()).build();
        class_2487 savedBaby = ((class_9279)stack.method_57825(DataComponentsMCA.BABY_NBT, (Object)class_9279.field_49302)).method_57461();
        if (!savedBaby.method_33133()) {
            child.method_5749(savedBaby);
        }
        child.method_5665((class_2561)stack.method_57825(class_9334.field_49631, (Object)class_2561.method_43470((String)"Unnamed")));
        WorldUtils.spawnEntity((class_1937)world, (class_1308)child, class_3730.field_16466);
        FamilyTree tree = FamilyTree.get(world);
        child.getRelationships().getFamilyEntry().removeMother();
        child.getRelationships().getFamilyEntry().removeFather();
        BabyParentsComponent parents = (BabyParentsComponent)stack.method_57824(DataComponentsMCA.BABY_PARENTS);
        if (parents != null) {
            Stream.of(parents.mother(), parents.father()).forEach(uuid -> Optional.ofNullable(world.method_14190(uuid)).map(tree::getOrCreate).or(() -> tree.getOrEmpty((UUID)uuid)).ifPresent(entry -> child.getRelationships().getFamilyEntry().assignParent((FamilyTreeNode)entry)));
            Stream.of(parents.mother(), parents.father()).map(arg_0 -> ((class_3218)world).method_14190(arg_0)).filter(Objects::nonNull).filter(e -> e instanceof class_3222).map(class_3222.class::cast).distinct().forEach(ply -> {
                CriterionMCA.FAMILY.trigger((class_3222)ply);
                Memories memories = child.getVillagerBrain().getMemoriesForPlayer((class_1657)ply);
                memories.setHearts(Config.getInstance().childInitialHearts);
            });
        }
        return child;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 flag) {
        BabyParentsComponent parents;
        class_1657 player = ClientProxy.getClientPlayer();
        int age = (Integer)stack.method_57825(DataComponentsMCA.BABY_AGE, (Object)0);
        class_2561 name = (class_2561)stack.method_57824(class_9334.field_49631);
        if (name != null) {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.mca.baby.name", (Object[])new Object[]{name.method_27661().method_54663(this.gender.getColor())}).method_27692(class_124.field_1080));
            if (age > 0) {
                tooltip.add((class_2561)class_2561.method_43469((String)"item.mca.baby.age", (Object[])new Object[]{class_3544.method_15439((int)age, (float)20.0f)}).method_27692(class_124.field_1080));
            }
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.mca.baby.give_name").method_27692(class_124.field_1054));
        }
        if ((parents = (BabyParentsComponent)stack.method_57824(DataComponentsMCA.BABY_PARENTS)) != null) {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.mca.baby.mother", (Object[])new Object[]{player != null && parents.mother().equals(player.method_5667()) ? class_2561.method_43471((String)"item.mca.baby.owner.you") : parents.motherName()}).method_27692(class_124.field_1080));
            tooltip.add((class_2561)class_2561.method_43469((String)"item.mca.baby.father", (Object[])new Object[]{player != null && parents.father().equals(player.method_5667()) ? class_2561.method_43471((String)"item.mca.baby.owner.you") : parents.fatherName()}).method_27692(class_124.field_1080));
        }
        if (stack.method_57826(class_9334.field_49631) && BabyItem.canGrow(age)) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.mca.baby.state.ready").method_27692(class_124.field_1077));
        }
    }
}

