/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.server.world.data;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.function.BiFunction;
import net.conczin.mca.MCA;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.s2c.CustomSkinsChangedMessage;
import net.conczin.mca.resources.data.skin.Clothing;
import net.conczin.mca.resources.data.skin.Hair;
import net.conczin.mca.resources.data.skin.SkinListEntry;
import net.minecraft.class_18;
import net.minecraft.class_2487;
import net.minecraft.class_3222;
import net.minecraft.class_7225;
import net.minecraft.server.MinecraftServer;

public class CustomClothingManager {
    static final Storage<Clothing> CLOTHING_DUMMY = new Storage();
    static final Storage<Hair> HAIR_DUMMY = new Storage();

    public static Storage<Clothing> getClothing() {
        Optional<MinecraftServer> server = MCA.getServer();
        return server.map(minecraftServer -> (Storage)minecraftServer.method_30002().method_17983().method_17924(new class_18.class_8645(Storage::new, (nbt, provider) -> new Storage<Clothing>((class_2487)nbt, Clothing::new), null), "immersive_library_clothing")).orElse(CLOTHING_DUMMY);
    }

    public static Storage<Hair> getHair() {
        Optional<MinecraftServer> server = MCA.getServer();
        return server.map(minecraftServer -> (Storage)minecraftServer.method_30002().method_17983().method_17924(new class_18.class_8645(Storage::new, (nbt, provider) -> new Storage<Hair>((class_2487)nbt, Hair::new), null), "immersive_library_hair")).orElse(HAIR_DUMMY);
    }

    public static class Storage<T extends SkinListEntry>
    extends class_18 {
        final Map<String, T> entries = new HashMap<String, T>();

        public Storage() {
        }

        public Storage(class_2487 nbt, BiFunction<String, JsonObject, T> entryFromNbt) {
            Gson gson = new Gson();
            for (String identifier : nbt.method_10541()) {
                this.entries.put(identifier, (SkinListEntry)entryFromNbt.apply(identifier, (JsonObject)gson.fromJson(nbt.method_10558(identifier), JsonObject.class)));
            }
        }

        public class_2487 method_75(class_2487 nbt, class_7225.class_7874 provider) {
            class_2487 c = new class_2487();
            for (Map.Entry<String, T> entry : this.entries.entrySet()) {
                c.method_10582(entry.getKey(), ((SkinListEntry)entry.getValue()).toJson().toString());
            }
            return c;
        }

        public Map<String, T> getEntries() {
            return this.entries;
        }

        public void addEntry(String id, T entry) {
            this.entries.put(id, entry);
            this.method_80();
        }

        public void removeEntry(String id) {
            this.entries.remove(id);
            this.method_80();
        }

        public void method_80() {
            super.method_80();
            MCA.getServer().ifPresent(s -> {
                for (class_3222 player : s.method_3760().method_14571()) {
                    Network.sendToPlayer(new CustomSkinsChangedMessage(), player);
                }
            });
        }
    }
}

