/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai;

import java.lang.runtime.SwitchBootstraps;
import java.util.Objects;
import java.util.Optional;
import net.conczin.mca.Config;
import net.conczin.mca.MCA;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.Memories;
import net.conczin.mca.entity.ai.Pregnancy;
import net.conczin.mca.entity.ai.Relationship;
import net.conczin.mca.entity.interaction.gifts.GiftType;
import net.conczin.mca.entity.interaction.gifts.Response;
import net.conczin.mca.item.SpecialCaseGift;
import net.conczin.mca.network.Network;
import net.conczin.mca.network.s2c.AnalysisResults;
import net.conczin.mca.registry.CriterionMCA;
import net.conczin.mca.resources.data.Analysis;
import net.conczin.mca.util.InventoryUtils;
import net.conczin.mca.util.network.datasync.CDataManager;
import net.conczin.mca.util.network.datasync.CDataParameter;
import net.conczin.mca.util.network.datasync.CParameter;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1743;
import net.minecraft.class_1769;
import net.minecraft.class_1792;
import net.minecraft.class_1794;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1811;
import net.minecraft.class_1821;
import net.minecraft.class_1829;
import net.minecraft.class_1831;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_4174;
import net.minecraft.class_9334;

public class BreedableRelationship
extends Relationship<VillagerEntityMCA> {
    private static final CDataParameter<Boolean> IS_PROCREATING = CParameter.create("IsProcreating", false);
    private static final CDataParameter<Integer> LAST_PROCREATION = CParameter.create("LastProcreation", 0);
    private final Pregnancy pregnancy;
    private int procreateTick = -1;

    public BreedableRelationship(VillagerEntityMCA entity) {
        super(entity);
        this.pregnancy = new Pregnancy(entity);
    }

    public static <E extends class_1297> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return Relationship.createTrackedData(builder).addAll(IS_PROCREATING, LAST_PROCREATION).add(Pregnancy::createTrackedData);
    }

    public Pregnancy getPregnancy() {
        return this.pregnancy;
    }

    public boolean isProcreating() {
        return (Boolean)((VillagerEntityMCA)this.entity).getTrackedValue(IS_PROCREATING);
    }

    public boolean mayProcreateAgain(long time) {
        int intTime = (int)time;
        Integer trackedValue = (Integer)((VillagerEntityMCA)this.entity).getTrackedValue(LAST_PROCREATION);
        int delta = intTime - trackedValue;
        return trackedValue == 0 || delta < 0 || delta > Config.getInstance().procreationCooldown;
    }

    public void startProcreating(long time) {
        this.procreateTick = 60;
        ((VillagerEntityMCA)this.entity).setTrackedValue(IS_PROCREATING, true);
        ((VillagerEntityMCA)this.entity).setTrackedValue(LAST_PROCREATION, (int)time);
    }

    public void tick(int age) {
        if (age % 20 == 0) {
            this.pregnancy.tick();
        }
        if (!this.isProcreating()) {
            return;
        }
        if (this.procreateTick > 0) {
            --this.procreateTick;
            ((VillagerEntityMCA)this.entity).method_5942().method_6340();
            ((VillagerEntityMCA)this.entity).method_37908().method_8421((class_1297)this.entity, (byte)12);
        } else {
            this.getFamilyTree().getOrCreate((class_1297)this.entity);
            this.getPartner().ifPresent(spouse -> {
                this.pregnancy.procreate((class_1297)spouse);
                ((VillagerEntityMCA)this.entity).setTrackedValue(IS_PROCREATING, false);
            });
        }
    }

    public void giveGift(class_3222 player, Memories memory) {
        class_1799 stack = player.method_6047();
        if (!stack.method_7960() && !this.handleSpecialCaseGift(player, stack)) {
            Optional<GiftType> gift = GiftType.bestMatching((VillagerEntityMCA)this.entity, stack, player);
            if (gift.isPresent()) {
                this.acceptGift(stack, gift.get(), player, memory);
            } else {
                gift = this.handleDynamicGift(stack);
                if (gift.isPresent()) {
                    this.acceptGift(stack, gift.get(), player, memory);
                } else {
                    this.rejectGift((class_1657)player, "gift.fail");
                }
            }
        }
    }

    private Optional<GiftType> handleDynamicGift(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        Objects.requireNonNull(class_17922);
        class_1792 class_17923 = class_17922;
        int n = 0;
        switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{class_1829.class, class_1811.class, class_1831.class, class_1738.class}, (Object)class_17923, n)) {
            case 0: {
                class_1829 ignored = (class_1829)class_17923;
                double satisfaction = InventoryUtils.approximateDamage(stack, (class_1309)this.entity);
                satisfaction = (float)(Math.pow(satisfaction, 1.25) * 2.0);
                return Optional.of(new GiftType(stack.method_7909(), (int)satisfaction, MCA.locate("swords")));
            }
            case 1: {
                class_1811 ranged = (class_1811)class_17923;
                float satisfaction = ranged.method_24792();
                satisfaction = (float)(Math.pow(satisfaction, 1.25) * 2.0);
                return Optional.of(new GiftType(stack.method_7909(), (int)satisfaction, MCA.locate("archery")));
            }
            case 2: {
                class_1831 tool = (class_1831)class_17923;
                float satisfaction = tool.method_8022().method_8027();
                satisfaction = (float)(Math.pow(satisfaction, 1.25) * 2.0);
                return Optional.of(new GiftType(stack.method_7909(), (int)satisfaction, MCA.locate(stack.method_7909() instanceof class_1743 ? "swords" : (stack.method_7909() instanceof class_1794 ? "hoes" : (stack.method_7909() instanceof class_1821 ? "shovels" : "pickaxes")))));
            }
            case 3: {
                class_1738 armor = (class_1738)class_17923;
                int satisfaction = (int)(Math.pow(armor.method_7687(), 1.25) * 1.5 + (double)(armor.method_26353() * 5.0f));
                return Optional.of(new GiftType(stack.method_7909(), satisfaction, MCA.locate("armor")));
            }
        }
        class_4174 component = (class_4174)stack.method_57824(class_9334.field_50075);
        if (component != null) {
            int satisfaction = (int)((float)component.comp_2491() + component.comp_2492() * 3.0f);
            return Optional.of(new GiftType(stack.method_7909(), satisfaction, MCA.locate("food")));
        }
        return Optional.empty();
    }

    private void acceptGift(class_1799 stack, GiftType gift, class_3222 player, Memories memory) {
        if (!((VillagerEntityMCA)this.entity).method_35199().method_27070(stack)) {
            this.rejectGift((class_1657)player, "villager.inventory.full");
            return;
        }
        Analysis analysis = gift.getSatisfactionFor((VillagerEntityMCA)this.entity, stack, player);
        int satisfaction = analysis.getTotal();
        Response response = gift.getResponse(satisfaction);
        int occurrences = this.getGiftSaturation().get(stack);
        int penalty = (int)((double)((float)occurrences * Config.getInstance().giftDesaturationFactor) * Math.pow(Math.max((double)satisfaction, 0.0), Config.getInstance().giftDesaturationExponent));
        if (penalty != 0) {
            analysis.add("desaturation", -penalty);
        }
        int desaturatedSatisfaction = analysis.getTotal();
        Response desaturatedResponse = gift.getResponse(desaturatedSatisfaction);
        desaturatedSatisfaction = (int)((double)desaturatedSatisfaction * Config.getInstance().giftSatisfactionFactor);
        Network.sendToPlayer(new AnalysisResults(analysis), player);
        if (response == Response.FAIL) {
            this.rejectGift((class_1657)player, gift.getDialogueFor(response));
        } else if (desaturatedResponse == Response.FAIL) {
            this.rejectGift((class_1657)player, "gift.saturated");
        } else {
            ((VillagerEntityMCA)this.entity).sendChatMessage((class_1657)player, gift.getDialogueFor(response), new Object[0]);
            if (response == Response.BEST) {
                ((VillagerEntityMCA)this.entity).playSurprisedSound();
            }
            this.getGiftSaturation().add(stack);
            ((VillagerEntityMCA)this.entity).method_37908().method_8421((class_1297)this.entity, (byte)16);
            ((VillagerEntityMCA)this.entity).method_35199().method_5491(stack.method_7971(1));
        }
        ((VillagerEntityMCA)this.entity).getVillagerBrain().modifyMoodValue((int)((float)desaturatedSatisfaction * Config.getInstance().giftMoodEffect + Config.getInstance().baseGiftMoodEffect * (float)class_3532.method_17822((double)desaturatedSatisfaction)));
        CriterionMCA.HEARTS.trigger(player, memory.getHearts(), desaturatedSatisfaction, "gift");
        memory.modHearts(desaturatedSatisfaction);
    }

    private void rejectGift(class_1657 player, String dialogue) {
        ((VillagerEntityMCA)this.entity).method_37908().method_8421((class_1297)this.entity, (byte)15);
        ((VillagerEntityMCA)this.entity).sendChatMessage(player, dialogue, new Object[0]);
    }

    private boolean handleSpecialCaseGift(class_3222 player, class_1799 stack) {
        class_1792 item = stack.method_7909();
        if (item instanceof SpecialCaseGift) {
            if (((SpecialCaseGift)item).handle(player, (VillagerEntityMCA)this.entity)) {
                stack.method_7934(1);
            }
            return true;
        }
        if (item == class_1802.field_17534 && !((VillagerEntityMCA)this.entity).method_6109()) {
            if (this.pregnancy.tryStartGestation()) {
                player.method_37908().method_8421((class_1297)this.entity, (byte)12);
                stack.method_7934(1);
                ((VillagerEntityMCA)this.entity).sendChatMessage((class_1657)player, "gift.cake.success", new Object[0]);
            } else {
                ((VillagerEntityMCA)this.entity).sendChatMessage((class_1657)player, "gift.cake.fail", new Object[0]);
            }
            return true;
        }
        if (item == class_1802.field_8463 && ((VillagerEntityMCA)this.entity).isInfected()) {
            ((VillagerEntityMCA)this.entity).setInfected(false);
            ((VillagerEntityMCA)this.entity).method_60492(((VillagerEntityMCA)this.entity).method_37908(), stack);
            stack.method_7934(1);
            return true;
        }
        if (item instanceof class_1769) {
            class_1769 dye = (class_1769)item;
            ((VillagerEntityMCA)this.entity).setHairDye(dye.method_7802());
            stack.method_7934(1);
            return true;
        }
        if (item == class_1802.field_8554) {
            ((VillagerEntityMCA)this.entity).clearHairDye();
            stack.method_7934(1);
            return true;
        }
        if (item == class_1802.field_8463 && ((VillagerEntityMCA)this.entity).method_6109()) {
            ((VillagerEntityMCA)this.entity).method_5615(24000);
            stack.method_7934(1);
            return true;
        }
        return false;
    }
}

