/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai;

import java.util.Optional;
import java.util.stream.Stream;
import net.conczin.mca.Config;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.ai.MemoryModuleTypeMCA;
import net.conczin.mca.entity.ai.MoveState;
import net.conczin.mca.server.world.data.GraveyardManager;
import net.conczin.mca.server.world.data.Village;
import net.conczin.mca.server.world.data.VillageManager;
import net.conczin.mca.util.network.datasync.CDataManager;
import net.conczin.mca.util.network.datasync.CDataParameter;
import net.conczin.mca.util.network.datasync.CParameter;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3852;
import net.minecraft.class_4140;
import net.minecraft.class_4153;
import net.minecraft.class_4208;
import net.minecraft.class_5321;
import net.minecraft.class_7477;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;

public class Residency {
    private static final CDataParameter<Integer> VILLAGE = CParameter.create("HomeVillage", -1);
    private final VillagerEntityMCA entity;

    public Residency(VillagerEntityMCA entity) {
        this.entity = entity;
    }

    public static <E extends class_1297> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return builder.addAll(VILLAGE);
    }

    public class_2338 getWorkplace() {
        return this.entity.method_18868().method_46873(class_4140.field_18439).map(class_4208::comp_2208).orElse(class_2338.field_10980);
    }

    public void setWorkplace(class_3222 player) {
        class_4153 pointOfInterestStorage = ((class_3218)player.method_37908()).method_19494();
        pointOfInterestStorage.method_34712(class_3852.field_17051.comp_820(), a -> true, this.entity.method_24515(), 8, class_4153.class_4155.field_18487).ifPresentOrElse(blockPos -> pointOfInterestStorage.method_19132(blockPos).ifPresent(pointOfInterestType -> {
            pointOfInterestStorage.method_19126(class_3852.field_17051.comp_820(), (registryEntry, blockPos2) -> blockPos2.equals(blockPos), blockPos, 1);
            this.entity.method_19176(class_4140.field_25160);
            this.entity.method_18868().method_18875(class_4140.field_25160);
            this.entity.method_19176(class_4140.field_18439);
            this.entity.method_18868().method_18875(class_4140.field_18439);
            class_4208 globalPos = class_4208.method_19443((class_5321)player.method_37908().method_27983(), (class_2338)blockPos);
            this.entity.method_18868().method_18878(class_4140.field_18439, (Object)globalPos);
            player.method_37908().method_8421((class_1297)this.entity, (byte)14);
            MinecraftServer minecraftServer = player.method_37908().method_8503();
            Optional.ofNullable(minecraftServer.method_3847(globalPos.comp_2207())).flatMap(world -> world.method_19494().method_19132(globalPos.comp_2208())).flatMap(registryEntry -> class_7923.field_41195.method_10220().filter(profession -> profession.comp_819().test(registryEntry)).findFirst()).ifPresent(profession -> {
                int level = this.entity.method_7231().method_16925();
                this.entity.method_7195(this.entity.method_7231().method_16921(profession).method_16920(1));
                this.entity.method_16917(null);
                this.entity.method_8264();
                for (int l = 1; l < level; ++l) {
                    this.entity.customLevelUp();
                }
                this.entity.method_19179((class_3218)player.method_37908());
            });
            this.entity.sendChatMessage((class_1657)player, "interaction.setworkplace.success", new Object[0]);
        }), () -> this.entity.sendChatMessage((class_1657)player, "interaction.setworkplace.failed", new Object[0]));
    }

    public Optional<Village> getHomeVillage() {
        VillageManager manager = VillageManager.get((class_3218)this.entity.method_37908());
        return manager.getOrEmpty((Integer)this.entity.getTrackedValue(VILLAGE));
    }

    public void seekHome() {
        if (this.entity.requiresHome()) {
            VillageManager manager = VillageManager.get((class_3218)this.entity.method_37908());
            manager.findNearestVillage((class_1297)this.entity).ifPresent(v -> {
                this.leaveHome();
                v.updateResident(this.entity);
                this.entity.setTrackedValue(VILLAGE, v.getId());
            });
        }
    }

    public void leaveHome() {
        Optional<Village> village = this.getHomeVillage();
        village.ifPresent(v -> v.removeResident(this.entity));
        this.entity.setTrackedValue(VILLAGE, -1);
    }

    public void tick() {
        if (this.entity.field_6012 % 600 == 0 && this.entity.requiresHome()) {
            Optional<Village> village2 = this.getHomeVillage();
            if (village2.isEmpty() && Config.getInstance().enableAutoScanByDefault || village2.filter(Village::isAutoScan).isPresent()) {
                this.reportBuildings();
            }
            if (village2.isEmpty()) {
                this.seekHome();
            }
        }
        if (this.entity.field_6012 % 1200 == 0) {
            this.getHomeVillage().ifPresentOrElse(village -> this.entity.method_37908().method_18456().forEach(player -> {
                int hearts = this.entity.getVillagerBrain().getMemoriesForPlayer((class_1657)player).getHearts();
                village.setReputation((class_1657)player, this.entity, hearts);
            }), this::leaveHome);
        }
    }

    private void reportBuildings() {
        VillageManager manager = VillageManager.get((class_3218)this.entity.method_37908());
        Stream stream = ((class_3218)this.entity.method_37908()).method_19494().method_21647(type -> true, p -> !manager.cache.contains(p), this.entity.method_24515(), 48, class_4153.class_4155.field_18489);
        stream.forEach(manager::reportBuilding);
        GraveyardManager.get((class_3218)this.entity.method_37908()).reportToVillageManager((class_1297)this.entity);
    }

    public Optional<class_4208> getHome() {
        return this.entity.getMCABrain().method_46873(class_4140.field_18438);
    }

    public void setHome(class_3222 player) {
        if (!this.entity.requiresHome()) {
            this.entity.sendChatMessage((class_1657)player, "interaction.sethome.temporary", new Object[0]);
            return;
        }
        VillageManager manager = VillageManager.get((class_3218)player.method_37908());
        manager.processBuilding(player.method_24515(), true, false);
        this.seekHome();
        class_4153 pointOfInterestStorage = ((class_3218)player.method_37908()).method_19494();
        Optional position = pointOfInterestStorage.method_21647(registryEntry -> registryEntry.method_40225(class_7477.field_39291), p -> true, player.method_24515(), 8, class_4153.class_4155.field_18487).findAny();
        if (position.isPresent()) {
            this.entity.sendChatMessage((class_1657)player, "interaction.sethome.success", new Object[0]);
            this.entity.method_18868().method_46873(class_4140.field_18438).ifPresent(p -> {
                this.entity.method_19176(class_4140.field_18438);
                this.entity.method_18868().method_18875(class_4140.field_18438);
            });
            pointOfInterestStorage.method_19126(registryEntry -> registryEntry.method_40225(class_7477.field_39291), (p, q) -> true, (class_2338)position.get(), 1);
            this.entity.method_18868().method_18878(class_4140.field_18438, (Object)class_4208.method_19443((class_5321)this.entity.method_37908().method_27983(), (class_2338)((class_2338)position.get())));
            this.entity.method_18868().method_18878(MemoryModuleTypeMCA.FORCED_HOME, (Object)true);
            this.seekHome();
        } else {
            this.entity.method_18868().method_18875(MemoryModuleTypeMCA.FORCED_HOME);
            this.getHomeVillage().map(v -> v.getBuildingAt((class_2382)this.entity.method_24515())).filter(Optional::isPresent).map(Optional::get).filter(b -> b.getBuildingType().noBeds()).ifPresentOrElse(building -> this.entity.sendChatMessage((class_1657)player, "interaction.sethome.bedfail." + building.getBuildingType().name(), new Object[0]), () -> this.entity.sendChatMessage((class_1657)player, "interaction.sethome.bedfail", new Object[0]));
        }
    }

    public void goHome(class_1657 player) {
        this.entity.getVillagerBrain().setMoveState(MoveState.MOVE, player);
        this.entity.getInteractions().stopInteracting();
        this.getHome().filter(p -> p.comp_2207() == this.entity.method_37908().method_27983()).ifPresentOrElse(home -> {
            this.entity.moveTowards(home.comp_2208());
            this.entity.sendChatMessage(player, "interaction.gohome.success", new Object[0]);
        }, () -> this.entity.sendChatMessage(player, "interaction.gohome.fail.nohome", new Object[0]));
    }
}

