/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.entity.ai;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.conczin.mca.Config;
import net.conczin.mca.entity.VillagerLike;
import net.conczin.mca.util.network.datasync.CDataManager;
import net.conczin.mca.util.network.datasync.CDataParameter;
import net.conczin.mca.util.network.datasync.CParameter;
import net.minecraft.class_1297;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_5819;

public class Traits {
    public static final Map<String, Trait> TRAIT_REGISTRY = new HashMap<String, Trait>();
    private static final CDataParameter<class_2487> TRAITS = CParameter.create("Traits", new class_2487());
    public static Trait ATHLETIC = Traits.registerTrait("athletic", 1.0f, 0.5f, false);
    public static Trait LEFT_HANDED = Traits.registerTrait("left_handed", 1.0f, 0.5f, false);
    public static Trait WEAK = Traits.registerTrait("weak", 1.0f, 1.0f, false);
    public static Trait TOUGH = Traits.registerTrait("tough", 1.0f, 1.0f, false);
    public static Trait COLOR_BLIND = Traits.registerTrait("color_blind", 1.0f, 0.5f);
    public static Trait HETEROCHROMIA = Traits.registerTrait("heterochromia", 1.0f, 0.5f);
    public static Trait LACTOSE_INTOLERANCE = Traits.registerTrait("lactose_intolerance", 1.0f, 1.0f);
    public static Trait COELIAC_DISEASE = Traits.registerTrait("coeliac_disease", 1.0f, 1.0f, false);
    public static Trait DIABETES = Traits.registerTrait("diabetes", 1.0f, 1.0f, false);
    public static Trait DWARFISM = Traits.registerTrait("dwarfism", 1.0f, 1.0f);
    public static Trait ALBINISM = Traits.registerTrait("albinism", 1.0f, 1.0f);
    public static Trait VEGETARIAN = Traits.registerTrait("vegetarian", 1.0f, 1.0f, false);
    public static Trait BISEXUAL = Traits.registerTrait("bisexual", 1.0f, 0.0f);
    public static Trait HOMOSEXUAL = Traits.registerTrait("homosexual", 1.0f, 0.0f);
    public static Trait ASEXUAL = Traits.registerTrait("asexual", 1.0f, 0.0f);
    public static Trait ELECTRIFIED = Traits.registerTrait("electrified", 0.0f, 0.0f, false);
    public static Trait SIRBEN = Traits.registerTrait("sirben", 0.025f, 1.0f);
    public static Trait RAINBOW = Traits.registerTrait("rainbow", 0.05f, 0.0f);
    public static Trait UNKNOWN = Traits.registerTrait("unknown", 0.0f, 0.0f, false);
    private final VillagerLike<?> entity;
    private class_5819 random = class_5819.method_43047();

    public Traits(VillagerLike<?> entity) {
        this.entity = entity;
    }

    public static Trait registerTrait(String id, float chance, float inherit, boolean usableOnPlayer) {
        Trait trait = new Trait(id, chance, inherit, usableOnPlayer);
        TRAIT_REGISTRY.put(id, trait);
        return trait;
    }

    public static Trait registerTrait(String id, float chance, float inherit) {
        return Traits.registerTrait(id, chance, inherit, true);
    }

    public static <E extends class_1297> CDataManager.Builder<E> createTrackedData(CDataManager.Builder<E> builder) {
        return builder.addAll(TRAITS);
    }

    public Set<Trait> getTraits() {
        return ((class_2487)this.entity.getTrackedValue(TRAITS)).method_10541().stream().map(Trait::valueOf).collect(Collectors.toSet());
    }

    public Set<Trait> getInheritedTraits() {
        return this.getTraits().stream().filter(t -> this.random.method_43057() < t.inherit * Config.getInstance().traitInheritChance).collect(Collectors.toSet());
    }

    public boolean hasTrait(VillagerLike<?> target, Trait trait) {
        return ((class_2487)target.getTrackedValue(TRAITS)).method_10545(trait.id());
    }

    public boolean hasTrait(Trait trait) {
        return this.hasTrait(this.entity, trait);
    }

    public boolean hasTrait(String trait) {
        if (Trait.valueOf(trait) != null) {
            return this.hasTrait(this.entity, Trait.valueOf(trait));
        }
        return false;
    }

    public boolean eitherHaveTrait(Trait trait, VillagerLike<?> other) {
        return this.hasTrait(this.entity, trait) || this.hasTrait(other, trait);
    }

    public boolean hasSameTrait(Trait trait, VillagerLike<?> other) {
        return this.hasTrait(this.entity, trait) && this.hasTrait(other, trait);
    }

    public void addTrait(Trait trait) {
        class_2487 traits = ((class_2487)this.entity.getTrackedValue(TRAITS)).method_10553();
        traits.method_10556(trait.id(), true);
        this.entity.setTrackedValue(TRAITS, traits);
    }

    public void removeTrait(Trait trait) {
        class_2487 traits = ((class_2487)this.entity.getTrackedValue(TRAITS)).method_10553();
        traits.method_10551(trait.id());
        this.entity.setTrackedValue(TRAITS, traits);
    }

    public void randomize() {
        float total = (float)Trait.values().stream().mapToDouble(tr -> tr.chance).sum();
        for (Trait t : Trait.values()) {
            float chance = Config.getInstance().traitChance / total * t.chance;
            if (!(this.random.method_43057() < chance) || !t.isEnabled()) continue;
            this.addTrait(t);
        }
    }

    public void inherit(Traits from) {
        for (Trait t : from.getInheritedTraits()) {
            this.addTrait(t);
        }
    }

    public void inherit(Traits from, long seed) {
        class_5819 old = this.random;
        this.random = class_5819.method_43049((long)seed);
        this.inherit(from);
        this.random = old;
    }

    public float getVerticalScaleFactor() {
        return this.hasTrait(DWARFISM) ? 0.65f : 1.0f;
    }

    public float getHorizontalScaleFactor() {
        return (this.hasTrait(DWARFISM) ? 0.85f : 1.0f) * (this.hasTrait(TOUGH) ? 1.2f : 1.0f) * (this.hasTrait(WEAK) ? 0.85f : 1.0f);
    }

    public static class Trait {
        private final String id;
        private final float chance;
        private final float inherit;
        private final boolean usableOnPlayer;

        Trait(String id, float chance, float inherit, boolean usableOnPlayer) {
            this.id = id;
            this.chance = chance;
            this.inherit = inherit;
            this.usableOnPlayer = usableOnPlayer;
        }

        public static Collection<Trait> values() {
            return TRAIT_REGISTRY.values();
        }

        public static Trait valueOf(String id) {
            return TRAIT_REGISTRY.getOrDefault(id, UNKNOWN);
        }

        public String id() {
            return this.id;
        }

        public class_2561 getName() {
            return class_2561.method_43471((String)("trait." + this.id()));
        }

        public class_2561 getDescription() {
            return class_2561.method_43471((String)("traitDescription." + this.id()));
        }

        public boolean isUsableOnPlayer() {
            return this.usableOnPlayer;
        }

        public boolean isEnabled() {
            return Config.getServerConfig().enabledTraits.getOrDefault(this.id(), false);
        }
    }
}

