/*
 * Decompiled with CFR 0.152.
 */
package net.conczin.mca.network;

import net.conczin.mca.Config;
import net.conczin.mca.MCAClient;
import net.conczin.mca.client.book.Book;
import net.conczin.mca.client.book.CivilRegistryBook;
import net.conczin.mca.client.gui.BlueprintScreen;
import net.conczin.mca.client.gui.CombScreen;
import net.conczin.mca.client.gui.ExtendedBookScreen;
import net.conczin.mca.client.gui.FamilyTreeScreen;
import net.conczin.mca.client.gui.FamilyTreeSearchScreen;
import net.conczin.mca.client.gui.InteractScreen;
import net.conczin.mca.client.gui.LimitedVillagerEditorScreen;
import net.conczin.mca.client.gui.NameBabyScreen;
import net.conczin.mca.client.gui.NeedleScreen;
import net.conczin.mca.client.gui.SkinListUpdateListener;
import net.conczin.mca.client.gui.VillagerEditorScreen;
import net.conczin.mca.client.gui.VillagerTrackerSearchScreen;
import net.conczin.mca.client.gui.WhistleScreen;
import net.conczin.mca.client.tts.SpeechManager;
import net.conczin.mca.entity.VillagerEntityMCA;
import net.conczin.mca.entity.VillagerLike;
import net.conczin.mca.item.BabyItem;
import net.conczin.mca.item.ExtendedWrittenBookItem;
import net.conczin.mca.network.ClientHandler;
import net.conczin.mca.network.s2c.AnalysisResults;
import net.conczin.mca.network.s2c.BabyNameResponse;
import net.conczin.mca.network.s2c.CivilRegistryResponse;
import net.conczin.mca.network.s2c.ConfigResponse;
import net.conczin.mca.network.s2c.CustomSkinsChangedMessage;
import net.conczin.mca.network.s2c.FamilyTreeUUIDResponse;
import net.conczin.mca.network.s2c.GetFamilyResponse;
import net.conczin.mca.network.s2c.GetFamilyTreeResponse;
import net.conczin.mca.network.s2c.GetInteractDataResponse;
import net.conczin.mca.network.s2c.GetVillageFailedResponse;
import net.conczin.mca.network.s2c.GetVillageResponse;
import net.conczin.mca.network.s2c.GetVillagerResponse;
import net.conczin.mca.network.s2c.InteractionDialogueQuestionResponse;
import net.conczin.mca.network.s2c.InteractionDialogueResponse;
import net.conczin.mca.network.s2c.OpenDestinyGuiRequest;
import net.conczin.mca.network.s2c.OpenGuiRequest;
import net.conczin.mca.network.s2c.PlayerDataMessage;
import net.conczin.mca.network.s2c.ShowToastRequest;
import net.conczin.mca.network.s2c.SkinListResponse;
import net.conczin.mca.network.s2c.VillagerMessage;
import net.conczin.mca.network.s2c.VillagerNameResponse;
import net.conczin.mca.registry.EntitiesMCA;
import net.conczin.mca.resources.BuildingTypes;
import net.conczin.mca.server.world.data.Village;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_370;
import net.minecraft.class_374;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_7923;

public class ClientHandlerImpl
implements ClientHandler {
    private final class_310 client = class_310.method_1551();

    @Override
    public void handleGuiRequest(OpenGuiRequest message) {
        assert (this.client.field_1687 != null);
        assert (class_310.method_1551().field_1724 != null);
        switch (message.getGui()) {
            case WHISTLE: {
                this.client.method_1507((class_437)new WhistleScreen());
                break;
            }
            case BOOK: {
                class_1799 item;
                class_1792 class_17922;
                if (this.client.field_1724 == null || !((class_17922 = (item = this.client.field_1724.method_5998(class_1268.field_5808)).method_7909()) instanceof ExtendedWrittenBookItem)) break;
                ExtendedWrittenBookItem bookItem = (ExtendedWrittenBookItem)class_17922;
                Book book = bookItem.getBook(item);
                this.client.method_1507((class_437)new ExtendedBookScreen(book));
                break;
            }
            case BLUEPRINT: {
                this.client.method_1507((class_437)new BlueprintScreen());
                break;
            }
            case INTERACT: {
                class_1799 item;
                boolean isOnBlacklist;
                if (this.client.field_1724 == null || (isOnBlacklist = Config.getInstance().villagerInteractionItemBlacklist.contains(class_7923.field_41178.method_10221((Object)(item = this.client.field_1724.method_5998(class_1268.field_5808)).method_7909()).toString()))) break;
                VillagerLike villager = (VillagerLike)this.client.field_1687.method_8469(message.villager());
                this.client.method_1507((class_437)new InteractScreen(villager));
                break;
            }
            case VILLAGER_EDITOR: {
                class_1297 entity = this.client.field_1687.method_8469(message.villager());
                assert (entity != null);
                this.client.method_1507((class_437)new VillagerEditorScreen(entity.method_5667(), class_310.method_1551().field_1724.method_5667()));
                break;
            }
            case LIMITED_VILLAGER_EDITOR: {
                class_1297 entity = this.client.field_1687.method_8469(message.villager());
                assert (entity != null);
                this.client.method_1507((class_437)new LimitedVillagerEditorScreen(entity.method_5667(), class_310.method_1551().field_1724.method_5667()));
                break;
            }
            case NEEDLE_AND_THREAD: {
                class_1297 entity = this.client.field_1687.method_8469(message.villager());
                if (entity == null) {
                    this.client.method_1507((class_437)new NeedleScreen(class_310.method_1551().field_1724.method_5667()));
                    break;
                }
                this.client.method_1507((class_437)new NeedleScreen(entity.method_5667(), class_310.method_1551().field_1724.method_5667()));
                break;
            }
            case COMB: {
                class_1297 entity = this.client.field_1687.method_8469(message.villager());
                if (entity == null) {
                    this.client.method_1507((class_437)new CombScreen(class_310.method_1551().field_1724.method_5667()));
                    break;
                }
                this.client.method_1507((class_437)new CombScreen(entity.method_5667(), class_310.method_1551().field_1724.method_5667()));
                break;
            }
            case BABY_NAME: {
                class_1799 item;
                if (this.client.field_1724 == null || !((item = this.client.field_1724.method_5998(class_1268.field_5808)).method_7909() instanceof BabyItem)) break;
                this.client.method_1507((class_437)new NameBabyScreen((class_1657)this.client.field_1724, item));
                break;
            }
            case FAMILY_TREE: {
                this.client.method_1507((class_437)new FamilyTreeSearchScreen());
                break;
            }
            case VILLAGER_TRACKER: {
                this.client.method_1507((class_437)new VillagerTrackerSearchScreen());
                break;
            }
        }
    }

    @Override
    public void handleFamilyTreeResponse(GetFamilyTreeResponse message) {
        class_437 screen = this.client.field_1755;
        if (screen instanceof FamilyTreeScreen) {
            FamilyTreeScreen gui = (FamilyTreeScreen)screen;
            gui.setFamilyData(message.uuid(), message.family());
        }
    }

    @Override
    public void handleInteractDataResponse(GetInteractDataResponse message) {
        class_437 screen = this.client.field_1755;
        if (screen instanceof InteractScreen) {
            InteractScreen gui = (InteractScreen)screen;
            gui.setConstraints(message.constraints());
            gui.setParents(message.father().orElse(null), message.mother().orElse(null));
            gui.setSpouse(message.marriageState(), message.spouse().orElse(null));
        }
    }

    @Override
    public void handleVillageDataResponse(GetVillageResponse message) {
        class_437 screen = this.client.field_1755;
        if (screen instanceof BlueprintScreen) {
            BlueprintScreen gui = (BlueprintScreen)screen;
            BuildingTypes.getInstance().setBuildingTypes(message.buildingTypes());
            Village village = new Village(message.getData(), null);
            gui.setVillage(village);
            gui.setVillageData(message.rank(), message.reputation(), message.isVillage(), message.ids(), message.tasks());
        }
    }

    @Override
    public void handleVillageDataFailedResponse(GetVillageFailedResponse message) {
        class_437 screen = this.client.field_1755;
        if (screen instanceof BlueprintScreen) {
            BlueprintScreen gui = (BlueprintScreen)screen;
            gui.setVillage(null);
        }
    }

    @Override
    public void handleFamilyDataResponse(GetFamilyResponse message) {
        class_437 screen = this.client.field_1755;
        if (screen instanceof WhistleScreen) {
            WhistleScreen gui = (WhistleScreen)screen;
            gui.setVillagerData(message.getData());
        }
    }

    @Override
    public void handleVillagerDataResponse(GetVillagerResponse message) {
        class_437 screen = this.client.field_1755;
        if (screen instanceof VillagerEditorScreen) {
            VillagerEditorScreen gui = (VillagerEditorScreen)screen;
            gui.setVillagerData(message.getData());
        }
    }

    @Override
    public void handleDialogueResponse(InteractionDialogueResponse message) {
        class_437 screen = this.client.field_1755;
        if (screen instanceof InteractScreen) {
            InteractScreen gui = (InteractScreen)screen;
            gui.setDialogue(message.question(), message.answers());
        }
    }

    @Override
    public void handleDialogueQuestionResponse(InteractionDialogueQuestionResponse message) {
        class_437 screen = this.client.field_1755;
        if (screen instanceof InteractScreen) {
            InteractScreen gui = (InteractScreen)screen;
            gui.setLastPhrase(message.questionText(), message.silent());
        }
    }

    @Override
    public void handleSkinListResponse(AnalysisResults message) {
        InteractScreen.setAnalysis(message.analysis());
    }

    @Override
    public void handleBabyNameResponse(BabyNameResponse message) {
        class_437 screen = this.client.field_1755;
        if (screen instanceof NameBabyScreen) {
            NameBabyScreen gui = (NameBabyScreen)screen;
            gui.setBabyName(message.name());
        }
    }

    @Override
    public void handleVillagerNameResponse(VillagerNameResponse message) {
        class_437 screen = this.client.field_1755;
        if (screen instanceof VillagerEditorScreen) {
            VillagerEditorScreen gui = (VillagerEditorScreen)screen;
            gui.setVillagerName(message.name());
        }
    }

    @Override
    public void handleToastMessage(ShowToastRequest message) {
        class_370.method_27024((class_374)this.client.method_1566(), (class_370.class_9037)class_370.class_9037.field_47588, (class_2561)message.getTitle(), (class_2561)message.getMessage());
    }

    @Override
    public void handleFamilyTreeUUIDResponse(FamilyTreeUUIDResponse response) {
        class_437 screen = this.client.field_1755;
        if (screen instanceof FamilyTreeSearchScreen) {
            FamilyTreeSearchScreen gui = (FamilyTreeSearchScreen)screen;
            gui.setList(response.list());
        }
    }

    @Override
    public void handlePlayerDataMessage(PlayerDataMessage response) {
        assert (this.client.field_1687 != null);
        VillagerEntityMCA villager = (VillagerEntityMCA)EntitiesMCA.MALE_VILLAGER.method_5883((class_1937)this.client.field_1687);
        assert (villager != null);
        villager.method_5749(response.nbt());
        MCAClient.addPlayerData(response.uuid(), villager);
    }

    @Override
    public void handleSkinListResponse(SkinListResponse message) {
        class_437 screen = this.client.field_1755;
        VillagerEditorScreen.setSkinList(message.clothing(), message.hair());
        if (screen instanceof SkinListUpdateListener) {
            SkinListUpdateListener gui = (SkinListUpdateListener)screen;
            gui.skinListUpdatedCallback();
        }
    }

    @Override
    public void handleDestinyGuiRequest(OpenDestinyGuiRequest message) {
        MCAClient.getDestinyManager().requestOpen(message.allowTeleportation());
    }

    @Override
    public void handleConfigResponse(ConfigResponse message) {
        Config.setServerConfig(message.getConfig());
    }

    @Override
    public void handleVillagerMessage(VillagerMessage message) {
        class_5250 full = message.prefix().method_27661().method_10852(message.message());
        this.client.method_44714().method_44736((class_2561)full, false);
        SpeechManager.INSTANCE.onChatMessage(message.message(), message.uuid());
    }

    @Override
    public void handleCustomSkinsChangedMessage(CustomSkinsChangedMessage message) {
        VillagerEditorScreen.setSkinListOutdated();
    }

    @Override
    public void handleCivilRegistryResponse(CivilRegistryResponse response) {
        ExtendedBookScreen extendedBookScreen;
        Book book;
        class_437 screen = this.client.field_1755;
        if (screen instanceof ExtendedBookScreen && (book = (extendedBookScreen = (ExtendedBookScreen)screen).getBook()) instanceof CivilRegistryBook) {
            CivilRegistryBook civilRegistryBook = (CivilRegistryBook)book;
            civilRegistryBook.receive(response.getIndex(), response.getLines());
        }
    }
}

